/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.dtresourceprovider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.pagedesigner.dtresourceprovider.DTResourceProviderFactory;
import org.eclipse.jst.pagedesigner.dtresourceprovider.IDTResourceProvider;
import org.eclipse.jst.pagedesigner.dtresourceprovider.IDTSkin;
import org.eclipse.jst.pagedesigner.utils.StructuredModelUtil;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DTSkinManager {
    private static Map<IProject, DTSkinManager> dtSkinManagerMap = new HashMap<IProject, DTSkinManager>();
    private Map<String, IDTSkin> currentDTSkinMap;
    private IProject project;

    private DTSkinManager(IProject project) {
        this.project = project;
        this.currentDTSkinMap = new HashMap<String, IDTSkin>();
    }

    public static synchronized DTSkinManager getInstance(IProject aProject) {
        DTSkinManager dtSkinManager = dtSkinManagerMap.get(aProject);
        if (dtSkinManager == null) {
            dtSkinManager = new DTSkinManager(aProject);
            dtSkinManagerMap.put(aProject, dtSkinManager);
        }
        return dtSkinManager;
    }

    public static DTSkinManager getInstance(IDOMNode domNode) {
        IDOMModel domModel = domNode.getModel();
        IProject aProject = null;
        if (domModel != null) {
            aProject = StructuredModelUtil.getProjectFor((IStructuredModel)domModel);
        }
        return DTSkinManager.getInstance(aProject);
    }

    public List<IDTSkin> getSkins(String id) {
        ArrayList<IDTSkin> dtSkins = new ArrayList<IDTSkin>();
        List<IDTResourceProvider> dtResourceProviders = DTResourceProviderFactory.getInstance().getActiveDTResourceProviders(this.project);
        for (IDTResourceProvider dtResourceProvider : dtResourceProviders) {
            if (!dtResourceProvider.getId().equals(id)) continue;
            dtSkins.addAll(dtResourceProvider.getSkins());
        }
        return dtSkins;
    }

    public IDTSkin getCurrentSkin(String id) {
        IDTSkin dtSkin = this.currentDTSkinMap.get(id);
        if (dtSkin == null) {
            dtSkin = this.getDefaultSkin(id);
            this.setCurrentSkin(id, dtSkin);
        }
        return dtSkin;
    }

    public void setCurrentSkin(String id, IDTSkin dtSkin) {
        if (id != null) {
            IDTSkin existingDTSkin = this.currentDTSkinMap.get(id);
            if (existingDTSkin != null) {
                existingDTSkin.releaseResources();
            }
            if (dtSkin != null) {
                this.currentDTSkinMap.put(id, dtSkin);
            } else {
                this.currentDTSkinMap.remove(id);
            }
        }
    }

    public List<IDTSkin> getCurrentSkins() {
        ArrayList<IDTSkin> currentDTSkins = new ArrayList<IDTSkin>();
        List<IDTResourceProvider> dtResourceProviders = DTResourceProviderFactory.getInstance().getActiveDTResourceProviders(this.project);
        for (IDTResourceProvider dtResourceProvider : dtResourceProviders) {
            IDTSkin dtSkin = this.getCurrentSkin(dtResourceProvider.getId());
            if (dtSkin == null || currentDTSkins.contains(dtSkin)) continue;
            currentDTSkins.add(dtSkin);
        }
        return Collections.unmodifiableList(currentDTSkins);
    }

    public IDTSkin getDefaultSkin(String id) {
        IDTSkin firstDTSkin = null;
        IDTSkin defaultDTSkin = null;
        for (IDTSkin dtSkin : this.getSkins(id)) {
            if (firstDTSkin == null) {
                firstDTSkin = dtSkin;
            }
            if (!dtSkin.isDefault()) continue;
            defaultDTSkin = dtSkin;
            break;
        }
        if (defaultDTSkin == null) {
            defaultDTSkin = firstDTSkin;
        }
        return defaultDTSkin;
    }
}

