/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.autoedit;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsp.ui.internal.JSPUIPlugin;
import org.eclipse.jst.jsp.ui.internal.Logger;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.ui.internal.text.StructuredAutoEditStrategy;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class StructuredAutoEditStrategyJSPJava
extends StructuredAutoEditStrategy {
    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (!this.supportsSmartInsert(document)) {
            return;
        }
        IStructuredModel model = null;
        try {
            if ("-".equals(command.text) && this.isPreferenceEnabled("typingCompleteComments") && this.prefixedWith(document, command.offset, "<%-") && (model = StructuredModelManager.getModelManager().getExistingModelForRead(document)) != null) {
                IStructuredDocumentRegion end;
                IDOMNode parent;
                IDOMNode node = (IDOMNode)model.getIndexedRegion(command.offset);
                IDOMNode iDOMNode = parent = node != null ? (IDOMNode)node.getParentNode() : null;
                if (parent != null && "jsp:scriptlet".equals(parent.getNodeName()) && !parent.getSource().endsWith("--%>") && (end = parent.getEndStructuredDocumentRegion()) != null) {
                    try {
                        document.replace(end.getStartOffset(), 0, "--");
                    }
                    catch (BadLocationException e) {
                        Logger.logException(e);
                    }
                }
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    private boolean isPreferenceEnabled(String key) {
        return key != null && JSPUIPlugin.getDefault().getPreferenceStore().getBoolean(key);
    }

    private boolean prefixedWith(IDocument document, int offset, String string) {
        try {
            return document.getLength() >= string.length() && document.get(offset - string.length(), string.length()).equals(string);
        }
        catch (BadLocationException e) {
            Logger.logException(e);
            return false;
        }
    }
}

