/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.util;

import java.util.Iterator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolver;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Import;
import org.eclipse.wst.wsdl.Types;
import org.eclipse.wst.wsdl.XSDSchemaExtensibilityElement;
import org.eclipse.wst.wsdl.internal.impl.WSDLElementImpl;
import org.eclipse.wst.wsdl.internal.util.WSDLModelLocator;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLEditorUtil;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaDirective;
import org.w3c.dom.Element;

public class WSDLResourceUtil {
    public static void reloadDirectives(Definition definition) {
        Resource rootResource = definition.eResource();
        ResourceSet resourceSet = rootResource.getResourceSet();
        Iterator i = resourceSet.getResources().iterator();
        while (i.hasNext()) {
            Resource resource = (Resource)i.next();
            if (resource == rootResource) continue;
            i.remove();
        }
        ReloadDirectiveVisitor visitor = new ReloadDirectiveVisitor();
        visitor.visitDefinition(definition);
    }

    public static class InternalURIResolver
    implements WSDLModelLocator {
        URIResolver resolver = URIResolverPlugin.createResolver();

        InternalURIResolver() {
        }

        public String resolveURI(String baseLocation, String namespace, String location) {
            String resolvedLocation = this.resolver.resolve(baseLocation, namespace, location);
            if (resolvedLocation != null) {
                String fileProtocol = "file:";
                if (resolvedLocation.startsWith(fileProtocol) && !resolvedLocation.startsWith(String.valueOf(fileProtocol) + "/")) {
                    resolvedLocation = resolvedLocation.substring(fileProtocol.length());
                }
                resolvedLocation = URIHelper.addImpliedFileProtocol((String)resolvedLocation);
            }
            return resolvedLocation;
        }
    }

    static class ReloadDirectiveVisitor {
        ReloadDirectiveVisitor() {
        }

        public void visitImport(Import theImport) {
            Element element = WSDLEditorUtil.getInstance().getElementForObject(theImport);
            if (element != null) {
                ((WSDLElementImpl)theImport).elementChanged(element);
            }
        }

        public void visitXSDSchemaDirective(XSDSchemaDirective directive) {
            Element element = directive.getElement();
            if (element != null) {
                directive.elementAttributesChanged(element);
            }
        }

        public void visitDefinition(Definition definition) {
            if (definition != null) {
                Iterator i = definition.getEImports().iterator();
                while (i.hasNext()) {
                    this.visitImport((Import)i.next());
                }
                Types types = definition.getETypes();
                if (types != null) {
                    Iterator i2 = types.getEExtensibilityElements().iterator();
                    while (i2.hasNext()) {
                        XSDSchemaExtensibilityElement e;
                        Object o = i2.next();
                        if (!(o instanceof XSDSchemaExtensibilityElement) || (e = (XSDSchemaExtensibilityElement)o).getSchema() == null) continue;
                        this.visitSchema(e.getSchema());
                    }
                }
            }
        }

        public void visitSchema(XSDSchema schema) {
            Iterator i = schema.getContents().iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof XSDSchemaDirective)) continue;
                this.visitXSDSchemaDirective((XSDSchemaDirective)o);
            }
        }
    }
}

