/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.common.ui.preferences;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.sqltools.common.ui.internal.Activator;
import org.eclipse.datatools.sqltools.common.ui.preferences.IDataServerLaunchPreferenceSection;
import org.eclipse.datatools.sqltools.common.ui.preferences.IDataServerPreferenceSection;

public class PreferencesRegistry {
    public static final PreferencesRegistry INSTANCE = new PreferencesRegistry();
    private HashMap _pageSections = new HashMap();
    private HashMap _launchSections = new HashMap();

    private PreferencesRegistry() {
        this.init();
    }

    private void init() {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.datatools.sqltools.common.ui", "preferenceSections");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                if (configElements[j].getName().equals("section")) {
                    String page = configElements[j].getAttribute("page");
                    String id = configElements[j].getAttribute("dbdefinitionid");
                    Boolean launchConfig = Boolean.valueOf(configElements[j].getAttribute("launchConfig"));
                    try {
                        IDataServerPreferenceSection section = (IDataServerPreferenceSection)configElements[j].createExecutableExtension("class");
                        if (this._pageSections.containsKey(page)) {
                            ((Map)this._pageSections.get(page)).put(id, section);
                        } else {
                            TreeMap<String, IDataServerPreferenceSection> ids = new TreeMap<String, IDataServerPreferenceSection>();
                            ids.put(id, section);
                            this._pageSections.put(page, ids);
                        }
                        if (launchConfig.booleanValue()) {
                            IDataServerLaunchPreferenceSection launch = (IDataServerLaunchPreferenceSection)configElements[j].createExecutableExtension("class");
                            if (this._launchSections.containsKey(page)) {
                                ((Map)this._launchSections.get(page)).put(id, launch);
                            } else {
                                TreeMap<String, IDataServerLaunchPreferenceSection> ids = new TreeMap<String, IDataServerLaunchPreferenceSection>();
                                ids.put(id, launch);
                                this._launchSections.put(page, ids);
                            }
                        }
                    }
                    catch (CoreException e) {
                        Activator.getDefault().log(e.getStatus());
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public Map getPageSections(String page) {
        if (this._pageSections.containsKey(page)) {
            return (Map)this._pageSections.get(page);
        }
        return new HashMap();
    }

    public Map getLaunchSections(String page) {
        if (this._launchSections.containsKey(page)) {
            return (Map)this._launchSections.get(page);
        }
        return new HashMap();
    }
}

