/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.cdt.managedbuilder.internal.ui.Messages;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewBuildConfigurationDialog
extends Dialog {
    private Button btnClone;
    private Button btnCopy;
    private Text configName;
    private Text configDescription;
    private Combo copyConfigSelector;
    private Combo cloneConfigSelector;
    private Label statusLabel;
    private boolean clone;
    private IConfiguration[] defaultCfgds;
    private IConfiguration[] definedCfgds;
    private IConfiguration parentConfig;
    private ICProjectDescription des;
    private String newName;
    private String newDescription;
    private final String title;

    protected NewBuildConfigurationDialog(Shell parentShell, ICProjectDescription prjd, ICConfigurationDescription[] _cfgds, IConfiguration[] _defs, String title) {
        super(parentShell);
        this.title = title;
        this.des = prjd;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.newName = "";
        this.newDescription = "";
        this.parentConfig = null;
        this.clone = true;
        this.definedCfgds = new IConfiguration[_cfgds.length];
        int i = 0;
        while (i < _cfgds.length) {
            this.definedCfgds[i] = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)_cfgds[i]);
            ++i;
        }
        this.defaultCfgds = _defs;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            String description = "";
            String nameAndDescription = "";
            String baseConfigNameAndDescription = "";
            this.newName = this.configName.getText().trim();
            this.newDescription = this.configDescription.getText().trim();
            if (this.clone) {
                baseConfigNameAndDescription = this.cloneConfigSelector.getItem(this.cloneConfigSelector.getSelectionIndex());
                int i = 0;
                while (i < this.definedCfgds.length) {
                    description = this.definedCfgds[i].getDescription();
                    nameAndDescription = description == null || description.isEmpty() ? this.definedCfgds[i].getName() : String.valueOf(this.definedCfgds[i].getName()) + "( " + description + " )";
                    if (nameAndDescription.equals(baseConfigNameAndDescription)) {
                        this.parentConfig = this.definedCfgds[i];
                        break;
                    }
                    ++i;
                }
            } else {
                baseConfigNameAndDescription = this.copyConfigSelector.getItem(this.copyConfigSelector.getSelectionIndex());
                int i = 0;
                while (i < this.defaultCfgds.length) {
                    description = this.defaultCfgds[i].getDescription();
                    nameAndDescription = description == null || description.isEmpty() ? this.defaultCfgds[i].getName() : String.valueOf(this.defaultCfgds[i].getName()) + "( " + description + " )";
                    if (nameAndDescription.equals(baseConfigNameAndDescription)) {
                        this.parentConfig = this.defaultCfgds[i];
                        break;
                    }
                    ++i;
                }
            }
        } else {
            this.newName = null;
            this.newDescription = null;
            this.parentConfig = null;
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.configName.setFocus();
        if (this.configName != null) {
            this.configName.setText(this.newName);
        }
        this.validateState();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(768));
        Group group1 = new Group(composite, 0);
        group1.setFont(composite.getFont());
        GridLayout layout1 = new GridLayout(3, false);
        group1.setLayout((Layout)layout1);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        group1.setLayoutData((Object)gd);
        Label nameLabel = new Label((Composite)group1, 16384);
        nameLabel.setFont(parent.getFont());
        nameLabel.setText(Messages.NewConfiguration_label_name);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.grabExcessHorizontalSpace = false;
        nameLabel.setLayoutData((Object)gd);
        this.configName = new Text((Composite)group1, 2052);
        this.configName.setFont(group1.getFont());
        this.configName.setText(this.getNewName());
        this.configName.setFocus();
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 200;
        this.configName.setLayoutData((Object)gd);
        this.configName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewBuildConfigurationDialog.this.validateState();
            }
        });
        Label descriptionLabel = new Label((Composite)group1, 16384);
        descriptionLabel.setFont(parent.getFont());
        descriptionLabel.setText(Messages.NewConfiguration_label_description);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.grabExcessHorizontalSpace = false;
        descriptionLabel.setLayoutData((Object)gd);
        this.configDescription = new Text((Composite)group1, 2052);
        this.configDescription.setFont(group1.getFont());
        this.configDescription.setText(this.getNewDescription());
        this.configDescription.setFocus();
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 200;
        this.configDescription.setLayoutData((Object)gd);
        Group group = new Group(composite, 0);
        group.setFont(composite.getFont());
        group.setText(Messages.NewConfiguration_label_group);
        GridLayout layout = new GridLayout(3, false);
        group.setLayout((Layout)layout);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        group.setLayoutData((Object)gd);
        SelectionAdapter radioListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewBuildConfigurationDialog.this.clone = NewBuildConfigurationDialog.this.btnClone.getSelection();
                NewBuildConfigurationDialog.this.updateComboState();
            }
        };
        this.btnCopy = new Button((Composite)group, 16);
        this.btnCopy.setFont(group.getFont());
        this.btnCopy.setText(Messages.NewConfiguration_label_copy);
        this.setButtonLayoutData(this.btnCopy);
        this.btnCopy.addSelectionListener((SelectionListener)radioListener);
        this.copyConfigSelector = new Combo((Composite)group, 2060);
        this.copyConfigSelector.setFont(group.getFont());
        int index = this.copyConfigSelector.indexOf(this.newName);
        this.copyConfigSelector.select(index < 0 ? 0 : index);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 200;
        this.copyConfigSelector.setLayoutData((Object)gd);
        this.copyConfigSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewBuildConfigurationDialog.this.validateState();
            }
        });
        this.copyConfigSelector.setEnabled(false);
        this.btnClone = new Button((Composite)group, 16);
        this.btnClone.setFont(group.getFont());
        this.btnClone.setText(Messages.NewConfiguration_label_clone);
        this.setButtonLayoutData(this.btnClone);
        this.btnClone.addSelectionListener((SelectionListener)radioListener);
        this.btnClone.setSelection(true);
        this.cloneConfigSelector = new Combo((Composite)group, 2060);
        this.cloneConfigSelector.setFont(group.getFont());
        this.cloneConfigSelector.setItems(this.getDefinedConfigNamesAndDescriptions());
        index = this.cloneConfigSelector.indexOf(this.newName);
        this.cloneConfigSelector.select(index < 0 ? 0 : index);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 200;
        this.cloneConfigSelector.setLayoutData((Object)gd);
        this.cloneConfigSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewBuildConfigurationDialog.this.validateState();
            }
        });
        this.updateComboState();
        this.updateDefaultConfigs();
        this.statusLabel = new Label(composite, 0x1000000);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.statusLabel.setLayoutData((Object)gd);
        this.statusLabel.setFont(composite.getFont());
        this.statusLabel.setForeground(JFaceResources.getColorRegistry().get("ERROR_COLOR"));
        return composite;
    }

    private void updateDefaultConfigs() {
        if (this.defaultCfgds.length != 0) {
            String[] namesAndDescriptions = new String[this.defaultCfgds.length];
            int i = 0;
            while (i < this.defaultCfgds.length) {
                namesAndDescriptions[i] = this.defaultCfgds[i].getDescription() == null || this.defaultCfgds[i].getDescription().isEmpty() ? this.defaultCfgds[i].getName() : String.valueOf(this.defaultCfgds[i].getName()) + "( " + this.defaultCfgds[i].getDescription() + " )";
                ++i;
            }
            int selectionIndex = this.copyConfigSelector.getSelectionIndex();
            String oldSelection = null;
            if (selectionIndex != -1) {
                oldSelection = this.copyConfigSelector.getItem(selectionIndex);
            }
            this.copyConfigSelector.setItems(namesAndDescriptions);
            if (oldSelection != null) {
                selectionIndex = this.copyConfigSelector.indexOf(oldSelection);
            }
            if (selectionIndex == -1) {
                selectionIndex = 0;
            }
            this.copyConfigSelector.select(selectionIndex);
        } else {
            this.copyConfigSelector.removeAll();
        }
        this.validateState();
    }

    private String[] getDefinedConfigNamesAndDescriptions() {
        String[] namesAndDescriptions = new String[this.definedCfgds.length];
        int i = 0;
        while (i < this.definedCfgds.length) {
            namesAndDescriptions[i] = this.definedCfgds[i].getDescription() == null || this.definedCfgds[i].getDescription().isEmpty() ? this.definedCfgds[i].getName() : String.valueOf(this.definedCfgds[i].getName()) + "( " + this.definedCfgds[i].getDescription() + " )";
            ++i;
        }
        return namesAndDescriptions;
    }

    public String getNewName() {
        return this.newName;
    }

    protected boolean isDuplicateName(String newName) {
        int i = 0;
        while (i < this.definedCfgds.length) {
            if (this.definedCfgds[i].getName().equals(newName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isSimilarName(String newName) {
        int i = 0;
        while (i < this.definedCfgds.length) {
            if (this.definedCfgds[i].getName().equalsIgnoreCase(newName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void updateComboState() {
        this.cloneConfigSelector.setEnabled(this.clone);
        this.copyConfigSelector.setEnabled(!this.clone);
        this.validateState();
    }

    private boolean validateName(String name) {
        if (name.trim().length() == 0) {
            return false;
        }
        char[] chars = name.toCharArray();
        if (Character.isWhitespace(chars[0])) {
            return false;
        }
        int index = 0;
        while (index < chars.length) {
            if (!Character.isLetterOrDigit(chars[index])) {
                switch (chars[index]) {
                    case '\"': 
                    case '*': 
                    case '/': 
                    case ':': 
                    case '<': 
                    case '>': 
                    case '?': 
                    case '\\': {
                        return false;
                    }
                }
            }
            ++index;
        }
        return true;
    }

    private void validateState() {
        String s = null;
        String currentName = this.configName.getText();
        while (currentName.length() > 0 && Character.isWhitespace(currentName.charAt(currentName.length() - 1))) {
            currentName = currentName.substring(0, currentName.length() - 1);
        }
        if (currentName.length() == 0) {
            s = "";
        } else if (this.clone ? this.definedCfgds.length == 0 : this.defaultCfgds.length == 0) {
            s = "";
        } else if (this.isDuplicateName(currentName)) {
            s = NLS.bind((String)Messages.NewConfiguration_error_duplicateName, (Object)currentName);
        } else if (this.isSimilarName(currentName)) {
            s = NLS.bind((String)Messages.NewConfiguration_error_caseName, (Object)currentName);
        } else if (!this.validateName(currentName)) {
            s = NLS.bind((String)Messages.NewConfiguration_error_invalidName, (Object)currentName);
        }
        if (this.statusLabel == null) {
            return;
        }
        Button b = this.getButton(0);
        if (s != null) {
            this.statusLabel.setText(s);
            this.statusLabel.setVisible(true);
            if (b != null) {
                b.setEnabled(false);
            }
        } else {
            this.statusLabel.setVisible(false);
            if (b != null) {
                b.setEnabled(true);
            }
        }
    }

    public String getNewDescription() {
        return this.newDescription;
    }

    public ICConfigurationDescription newConfiguration() {
        Configuration cfg = (Configuration)this.parentConfig;
        String id = ManagedBuildManager.calculateChildId((String)cfg.getId(), null);
        ManagedProject mp = (ManagedProject)ManagedBuildManager.getBuildInfo((IResource)this.des.getProject()).getManagedProject();
        Configuration config = new Configuration(mp, cfg, id, true, false);
        config.setName(this.getNewName());
        config.setDescription(this.getNewDescription());
        String target = config.getArtifactName();
        if (target == null || target.length() == 0) {
            config.setArtifactName(mp.getDefaultArtifactName());
        }
        CConfigurationData data = config.getConfigurationData();
        try {
            this.des.createConfiguration("org.eclipse.cdt.managedbuilder.core.configurationDataProvider", data);
        }
        catch (CoreException e) {
            System.out.println(Messages.NewBuildConfigurationDialog_0);
            System.out.println(String.valueOf(Messages.NewBuildConfigurationDialog_1) + e.getLocalizedMessage());
        }
        return null;
    }
}

