/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.jkiss.dbeaver.model.data.DBDDataFormatterProfile;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.DTUtils;
import org.jkiss.dbeaver.tools.transfer.IDataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferSettings;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class StreamConsumerSettings
implements IDataTransferSettings {
    public static final String PROP_EXTRACT_IMAGES = "extractImages";
    public static final String PROP_FILE_EXTENSION = "extension";
    public static final String PROP_FORMAT = "format";
    private LobExtractType lobExtractType = LobExtractType.SKIP;
    private LobEncoding lobEncoding = LobEncoding.HEX;
    private String outputFolder = System.getProperty("user.home");
    private String outputFilePattern = String.valueOf(GeneralUtils.variablePattern((String)"table")) + "_" + GeneralUtils.variablePattern((String)"timestamp");
    private String outputEncoding = GeneralUtils.getDefaultFileEncoding();
    private boolean outputEncodingBOM = false;
    private DBDDataFormatterProfile formatterProfile;
    private boolean outputClipboard = false;
    private boolean useSingleFile = false;
    private boolean compressResults = false;
    private boolean splitOutFiles = false;
    private long maxOutFileSize = 10000000L;
    private boolean openFolderOnFinish = true;
    private boolean executeProcessOnFinish = false;
    private String finishProcessCommand = null;

    public LobExtractType getLobExtractType() {
        return this.lobExtractType;
    }

    public void setLobExtractType(LobExtractType lobExtractType) {
        this.lobExtractType = lobExtractType;
    }

    public LobEncoding getLobEncoding() {
        return this.lobEncoding;
    }

    public void setLobEncoding(LobEncoding lobEncoding) {
        this.lobEncoding = lobEncoding;
    }

    public String getOutputFolder() {
        return this.outputFolder;
    }

    public void setOutputFolder(String outputFolder) {
        this.outputFolder = outputFolder;
    }

    public String getOutputFilePattern() {
        return this.outputFilePattern;
    }

    public void setOutputFilePattern(String outputFilePattern) {
        this.outputFilePattern = outputFilePattern;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public boolean isOutputEncodingBOM() {
        return this.outputEncodingBOM;
    }

    public void setOutputEncodingBOM(boolean outputEncodingBOM) {
        this.outputEncodingBOM = outputEncodingBOM;
    }

    public boolean isOutputClipboard() {
        return this.outputClipboard;
    }

    public void setOutputClipboard(boolean outputClipboard) {
        this.outputClipboard = outputClipboard;
    }

    public boolean isUseSingleFile() {
        return this.useSingleFile;
    }

    public void setUseSingleFile(boolean useSingleFile) {
        this.useSingleFile = useSingleFile;
    }

    public boolean isCompressResults() {
        return this.compressResults;
    }

    public void setCompressResults(boolean compressResults) {
        this.compressResults = compressResults;
    }

    public boolean isSplitOutFiles() {
        return this.splitOutFiles;
    }

    public void setSplitOutFiles(boolean splitOutFiles) {
        this.splitOutFiles = splitOutFiles;
    }

    public long getMaxOutFileSize() {
        return this.maxOutFileSize;
    }

    public void setMaxOutFileSize(long maxOutFileSize) {
        this.maxOutFileSize = maxOutFileSize;
    }

    public boolean isOpenFolderOnFinish() {
        return this.openFolderOnFinish;
    }

    public void setOpenFolderOnFinish(boolean openFolderOnFinish) {
        this.openFolderOnFinish = openFolderOnFinish;
    }

    public boolean isExecuteProcessOnFinish() {
        return this.executeProcessOnFinish;
    }

    public void setExecuteProcessOnFinish(boolean executeProcessOnFinish) {
        this.executeProcessOnFinish = executeProcessOnFinish;
    }

    public String getFinishProcessCommand() {
        return this.finishProcessCommand;
    }

    public void setFinishProcessCommand(String finishProcessCommand) {
        this.finishProcessCommand = finishProcessCommand;
    }

    public DBDDataFormatterProfile getFormatterProfile() {
        return this.formatterProfile;
    }

    public void setFormatterProfile(DBDDataFormatterProfile formatterProfile) {
        this.formatterProfile = formatterProfile;
    }

    @Override
    public void loadSettings(IRunnableContext runnableContext, DataTransferSettings dataTransferSettings, IDialogSettings dialogSettings) {
        if (!CommonUtils.isEmpty((String)dialogSettings.get("lobExtractType"))) {
            try {
                this.lobExtractType = LobExtractType.valueOf(dialogSettings.get("lobExtractType"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.lobExtractType = LobExtractType.SKIP;
            }
        }
        if (!CommonUtils.isEmpty((String)dialogSettings.get("lobEncoding"))) {
            try {
                this.lobEncoding = LobEncoding.valueOf(dialogSettings.get("lobEncoding"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.lobEncoding = LobEncoding.HEX;
            }
        }
        if (!CommonUtils.isEmpty((String)dialogSettings.get("outputFolder"))) {
            this.outputFolder = dialogSettings.get("outputFolder");
        }
        if (!CommonUtils.isEmpty((String)dialogSettings.get("outputFilePattern"))) {
            this.outputFilePattern = dialogSettings.get("outputFilePattern");
        }
        if (!CommonUtils.isEmpty((String)dialogSettings.get("outputEncoding"))) {
            this.outputEncoding = dialogSettings.get("outputEncoding");
        }
        if (!CommonUtils.isEmpty((String)dialogSettings.get("outputEncodingBOM"))) {
            this.outputEncodingBOM = dialogSettings.getBoolean("outputEncodingBOM");
        }
        if (!CommonUtils.isEmpty((String)dialogSettings.get("outputClipboard"))) {
            this.outputClipboard = dialogSettings.getBoolean("outputClipboard");
        }
        if (!CommonUtils.isEmpty((String)dialogSettings.get("useSingleFile"))) {
            this.useSingleFile = dataTransferSettings.getDataPipes().size() > 1 ? dialogSettings.getBoolean("useSingleFile") : false;
        }
        if (!CommonUtils.isEmpty((String)dialogSettings.get("compressResults"))) {
            this.compressResults = dialogSettings.getBoolean("compressResults");
        }
        if (!CommonUtils.isEmpty((String)dialogSettings.get("splitOutFiles"))) {
            this.splitOutFiles = dialogSettings.getBoolean("splitOutFiles");
        }
        if (!CommonUtils.isEmpty((String)dialogSettings.get("maxOutFileSize"))) {
            this.maxOutFileSize = dialogSettings.getInt("maxOutFileSize");
        }
        if (dialogSettings.get("openFolderOnFinish") != null) {
            this.openFolderOnFinish = dialogSettings.getBoolean("openFolderOnFinish");
        }
        if (dialogSettings.get("executeProcessOnFinish") != null) {
            this.executeProcessOnFinish = dialogSettings.getBoolean("executeProcessOnFinish");
        }
        if (!CommonUtils.isEmpty((String)dialogSettings.get("finishProcessCommand"))) {
            this.finishProcessCommand = dialogSettings.get("finishProcessCommand");
        }
        if (!CommonUtils.isEmpty((String)dialogSettings.get("formatterProfile"))) {
            this.formatterProfile = DBWorkbench.getPlatform().getDataFormatterRegistry().getCustomProfile(dialogSettings.get("formatterProfile"));
        }
    }

    @Override
    public void saveSettings(IDialogSettings dialogSettings) {
        dialogSettings.put("lobExtractType", this.lobExtractType.name());
        dialogSettings.put("lobEncoding", this.lobEncoding.name());
        dialogSettings.put("outputFolder", this.outputFolder);
        dialogSettings.put("outputFilePattern", this.outputFilePattern);
        dialogSettings.put("outputEncoding", this.outputEncoding);
        dialogSettings.put("outputEncodingBOM", this.outputEncodingBOM);
        dialogSettings.put("outputClipboard", this.outputClipboard);
        dialogSettings.put("useSingleFile", this.useSingleFile);
        dialogSettings.put("compressResults", this.compressResults);
        dialogSettings.put("splitOutFiles", this.splitOutFiles);
        dialogSettings.put("maxOutFileSize", this.maxOutFileSize);
        dialogSettings.put("openFolderOnFinish", this.openFolderOnFinish);
        dialogSettings.put("executeProcessOnFinish", this.executeProcessOnFinish);
        dialogSettings.put("finishProcessCommand", this.finishProcessCommand);
        if (this.formatterProfile != null) {
            dialogSettings.put("formatterProfile", this.formatterProfile.getProfileName());
        } else {
            dialogSettings.put("formatterProfile", "");
        }
    }

    @Override
    public String getSettingsSummary() {
        StringBuilder summary = new StringBuilder();
        if (!this.outputClipboard) {
            DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_output_label_use_single_file, this.useSingleFile);
            DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_output_label_directory, this.outputFolder);
            DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_output_label_file_name_pattern, this.outputFilePattern);
            DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_output_label_encoding, this.outputEncoding);
            DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_output_label_insert_bom, this.outputEncodingBOM);
        } else {
            DTUtils.addSummary(summary, "Copy to clipboard", this.outputClipboard);
        }
        DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_output_checkbox_compress, this.compressResults);
        if (this.executeProcessOnFinish) {
            DTUtils.addSummary(summary, "Execute process on finish", this.finishProcessCommand);
        }
        DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_settings_label_binaries, (Object)this.lobExtractType);
        DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_settings_label_encoding, (Object)this.lobEncoding);
        if (this.formatterProfile != null) {
            DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_settings_label_formatting, this.formatterProfile.getProfileName());
        }
        return summary.toString();
    }

    public static enum LobEncoding {
        BASE64,
        HEX,
        BINARY;

    }

    public static enum LobExtractType {
        SKIP,
        FILES,
        INLINE;

    }
}

