/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreLanguage;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeOwner;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedureKind;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedureParameter;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreScriptObject;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPOverloadedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPUniqueObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.struct.AbstractProcedure;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameterKind;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class PostgreProcedure
extends AbstractProcedure<PostgreDataSource, PostgreSchema>
implements PostgreObject,
PostgreScriptObject,
PostgrePrivilegeOwner,
DBPUniqueObject,
DBPOverloadedObject,
DBPNamedObject2,
DBPRefreshableObject {
    private static final Log log = Log.getLog(PostgreProcedure.class);
    private static final String CAT_FLAGS = "Flags";
    private static final String CAT_PROPS = "Properties";
    private static final String CAT_STATS = "Statistics";
    public static final float DEFAULT_EST_ROWS = 1000.0f;
    public static final float DEFAULT_COST = 100.0f;
    private long oid;
    private PostgreProcedureKind kind;
    private String procSrc;
    private String body;
    private long ownerId;
    private long languageId;
    private float execCost;
    private float estRows;
    private PostgreDataType varArrayType;
    private String procTransform;
    private boolean isAggregate;
    private boolean isWindow;
    private boolean isSecurityDefiner;
    private boolean leakproof;
    private boolean isStrict;
    private boolean returnsSet;
    private ProcedureVolatile procVolatile;
    private PostgreDataType returnType;
    private int[] transformTypes;
    private String[] config;
    private Object acl;
    private String overloadedName;
    private List<PostgreProcedureParameter> params = new ArrayList<PostgreProcedureParameter>();

    public PostgreProcedure(PostgreSchema schema) {
        super((DBSObjectContainer)schema, false);
    }

    public PostgreProcedure(DBRProgressMonitor monitor, PostgreSchema schema, ResultSet dbResult) {
        super((DBSObjectContainer)schema, true);
        this.loadInfo(monitor, dbResult);
    }

    private void loadInfo(DBRProgressMonitor monitor, ResultSet dbResult) {
        block27: {
            String paramName;
            PostgreDataType dataType;
            Object paramType;
            int i;
            this.oid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
            this.setName(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"proname"));
            this.ownerId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"proowner");
            this.languageId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"prolang");
            this.execCost = JDBCUtils.safeGetFloat((ResultSet)dbResult, (String)"procost");
            this.estRows = JDBCUtils.safeGetFloat((ResultSet)dbResult, (String)"prorows");
            Object[] allArgTypes = (Long[])JDBCUtils.safeGetArray((ResultSet)dbResult, (String)"proallargtypes");
            String[] argNames = (String[])JDBCUtils.safeGetArray((ResultSet)dbResult, (String)"proargnames");
            if (!ArrayUtils.isEmpty((Object[])allArgTypes)) {
                String[] argModes = (String[])JDBCUtils.safeGetArray((ResultSet)dbResult, (String)"proargmodes");
                i = 0;
                while (i < allArgTypes.length) {
                    paramType = allArgTypes[i];
                    dataType = ((PostgreSchema)this.container).getDatabase().getDataType(monitor, ((Long)paramType).intValue());
                    if (dataType == null) {
                        log.warn((Object)("Parameter data type [" + paramType + "] not found"));
                    } else {
                        paramName = argNames == null || argNames.length < allArgTypes.length ? "$" + (i + 1) : argNames[i];
                        ArgumentMode mode = ArgumentMode.i;
                        if (argModes != null && argModes.length == allArgTypes.length) {
                            try {
                                mode = ArgumentMode.valueOf(argModes[i]);
                            }
                            catch (IllegalArgumentException e) {
                                log.debug((Object)e);
                            }
                        }
                        DBSProcedureParameterKind parameterKind = mode == null ? DBSProcedureParameterKind.IN : mode.getParameterKind();
                        PostgreProcedureParameter param = new PostgreProcedureParameter(this, paramName, dataType, parameterKind, i + 1);
                        this.params.add(param);
                    }
                    ++i;
                }
            } else {
                long[] inArgTypes = PostgreUtils.getIdVector(JDBCUtils.safeGetObject((ResultSet)dbResult, (String)"proargtypes"));
                if (!ArrayUtils.isEmpty((long[])inArgTypes)) {
                    i = 0;
                    while (i < inArgTypes.length) {
                        paramType = inArgTypes[i];
                        dataType = ((PostgreSchema)this.container).getDatabase().getDataType(monitor, ((Long)paramType).intValue());
                        if (dataType == null) {
                            log.warn((Object)("Parameter data type [" + paramType + "] not found"));
                        } else {
                            paramName = argNames == null || argNames.length < inArgTypes.length ? "$" + (i + 1) : argNames[i];
                            PostgreProcedureParameter param = new PostgreProcedureParameter(this, paramName, dataType, DBSProcedureParameterKind.IN, i + 1);
                            this.params.add(param);
                        }
                        ++i;
                    }
                }
            }
            try {
                String argDefaultsString = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"arg_defaults");
                String[] argDefaults = null;
                if (!CommonUtils.isEmpty((String)argDefaultsString)) {
                    try {
                        argDefaults = PostgreUtils.parseObjectString(argDefaultsString);
                    }
                    catch (DBCException e) {
                        log.debug((Object)"Error parsing function parameters defaults", (Throwable)e);
                    }
                }
                if (argDefaults == null || argDefaults.length <= 0) break block27;
                int paramsAssigned = 0;
                int i2 = this.params.size() - 1;
                while (i2 >= 0) {
                    this.params.get(i2).setDefaultValue(argDefaults[argDefaults.length - 1 - paramsAssigned]);
                    if (++paramsAssigned < argDefaults.length) {
                        --i2;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                log.error((Object)"Error parsing parameters defaults", (Throwable)e);
            }
        }
        this.overloadedName = PostgreProcedure.makeOverloadedName(this.getSchema(), this.getName(), this.params, false, false);
        long varTypeId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"provariadic");
        if (varTypeId != 0L) {
            this.varArrayType = ((PostgreSchema)this.container).getDatabase().getDataType(monitor, varTypeId);
        }
        this.procTransform = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"protransform");
        this.isAggregate = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"proisagg");
        this.isWindow = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"proiswindow");
        this.isSecurityDefiner = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"prosecdef");
        this.leakproof = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"proleakproof");
        this.isStrict = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"proisstrict");
        this.returnsSet = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"proretset");
        try {
            String provolatile = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"provolatile");
            this.procVolatile = provolatile == null ? null : ProcedureVolatile.valueOf(provolatile);
        }
        catch (IllegalArgumentException e) {
            log.debug((Object)e);
        }
        long retTypeId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"prorettype");
        if (retTypeId != 0L) {
            this.returnType = ((PostgreSchema)this.container).getDatabase().getDataType(monitor, retTypeId);
        }
        this.procSrc = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"prosrc");
        this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"description");
        this.acl = JDBCUtils.safeGetObject((ResultSet)dbResult, (String)"proacl");
        this.config = (String[])JDBCUtils.safeGetArray((ResultSet)dbResult, (String)"proconfig");
        if (((PostgreDataSource)this.getDataSource()).isServerVersionAtLeast(11, 0)) {
            String proKind = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"prokind");
            try {
                this.kind = PostgreProcedureKind.valueOf(proKind);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.warn((Object)("Unsupported procedure kind:" + proKind));
                this.kind = PostgreProcedureKind.f;
            }
        } else {
            this.kind = this.isAggregate ? PostgreProcedureKind.a : (this.isWindow ? PostgreProcedureKind.w : PostgreProcedureKind.f);
        }
    }

    @Override
    @NotNull
    public PostgreDatabase getDatabase() {
        return ((PostgreSchema)this.container).getDatabase();
    }

    @Property(viewable=false, order=3)
    public PostgreProcedureKind getKind() {
        return this.kind;
    }

    public void setKind(PostgreProcedureKind kind) {
        this.kind = kind;
    }

    @Property(order=5)
    public long getObjectId() {
        return this.oid;
    }

    public DBSProcedureType getProcedureType() {
        switch (this.kind) {
            case f: 
            case a: 
            case w: {
                return DBSProcedureType.FUNCTION;
            }
        }
        return DBSProcedureType.PROCEDURE;
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getBody() {
        return this.body;
    }

    public List<PostgreProcedureParameter> getParameters(@Nullable DBRProgressMonitor monitor) {
        return this.params;
    }

    public List<PostgreProcedureParameter> getInputParameters() {
        ArrayList<PostgreProcedureParameter> result = new ArrayList<PostgreProcedureParameter>();
        for (PostgreProcedureParameter param : this.params) {
            if (!param.getParameterKind().isInput()) continue;
            result.add(param);
        }
        return result;
    }

    public List<PostgreProcedureParameter> getParameters(DBSProcedureParameterKind kind) {
        ArrayList<PostgreProcedureParameter> result = new ArrayList<PostgreProcedureParameter>();
        for (PostgreProcedureParameter param : this.params) {
            if (param.getParameterKind() != kind) continue;
            result.add(param);
        }
        return result;
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getContainer(), this});
    }

    @NotNull
    public String getOverloadedName() {
        return this.overloadedName;
    }

    @NotNull
    public String getUniqueName() {
        return this.overloadedName;
    }

    public String getSpecificName() {
        return String.valueOf(this.name) + "_" + this.getObjectId();
    }

    public void setName(String name) {
        super.setName(name);
        this.overloadedName = PostgreProcedure.makeOverloadedName(this.getSchema(), this.getName(), this.params, false, false);
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        String procDDL;
        Object returnType;
        boolean omitHeader = CommonUtils.getOption(options, (String)"debugger.source");
        if (!((PostgreDataSource)this.getDataSource()).getServerType().supportFunctionDefRead() || omitHeader) {
            if (this.procSrc == null) {
                try {
                    Throwable throwable = null;
                    Object var6_9 = null;
                    try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read procedure body");){
                        this.procSrc = JDBCUtils.queryString((JDBCSession)session, (String)"SELECT prosrc FROM pg_proc where oid = ?", (Object[])new Object[]{this.getObjectId()});
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    throw new DBException("Error reading procedure body", (Throwable)e);
                }
            }
            String returnTypeName = (returnType = this.getReturnType()) == null ? null : ((PostgreDataType)returnType).getFullTypeName();
            procDDL = omitHeader ? this.procSrc : this.generateFunctionDeclaration(this.getLanguage(monitor), returnTypeName, this.procSrc);
        } else {
            if (this.body == null) {
                if (!this.isPersisted()) {
                    returnType = this.getReturnType();
                    String returnTypeName = returnType == null ? null : ((PostgreDataType)returnType).getFullTypeName();
                    this.body = this.generateFunctionDeclaration(this.getLanguage(monitor), returnTypeName, "\n\t-- Enter function body here\n");
                } else if (this.oid == 0L || this.isAggregate) {
                    this.body = this.procSrc;
                } else {
                    try {
                        returnType = null;
                        Object var6_12 = null;
                        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read procedure body");){
                            this.body = JDBCUtils.queryString((JDBCSession)session, (String)("SELECT pg_get_functiondef(" + this.getObjectId() + ")"), (Object[])new Object[0]);
                        }
                        catch (Throwable throwable) {
                            if (returnType == null) {
                                returnType = throwable;
                            } else if (returnType != throwable) {
                                ((Throwable)returnType).addSuppressed(throwable);
                            }
                            throw returnType;
                        }
                    }
                    catch (SQLException e) {
                        if (!CommonUtils.isEmpty((String)this.procSrc)) {
                            log.debug((Object)"Error reading procedure body", (Throwable)e);
                            this.body = this.procSrc;
                        }
                        throw new DBException("Error reading procedure body", (Throwable)e);
                    }
                }
            }
            procDDL = this.body;
        }
        if (this.isPersisted() && !omitHeader) {
            procDDL = String.valueOf(procDDL) + ";\n";
            if (CommonUtils.getOption(options, (String)"pg.ddl.show.column.comments") && !CommonUtils.isEmpty((String)this.getDescription())) {
                procDDL = String.valueOf(procDDL) + "\nCOMMENT ON FUNCTION " + this.getFullQualifiedSignature() + " IS " + SQLUtils.quoteString((DBSObject)this, (String)this.getDescription()) + ";\n";
            }
            if (CommonUtils.getOption(options, (String)"pg.ddl.show.permissions")) {
                ArrayList<DBEPersistAction> actions = new ArrayList<DBEPersistAction>();
                PostgreUtils.getObjectGrantPermissionActions(monitor, this, actions, options);
                procDDL = String.valueOf(procDDL) + "\n" + SQLUtils.generateScript((DBPDataSource)this.getDataSource(), (DBEPersistAction[])actions.toArray(new DBEPersistAction[0]), (boolean)false);
            }
        }
        return procDDL;
    }

    protected String generateFunctionDeclaration(PostgreLanguage language, String returnTypeName, String functionBody) {
        String lineSeparator = GeneralUtils.getDefaultLineSeparator();
        StringBuilder decl = new StringBuilder();
        String functionSignature = PostgreProcedure.makeOverloadedName(this.getSchema(), this.getName(), this.params, true, true);
        decl.append("CREATE OR REPLACE ").append(this.getProcedureTypeName()).append(" ").append(DBUtils.getQuotedIdentifier((DBSObject)this.getContainer())).append(".").append(functionSignature).append(lineSeparator);
        if (this.getProcedureType().hasReturnValue() && !CommonUtils.isEmpty((String)returnTypeName)) {
            decl.append("\tRETURNS ");
            if (this.isReturnsSet()) {
                List<PostgreProcedureParameter> tableParams = this.getParameters(DBSProcedureParameterKind.TABLE);
                if (!tableParams.isEmpty()) {
                    decl.append("TABLE (");
                    int i = 0;
                    while (i < tableParams.size()) {
                        PostgreProcedureParameter tp = tableParams.get(i);
                        if (i > 0) {
                            decl.append(", ");
                        }
                        decl.append(tp.getName()).append(" ").append(tp.getTypeName());
                        ++i;
                    }
                    decl.append(")");
                } else {
                    decl.append("SETOF ").append(returnTypeName);
                }
            } else {
                decl.append(returnTypeName);
            }
            decl.append(lineSeparator);
        }
        if (language != null) {
            decl.append("\tLANGUAGE ").append(language).append(lineSeparator);
        }
        if (this.isWindow()) {
            decl.append("\tWINDOW").append(lineSeparator);
        }
        if (this.procVolatile != null) {
            decl.append("\t").append(this.procVolatile.getCreateClause()).append(lineSeparator);
        }
        if (this.execCost > 0.0f && this.execCost != 100.0f) {
            decl.append("\tCOST ").append(CommonUtils.niceFormatFloat((float)this.execCost)).append(lineSeparator);
        }
        if (this.estRows > 0.0f && this.estRows != 1000.0f) {
            decl.append("\tROWS ").append(CommonUtils.niceFormatFloat((float)this.estRows)).append(lineSeparator);
        }
        if (!ArrayUtils.isEmpty((Object[])this.config)) {
            String[] stringArray = this.config;
            int n = this.config.length;
            int n2 = 0;
            while (n2 < n) {
                String configLine = stringArray[n2];
                int divPos = configLine.indexOf(61);
                if (divPos != -1) {
                    String paramName = configLine.substring(0, divPos);
                    String paramValue = configLine.substring(divPos + 1);
                    boolean isNumeric = true;
                    try {
                        Double.parseDouble(paramValue);
                    }
                    catch (NumberFormatException numberFormatException) {
                        isNumeric = false;
                    }
                    decl.append("\tSET ").append(paramName).append(" = ").append(isNumeric ? paramValue : "'" + paramValue + "'").append(lineSeparator);
                } else {
                    log.debug((Object)("Wrong function configuration parameter [" + configLine + "]"));
                }
                ++n2;
            }
        }
        String delimiter = "$" + this.getProcedureType().name().toLowerCase(Locale.ENGLISH) + "$";
        decl.append("AS ").append(delimiter).append(" ");
        if (!CommonUtils.isEmpty((String)functionBody)) {
            decl.append("\t").append(functionBody).append(" ");
        }
        decl.append(delimiter).append(lineSeparator);
        return decl.toString();
    }

    @Override
    public void setObjectDefinitionText(String sourceText) {
        this.body = sourceText;
    }

    public long getOwnerId() {
        return this.ownerId;
    }

    @Override
    @Property(category="Properties", order=10)
    public PostgreRole getOwner(DBRProgressMonitor monitor) throws DBException {
        if (!((PostgreDataSource)this.getDataSource()).getServerType().supportsRoles()) {
            return null;
        }
        return ((PostgreSchema)this.container).getDatabase().getRoleById(monitor, this.ownerId);
    }

    @Property(category="Properties", viewable=true, order=11)
    public PostgreLanguage getLanguage(DBRProgressMonitor monitor) throws DBException {
        return (PostgreLanguage)PostgreUtils.getObjectById(monitor, ((PostgreSchema)this.container).getDatabase().languageCache, ((PostgreSchema)this.container).getDatabase(), this.languageId);
    }

    public void setLanguage(PostgreLanguage language) {
        this.languageId = language.getObjectId();
    }

    @Property(category="Properties", viewable=true, order=12)
    public PostgreDataType getReturnType() {
        return this.returnType;
    }

    public void setReturnType(PostgreDataType returnType) {
        this.returnType = returnType;
    }

    @Property(category="Properties", viewable=false, order=13)
    public PostgreDataType getVarArrayType() {
        return this.varArrayType;
    }

    @Property(category="Properties", viewable=false, order=14)
    public String getProcTransform() {
        return this.procTransform;
    }

    @Property(category="Statistics", viewable=false, order=30)
    public float getExecCost() {
        return this.execCost;
    }

    @Property(category="Statistics", viewable=false, order=31)
    public float getEstRows() {
        return this.estRows;
    }

    @Property(category="Flags", viewable=true, order=100)
    public boolean isAggregate() {
        return this.isAggregate;
    }

    @Property(category="Flags", viewable=true, order=101)
    public boolean isWindow() {
        return this.isWindow;
    }

    @Property(category="Flags", viewable=true, order=102)
    public boolean isSecurityDefiner() {
        return this.isSecurityDefiner;
    }

    @Property(category="Flags", viewable=true, order=103)
    public boolean isLeakproof() {
        return this.leakproof;
    }

    @Property(category="Flags", viewable=true, order=104)
    public boolean isStrict() {
        return this.isStrict;
    }

    @Property(category="Flags", viewable=true, order=105)
    public boolean isReturnsSet() {
        return this.returnsSet;
    }

    @Property(category="Flags", viewable=true, order=106)
    public ProcedureVolatile getProcVolatile() {
        return this.procVolatile;
    }

    public static String makeOverloadedName(PostgreSchema schema, String name, List<PostgreProcedureParameter> params, boolean quote, boolean showParamNames) {
        String selfName;
        String string = selfName = quote ? DBUtils.getQuotedIdentifier((DBPDataSource)schema.getDataSource(), (String)name) : name;
        if (!CommonUtils.isEmpty(params)) {
            StringBuilder paramsSignature = new StringBuilder(64);
            paramsSignature.append("(");
            boolean hasParam = false;
            for (PostgreProcedureParameter param : params) {
                PostgreDataType dataType;
                PostgreSchema typeContainer;
                if (param.getParameterKind() != DBSProcedureParameterKind.IN && param.getParameterKind() != DBSProcedureParameterKind.INOUT) continue;
                if (hasParam) {
                    paramsSignature.append(',');
                }
                hasParam = true;
                if (showParamNames) {
                    paramsSignature.append(param.getName()).append(' ');
                }
                if ((typeContainer = (PostgreSchema)(dataType = param.getParameterType()).getParentObject()) == null || typeContainer == schema || typeContainer.isCatalogSchema()) {
                    paramsSignature.append(dataType.getName());
                    continue;
                }
                paramsSignature.append(dataType.getFullyQualifiedName(DBPEvaluationContext.DDL));
            }
            paramsSignature.append(")");
            return String.valueOf(selfName) + paramsSignature.toString();
        }
        return String.valueOf(selfName) + "()";
    }

    @Property(viewable=true, editable=true, updatable=true, multiline=true, order=200)
    @Nullable
    public String getDescription() {
        return super.getDescription();
    }

    public String getFullQualifiedSignature() {
        return String.valueOf(DBUtils.getQuotedIdentifier((DBSObject)this.getContainer())) + "." + PostgreProcedure.makeOverloadedName(this.getSchema(), this.getName(), this.params, true, false);
    }

    public String getProcedureTypeName() {
        return this.kind.getName().toUpperCase(Locale.ENGLISH);
    }

    @Override
    public PostgreSchema getSchema() {
        return (PostgreSchema)this.container;
    }

    @Override
    public Collection<PostgrePrivilege> getPrivileges(DBRProgressMonitor monitor, boolean includeNestedObjects) throws DBException {
        return PostgreUtils.extractPermissionsFromACL(monitor, this, this.acl);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((PostgreSchema)this.getContainer()).getProceduresCache().refreshObject(monitor, (PostgreSchema)this.getContainer(), this);
    }

    @Override
    public String generateChangeOwnerQuery(String owner) {
        return "ALTER " + this.getProcedureTypeName() + " " + this.getFullQualifiedSignature() + " OWNER TO " + owner;
    }

    public String toString() {
        return this.overloadedName == null ? this.name : this.overloadedName;
    }

    public static enum ArgumentMode {
        i(DBSProcedureParameterKind.IN),
        o(DBSProcedureParameterKind.OUT),
        b(DBSProcedureParameterKind.INOUT),
        v(DBSProcedureParameterKind.RESULTSET),
        t(DBSProcedureParameterKind.TABLE),
        u(DBSProcedureParameterKind.UNKNOWN);

        private final DBSProcedureParameterKind parameterKind;

        private ArgumentMode(DBSProcedureParameterKind parameterKind) {
            this.parameterKind = parameterKind;
        }

        public DBSProcedureParameterKind getParameterKind() {
            return this.parameterKind;
        }
    }

    public static enum ProcedureVolatile {
        i("IMMUTABLE"),
        s("STABLE"),
        v("VOLATILE");

        private final String createClause;

        private ProcedureVolatile(String createClause) {
            this.createClause = createClause;
        }

        public String getCreateClause() {
            return this.createClause;
        }
    }
}

