/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAccessMethod;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreInformation;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreOperatorFamily;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class PostgreOperatorClass
extends PostgreInformation {
    private long oid;
    private PostgreAccessMethod accessMethod;
    private String name;
    private long namespaceId;
    private long ownerId;
    private long familyId;
    private long typeId;
    private boolean isDefault;
    private long keyTypeId;

    public PostgreOperatorClass(PostgreAccessMethod accessMethod, ResultSet dbResult) throws SQLException {
        super(accessMethod.getDatabase());
        this.accessMethod = accessMethod;
        this.loadInfo(dbResult);
    }

    private void loadInfo(ResultSet dbResult) throws SQLException {
        this.oid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"opcname");
        this.namespaceId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"opcnamespace");
        this.ownerId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"opcowner");
        this.familyId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"opcfamily");
        this.typeId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"opcintype");
        this.isDefault = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"opcdefault");
        this.keyTypeId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"opckeytype");
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    public long getObjectId() {
        return this.oid;
    }

    @Property(viewable=true, order=3)
    public PostgreSchema getNamespace(DBRProgressMonitor monitor) throws DBException {
        return this.accessMethod.getDatabase().getSchema(monitor, this.namespaceId);
    }

    @Property(viewable=true, order=4)
    public PostgreRole getOwner(DBRProgressMonitor monitor) throws DBException {
        return this.accessMethod.getDatabase().getRoleById(monitor, this.ownerId);
    }

    @Property(viewable=true, order=5)
    public PostgreOperatorFamily getFamily(DBRProgressMonitor monitor) throws DBException {
        return this.accessMethod.getOperatorFamily(monitor, this.familyId);
    }

    @Property(viewable=true, order=6)
    public PostgreDataType getType(DBRProgressMonitor monitor) {
        return this.accessMethod.getDatabase().getDataType(monitor, this.typeId);
    }

    @Property(viewable=true, order=7)
    public boolean isDefault() {
        return this.isDefault;
    }

    @Property(viewable=true, order=8)
    public PostgreDataType getKeyType(DBRProgressMonitor monitor) {
        if (this.keyTypeId == 0L) {
            return this.getType(monitor);
        }
        return this.accessMethod.getDatabase().getDataType(monitor, this.keyTypeId);
    }
}

