/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.data.gis.handlers;

import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.data.gis.handlers.GeometryConverter;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.gis.DBGeometry;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCAbstractValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Geometry;

public class GISGeometryValueHandler
extends JDBCAbstractValueHandler {
    private int defaultSRID;
    private boolean invertCoordinates;

    public GISGeometryValueHandler() {
        this(false);
    }

    public GISGeometryValueHandler(boolean invertCoordinates) {
        this.invertCoordinates = invertCoordinates;
    }

    public boolean isFlipCoordinates() {
        return this.invertCoordinates;
    }

    public int getDefaultSRID() {
        return this.defaultSRID;
    }

    public void setDefaultSRID(int defaultSRID) {
        this.defaultSRID = defaultSRID;
    }

    public void setInvertCoordinates(boolean invertCoordinates) {
        this.invertCoordinates = invertCoordinates;
    }

    protected Object fetchColumnValue(DBCSession session, JDBCResultSet resultSet, DBSTypedObject type, int index) throws DBCException, SQLException {
        return this.getValueFromObject(session, type, this.fetchBytes(resultSet, index), false);
    }

    protected void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException, SQLException {
        if (value instanceof DBGeometry) {
            value = ((DBGeometry)value).getRawValue();
        }
        if (value == null) {
            statement.setNull(paramIndex, paramType.getTypeID());
        } else if (value instanceof byte[]) {
            this.bindBytes(statement, paramIndex, (byte[])value);
        } else if (value instanceof Geometry) {
            this.bindBytes(statement, paramIndex, GeometryConverter.getInstance().to((Geometry)value));
        }
    }

    public Class<?> getValueObjectType(DBSTypedObject attribute) {
        return DBGeometry.class;
    }

    @NotNull
    public DBGeometry getValueFromObject(DBCSession session, DBSTypedObject type, Object object, boolean copy) throws DBCException {
        DBGeometry geometry;
        if (object == null) {
            geometry = new DBGeometry();
        } else if (object instanceof DBGeometry) {
            geometry = (DBGeometry)object;
        } else if (object instanceof Geometry) {
            geometry = new DBGeometry((Geometry)object);
        } else if (object instanceof byte[]) {
            Geometry jtsGeometry = GeometryConverter.getInstance().from((byte[])object);
            geometry = new DBGeometry(jtsGeometry);
        } else if (object instanceof String) {
            Geometry jtsGeometry = GeometryConverter.getInstance().from((String)object);
            if (this.invertCoordinates) {
                jtsGeometry.apply((CoordinateFilter)GeometryConverter.INVERT_COORDINATE_FILTER);
            }
            geometry = new DBGeometry(jtsGeometry);
        } else {
            throw new DBCException("Unsupported geometry value: " + object);
        }
        if (geometry.getSRID() == 0) {
            geometry.setSRID(this.defaultSRID);
        }
        return geometry;
    }

    protected byte[] fetchBytes(JDBCResultSet resultSet, int index) throws SQLException {
        return resultSet.getBytes(index);
    }

    protected void bindBytes(JDBCPreparedStatement dbStat, int index, byte[] bytes) throws SQLException {
        dbStat.setBytes(index, bytes);
    }
}

