/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class JDBCRemoteInstance<DATASOURCE extends JDBCDataSource>
implements DBSInstance {
    private static final Log log = Log.getLog(JDBCRemoteInstance.class);
    @NotNull
    protected final DATASOURCE dataSource;
    @NotNull
    protected JDBCExecutionContext executionContext;
    @Nullable
    protected JDBCExecutionContext metaContext;
    @NotNull
    private final List<JDBCExecutionContext> allContexts = new ArrayList<JDBCExecutionContext>();

    protected JDBCRemoteInstance(@NotNull DBRProgressMonitor monitor, @NotNull DATASOURCE dataSource, boolean initContext) throws DBException {
        this.dataSource = dataSource;
        if (initContext) {
            this.initializeMainContext(monitor);
        }
    }

    @Override
    public DBSObject getParentObject() {
        return this.dataSource;
    }

    public DATASOURCE getDataSource() {
        return this.dataSource;
    }

    @Override
    public String getName() {
        return ((JDBCDataSource)this.dataSource).getName();
    }

    @Override
    public boolean isPersisted() {
        return true;
    }

    @Override
    public String getDescription() {
        return null;
    }

    protected void initializeMainContext(@NotNull DBRProgressMonitor monitor) throws DBCException {
        if (this.executionContext == null) {
            this.executionContext = new JDBCExecutionContext(this, "Main");
            this.executionContext.connect(monitor, null, null, false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDBCExecutionContext initializeMetaContext(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.metaContext != null) {
            return this.metaContext;
        }
        if (!((JDBCDataSource)this.dataSource).getContainer().getDriver().isEmbedded() && ((JDBCDataSource)this.dataSource).getContainer().getPreferenceStore().getBoolean("database.meta.separate.connection")) {
            List<JDBCExecutionContext> list = this.allContexts;
            synchronized (list) {
                this.metaContext = new JDBCExecutionContext(this, "Metadata");
                this.metaContext.connect(monitor, true, null, false, true);
                return this.metaContext;
            }
        }
        return this.executionContext;
    }

    @Override
    @NotNull
    public DBCExecutionContext openIsolatedContext(@NotNull DBRProgressMonitor monitor, @NotNull String purpose) throws DBException {
        JDBCExecutionContext context = new JDBCExecutionContext(this, purpose);
        context.connect(monitor, null, null, true, true);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public JDBCExecutionContext[] getAllContexts() {
        List<JDBCExecutionContext> list = this.allContexts;
        synchronized (list) {
            return this.allContexts.toArray(new JDBCExecutionContext[this.allContexts.size()]);
        }
    }

    @Override
    public JDBCExecutionContext getDefaultContext(boolean meta) {
        if (this.metaContext != null && meta) {
            return this.metaContext;
        }
        return this.executionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(DBRProgressMonitor monitor) {
        List<JDBCExecutionContext> list = this.allContexts;
        synchronized (list) {
            ArrayList<JDBCExecutionContext> ctxCopy = new ArrayList<JDBCExecutionContext>(this.allContexts);
            for (JDBCExecutionContext context : ctxCopy) {
                monitor.subTask("Close context '" + context.getContextName() + "'");
                context.close();
                monitor.worked(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addContext(JDBCExecutionContext context) {
        List<JDBCExecutionContext> list = this.allContexts;
        synchronized (list) {
            this.allContexts.add(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeContext(JDBCExecutionContext context) {
        List<JDBCExecutionContext> list = this.allContexts;
        synchronized (list) {
            return this.allContexts.remove(context);
        }
    }
}

