/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.diag;

import com.google.common.collect.ImmutableList;
import com.google.turbine.diag.SourceFile;
import com.google.turbine.diag.TurbineDiagnostic;
import com.google.turbine.diag.TurbineError;
import java.util.LinkedHashSet;
import java.util.Set;

public class TurbineLog {
    private final Set<TurbineDiagnostic> errors = new LinkedHashSet<TurbineDiagnostic>();

    public TurbineLogWithSource withSource(SourceFile source) {
        return new TurbineLogWithSource(source);
    }

    public void maybeThrow() {
        if (!this.errors.isEmpty()) {
            throw new TurbineError((ImmutableList<TurbineDiagnostic>)ImmutableList.copyOf(this.errors));
        }
    }

    public class TurbineLogWithSource {
        private final SourceFile source;

        private TurbineLogWithSource(SourceFile source) {
            this.source = source;
        }

        public void error(TurbineError.ErrorKind kind, Object ... args) {
            TurbineLog.this.errors.add(TurbineDiagnostic.format(this.source, kind, args));
        }

        public void error(int position, TurbineError.ErrorKind kind, Object ... args) {
            TurbineLog.this.errors.add(TurbineDiagnostic.format(this.source, position, kind, args));
        }
    }
}

