"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class MergeConflictListItemView extends _react["default"].Component {
  constructor(props) {
    super(props);
    this.refItem = new _refHolder["default"]();
    this.subs = new _eventKit.CompositeDisposable(this.refItem.observe(item => this.props.registerItemElement(this.props.mergeConflict, item)));
  }

  render() {
    const _this$props = this.props,
          {
      mergeConflict,
      selected
    } = _this$props,
          others = _objectWithoutProperties(_this$props, ["mergeConflict", "selected"]);

    delete others.remainingConflicts;
    delete others.registerItemElement;
    const fileStatus = _helpers.classNameForStatus[mergeConflict.status.file];
    const oursStatus = _helpers.classNameForStatus[mergeConflict.status.ours];
    const theirsStatus = _helpers.classNameForStatus[mergeConflict.status.theirs];
    const className = selected ? 'is-selected' : '';
    return _react["default"].createElement("div", _extends({
      ref: this.refItem.setter
    }, others, {
      className: `github-MergeConflictListView-item is-${fileStatus} ${className}`
    }), _react["default"].createElement("div", {
      className: "github-FilePatchListView-item github-FilePatchListView-pathItem"
    }, _react["default"].createElement("span", {
      className: `github-FilePatchListView-icon icon icon-diff-${fileStatus} status-${fileStatus}`
    }), _react["default"].createElement("span", {
      className: "github-FilePatchListView-path"
    }, mergeConflict.filePath), _react["default"].createElement("span", {
      className: 'github-FilePatchListView ours-theirs-info'
    }, _react["default"].createElement("span", {
      className: `github-FilePatchListView-icon icon icon-diff-${oursStatus}`
    }), _react["default"].createElement("span", {
      className: `github-FilePatchListView-icon icon icon-diff-${theirsStatus}`
    }))), _react["default"].createElement("div", {
      className: "github-FilePatchListView-item github-FilePatchListView-resolutionItem"
    }, this.renderRemainingConflicts()));
  }

  renderRemainingConflicts() {
    if (this.props.remainingConflicts === 0) {
      return _react["default"].createElement("span", {
        className: "icon icon-check github-RemainingConflicts text-success"
      }, "ready");
    } else if (this.props.remainingConflicts !== undefined) {
      const pluralConflicts = this.props.remainingConflicts === 1 ? '' : 's';
      return _react["default"].createElement("span", {
        className: "github-RemainingConflicts text-warning"
      }, this.props.remainingConflicts, " conflict", pluralConflicts, " remaining");
    } else {
      return _react["default"].createElement("span", {
        className: "github-RemainingConflicts text-subtle"
      }, "calculating");
    }
  }

  componentWillUnmount() {
    this.subs.dispose();
  }

}

exports["default"] = MergeConflictListItemView;

_defineProperty(MergeConflictListItemView, "propTypes", {
  mergeConflict: _propTypes2.MergeConflictItemPropType.isRequired,
  selected: _propTypes["default"].bool.isRequired,
  remainingConflicts: _propTypes["default"].number,
  registerItemElement: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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