"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _propTypes2 = require("../prop-types");

var _helpers = require("../helpers");

var _githubTabView = _interopRequireDefault(require("../views/github-tab-view"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class GitHubTabController extends _react["default"].Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'handlePushBranch', 'handleRemoteSelect');
  }

  render() {
    const gitHubRemotes = this.props.allRemotes.filter(remote => remote.isGithubRepo());
    const currentBranch = this.props.branches.getHeadBranch();
    let currentRemote = gitHubRemotes.withName(this.props.selectedRemoteName);
    let manyRemotesAvailable = false;

    if (!currentRemote.isPresent() && gitHubRemotes.size() === 1) {
      currentRemote = Array.from(gitHubRemotes)[0];
    } else if (!currentRemote.isPresent() && gitHubRemotes.size() > 1) {
      manyRemotesAvailable = true;
    }

    return _react["default"].createElement(_githubTabView["default"], {
      workspace: this.props.workspace,
      remoteOperationObserver: this.props.remoteOperationObserver,
      loginModel: this.props.loginModel,
      rootHolder: this.props.rootHolder,
      workingDirectory: this.props.workingDirectory,
      branches: this.props.branches,
      currentBranch: currentBranch,
      remotes: gitHubRemotes,
      currentRemote: currentRemote,
      manyRemotesAvailable: manyRemotesAvailable,
      aheadCount: this.props.aheadCount,
      pushInProgress: this.props.pushInProgress,
      isLoading: this.props.isLoading,
      handlePushBranch: this.handlePushBranch,
      handleRemoteSelect: this.handleRemoteSelect
    });
  }

  handlePushBranch(currentBranch, targetRemote) {
    return this.props.repository.push(currentBranch.getName(), {
      remote: targetRemote,
      setUpstream: true
    });
  }

  handleRemoteSelect(e, remote) {
    e.preventDefault();
    return this.props.repository.setConfig('atomGithub.currentRemote', remote.getName());
  }

}

exports["default"] = GitHubTabController;

_defineProperty(GitHubTabController, "propTypes", {
  workspace: _propTypes["default"].object.isRequired,
  repository: _propTypes["default"].object.isRequired,
  remoteOperationObserver: _propTypes2.OperationStateObserverPropType.isRequired,
  loginModel: _propTypes2.GithubLoginModelPropType.isRequired,
  rootHolder: _propTypes2.RefHolderPropType.isRequired,
  workingDirectory: _propTypes["default"].string,
  allRemotes: _propTypes2.RemoteSetPropType.isRequired,
  branches: _propTypes2.BranchSetPropType.isRequired,
  selectedRemoteName: _propTypes["default"].string,
  aheadCount: _propTypes["default"].number,
  pushInProgress: _propTypes["default"].bool.isRequired,
  isLoading: _propTypes["default"].bool.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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