Object.defineProperty(exports, '__esModule', {
  value: true
});

var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var _grim = require('grim');

var _grim2 = _interopRequireDefault(_grim);

var _marked = require('marked');

var _marked2 = _interopRequireDefault(_marked);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _shell = require('shell');

var _shell2 = _interopRequireDefault(_shell);

var DeprecationCopView = (function () {
  function DeprecationCopView(_ref) {
    var _this = this;

    var uri = _ref.uri;

    _classCallCheck(this, DeprecationCopView);

    this.uri = uri;
    this.subscriptions = new _atom.CompositeDisposable();
    this.subscriptions.add(_grim2['default'].on('updated', function () {
      _etch2['default'].update(_this);
    }));
    // TODO: Remove conditional when the new StyleManager deprecation APIs reach stable.
    if (atom.styles.onDidUpdateDeprecations) {
      this.subscriptions.add(atom.styles.onDidUpdateDeprecations(function () {
        _etch2['default'].update(_this);
      }));
    }
    _etch2['default'].initialize(this);
    this.subscriptions.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));
  }

  _createClass(DeprecationCopView, [{
    key: 'serialize',
    value: function serialize() {
      return {
        deserializer: this.constructor.name,
        uri: this.getURI(),
        version: 1
      };
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      this.subscriptions.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {
      return _etch2['default'].update(this);
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      return _etch2['default'].dom(
        'div',
        {
          className: 'deprecation-cop pane-item native-key-bindings',
          tabIndex: '-1'
        },
        _etch2['default'].dom(
          'div',
          { className: 'panel' },
          _etch2['default'].dom(
            'div',
            { className: 'padded deprecation-overview' },
            _etch2['default'].dom(
              'div',
              { className: 'pull-right btn-group' },
              _etch2['default'].dom(
                'button',
                {
                  className: 'btn btn-primary check-for-update',
                  onclick: function (event) {
                    event.preventDefault();
                    _this2.checkForUpdates();
                  }
                },
                'Check for Updates'
              )
            )
          ),
          _etch2['default'].dom(
            'div',
            { className: 'panel-heading' },
            _etch2['default'].dom(
              'span',
              null,
              'Deprecated calls'
            )
          ),
          _etch2['default'].dom(
            'ul',
            { className: 'list-tree has-collapsable-children' },
            this.renderDeprecatedCalls()
          ),
          _etch2['default'].dom(
            'div',
            { className: 'panel-heading' },
            _etch2['default'].dom(
              'span',
              null,
              'Deprecated selectors'
            )
          ),
          _etch2['default'].dom(
            'ul',
            { className: 'selectors list-tree has-collapsable-children' },
            this.renderDeprecatedSelectors()
          )
        )
      );
    }
  }, {
    key: 'renderDeprecatedCalls',
    value: function renderDeprecatedCalls() {
      var _this3 = this;

      var deprecationsByPackageName = this.getDeprecatedCallsByPackageName();
      var packageNames = Object.keys(deprecationsByPackageName);
      if (packageNames.length === 0) {
        return _etch2['default'].dom(
          'li',
          { className: 'list-item' },
          'No deprecated calls'
        );
      } else {
        return packageNames.sort().map(function (packageName) {
          return _etch2['default'].dom(
            'li',
            { className: 'deprecation list-nested-item collapsed' },
            _etch2['default'].dom(
              'div',
              {
                className: 'deprecation-info list-item',
                onclick: function (event) {
                  return event.target.parentElement.classList.toggle('collapsed');
                }
              },
              _etch2['default'].dom(
                'span',
                { className: 'text-highlight' },
                packageName || 'atom core'
              ),
              _etch2['default'].dom(
                'span',
                null,
                ' (' + _underscorePlus2['default'].pluralize(deprecationsByPackageName[packageName].length, 'deprecation') + ')'
              )
            ),
            _etch2['default'].dom(
              'ul',
              { className: 'list' },
              _this3.renderPackageActionsIfNeeded(packageName),
              deprecationsByPackageName[packageName].map(function (_ref2) {
                var deprecation = _ref2.deprecation;
                var stack = _ref2.stack;
                return _etch2['default'].dom(
                  'li',
                  { className: 'list-item deprecation-detail' },
                  _etch2['default'].dom('span', { className: 'text-warning icon icon-alert' }),
                  _etch2['default'].dom('div', {
                    className: 'list-item deprecation-message',
                    innerHTML: (0, _marked2['default'])(deprecation.getMessage())
                  }),
                  _this3.renderIssueURLIfNeeded(packageName, deprecation, _this3.buildIssueURL(packageName, deprecation, stack)),
                  _etch2['default'].dom(
                    'div',
                    { className: 'stack-trace' },
                    stack.map(function (_ref3) {
                      var functionName = _ref3.functionName;
                      var location = _ref3.location;
                      return _etch2['default'].dom(
                        'div',
                        { className: 'stack-line' },
                        _etch2['default'].dom(
                          'span',
                          null,
                          functionName
                        ),
                        _etch2['default'].dom(
                          'span',
                          null,
                          ' - '
                        ),
                        _etch2['default'].dom(
                          'a',
                          {
                            className: 'stack-line-location',
                            href: location,
                            onclick: function (event) {
                              event.preventDefault();
                              _this3.openLocation(location);
                            }
                          },
                          location
                        )
                      );
                    })
                  )
                );
              })
            )
          );
        });
      }
    }
  }, {
    key: 'renderDeprecatedSelectors',
    value: function renderDeprecatedSelectors() {
      var _this4 = this;

      var deprecationsByPackageName = this.getDeprecatedSelectorsByPackageName();
      var packageNames = Object.keys(deprecationsByPackageName);
      if (packageNames.length === 0) {
        return _etch2['default'].dom(
          'li',
          { className: 'list-item' },
          'No deprecated selectors'
        );
      } else {
        return packageNames.map(function (packageName) {
          return _etch2['default'].dom(
            'li',
            { className: 'deprecation list-nested-item collapsed' },
            _etch2['default'].dom(
              'div',
              {
                className: 'deprecation-info list-item',
                onclick: function (event) {
                  return event.target.parentElement.classList.toggle('collapsed');
                }
              },
              _etch2['default'].dom(
                'span',
                { className: 'text-highlight' },
                packageName
              )
            ),
            _etch2['default'].dom(
              'ul',
              { className: 'list' },
              _this4.renderPackageActionsIfNeeded(packageName),
              deprecationsByPackageName[packageName].map(function (_ref4) {
                var packagePath = _ref4.packagePath;
                var sourcePath = _ref4.sourcePath;
                var deprecation = _ref4.deprecation;

                var relativeSourcePath = _path2['default'].relative(packagePath, sourcePath);
                var issueTitle = 'Deprecated selector in `' + relativeSourcePath + '`';
                var issueBody = 'In `' + relativeSourcePath + '`: \n\n' + deprecation.message;
                return _etch2['default'].dom(
                  'li',
                  { className: 'list-item source-file' },
                  _etch2['default'].dom(
                    'a',
                    {
                      className: 'source-url',
                      href: sourcePath,
                      onclick: function (event) {
                        event.preventDefault();
                        _this4.openLocation(sourcePath);
                      }
                    },
                    relativeSourcePath
                  ),
                  _etch2['default'].dom(
                    'ul',
                    { className: 'list' },
                    _etch2['default'].dom(
                      'li',
                      { className: 'list-item deprecation-detail' },
                      _etch2['default'].dom('span', { className: 'text-warning icon icon-alert' }),
                      _etch2['default'].dom('div', {
                        className: 'list-item deprecation-message',
                        innerHTML: (0, _marked2['default'])(deprecation.message)
                      }),
                      _this4.renderSelectorIssueURLIfNeeded(packageName, issueTitle, issueBody)
                    )
                  )
                );
              })
            )
          );
        });
      }
    }
  }, {
    key: 'renderPackageActionsIfNeeded',
    value: function renderPackageActionsIfNeeded(packageName) {
      var _this5 = this;

      if (packageName && atom.packages.getLoadedPackage(packageName)) {
        return _etch2['default'].dom(
          'div',
          { className: 'padded' },
          _etch2['default'].dom(
            'div',
            { className: 'btn-group' },
            _etch2['default'].dom(
              'button',
              {
                className: 'btn check-for-update',
                onclick: function (event) {
                  event.preventDefault();
                  _this5.checkForUpdates();
                }
              },
              'Check for Update'
            ),
            _etch2['default'].dom(
              'button',
              {
                className: 'btn disable-package',
                'data-package-name': packageName,
                onclick: function (event) {
                  event.preventDefault();
                  _this5.disablePackage(packageName);
                }
              },
              'Disable Package'
            )
          )
        );
      } else {
        return '';
      }
    }
  }, {
    key: 'encodeURI',
    value: (function (_encodeURI) {
      function encodeURI(_x) {
        return _encodeURI.apply(this, arguments);
      }

      encodeURI.toString = function () {
        return _encodeURI.toString();
      };

      return encodeURI;
    })(function (str) {
      return encodeURI(str).replace(/#/g, '%23').replace(/;/g, '%3B').replace(/%20/g, '+');
    })
  }, {
    key: 'renderSelectorIssueURLIfNeeded',
    value: function renderSelectorIssueURLIfNeeded(packageName, issueTitle, issueBody) {
      var _this6 = this;

      var repoURL = this.getRepoURL(packageName);
      if (repoURL) {
        var _ret = (function () {
          var issueURL = repoURL + '/issues/new?title=' + _this6.encodeURI(issueTitle) + '&body=' + _this6.encodeURI(issueBody);
          return {
            v: _etch2['default'].dom(
              'div',
              { className: 'btn-toolbar' },
              _etch2['default'].dom(
                'button',
                {
                  className: 'btn issue-url',
                  'data-issue-title': issueTitle,
                  'data-repo-url': repoURL,
                  'data-issue-url': issueURL,
                  onclick: function (event) {
                    event.preventDefault();
                    _this6.openIssueURL(repoURL, issueURL, issueTitle);
                  }
                },
                'Report Issue'
              )
            )
          };
        })();

        if (typeof _ret === 'object') return _ret.v;
      } else {
        return '';
      }
    }
  }, {
    key: 'renderIssueURLIfNeeded',
    value: function renderIssueURLIfNeeded(packageName, deprecation, issueURL) {
      var _this7 = this;

      if (packageName && issueURL) {
        var _ret2 = (function () {
          var repoURL = _this7.getRepoURL(packageName);
          var issueTitle = deprecation.getOriginName() + ' is deprecated.';
          return {
            v: _etch2['default'].dom(
              'div',
              { className: 'btn-toolbar' },
              _etch2['default'].dom(
                'button',
                {
                  className: 'btn issue-url',
                  'data-issue-title': issueTitle,
                  'data-repo-url': repoURL,
                  'data-issue-url': issueURL,
                  onclick: function (event) {
                    event.preventDefault();
                    _this7.openIssueURL(repoURL, issueURL, issueTitle);
                  }
                },
                'Report Issue'
              )
            )
          };
        })();

        if (typeof _ret2 === 'object') return _ret2.v;
      } else {
        return '';
      }
    }
  }, {
    key: 'buildIssueURL',
    value: function buildIssueURL(packageName, deprecation, stack) {
      var repoURL = this.getRepoURL(packageName);
      if (repoURL) {
        var title = deprecation.getOriginName() + ' is deprecated.';
        var stacktrace = stack.map(function (_ref5) {
          var functionName = _ref5.functionName;
          var location = _ref5.location;
          return functionName + ' (' + location + ')';
        }).join('\n');
        var body = deprecation.getMessage() + '\n```\n' + stacktrace + '\n```';
        return repoURL + '/issues/new?title=' + encodeURI(title) + '&body=' + encodeURI(body);
      } else {
        return null;
      }
    }
  }, {
    key: 'openIssueURL',
    value: _asyncToGenerator(function* (repoURL, issueURL, issueTitle) {
      var issue = yield this.findSimilarIssue(repoURL, issueTitle);
      if (issue) {
        _shell2['default'].openExternal(issue.html_url);
      } else if (process.platform === 'win32') {
        // Windows will not launch URLs greater than ~2000 bytes so we need to shrink it
        _shell2['default'].openExternal((yield this.shortenURL(issueURL)) || issueURL);
      } else {
        _shell2['default'].openExternal(issueURL);
      }
    })
  }, {
    key: 'findSimilarIssue',
    value: _asyncToGenerator(function* (repoURL, issueTitle) {
      var url = 'https://api.github.com/search/issues';
      var repo = repoURL.replace(/http(s)?:\/\/(\d+\.)?github.com\//gi, '');
      var query = issueTitle + ' repo:' + repo;
      var response = yield window.fetch(url + '?q=' + encodeURI(query) + '&sort=created', {
        method: 'GET',
        headers: {
          Accept: 'application/vnd.github.v3+json',
          'Content-Type': 'application/json'
        }
      });

      if (response.ok) {
        var data = yield response.json();
        if (data.items) {
          var issues = {};
          for (var issue of data.items) {
            if (issue.title.includes(issueTitle) && !issues[issue.state]) {
              issues[issue.state] = issue;
            }
          }

          return issues.open || issues.closed;
        }
      }
    })
  }, {
    key: 'shortenURL',
    value: _asyncToGenerator(function* (url) {
      var encodedUrl = encodeURIComponent(url).substr(0, 5000); // is.gd has 5000 char limit
      var incompletePercentEncoding = encodedUrl.indexOf('%', encodedUrl.length - 2);
      if (incompletePercentEncoding >= 0) {
        // Handle an incomplete % encoding cut-off
        encodedUrl = encodedUrl.substr(0, incompletePercentEncoding);
      }

      var result = yield fetch('https://is.gd/create.php?format=simple', {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: 'url=' + encodedUrl
      });

      return result.text();
    })
  }, {
    key: 'getRepoURL',
    value: function getRepoURL(packageName) {
      var loadedPackage = atom.packages.getLoadedPackage(packageName);
      if (loadedPackage && loadedPackage.metadata && loadedPackage.metadata.repository) {
        var url = loadedPackage.metadata.repository.url || loadedPackage.metadata.repository;
        return url.replace(/\.git$/, '');
      } else {
        return null;
      }
    }
  }, {
    key: 'getDeprecatedCallsByPackageName',
    value: function getDeprecatedCallsByPackageName() {
      var deprecatedCalls = _grim2['default'].getDeprecations();
      deprecatedCalls.sort(function (a, b) {
        return b.getCallCount() - a.getCallCount();
      });
      var deprecatedCallsByPackageName = {};
      for (var deprecation of deprecatedCalls) {
        var stacks = deprecation.getStacks();
        stacks.sort(function (a, b) {
          return b.callCount - a.callCount;
        });
        for (var stack of stacks) {
          var packageName = null;
          if (stack.metadata && stack.metadata.packageName) {
            packageName = stack.metadata.packageName;
          } else {
            packageName = (this.getPackageName(stack) || '').toLowerCase();
          }

          deprecatedCallsByPackageName[packageName] = deprecatedCallsByPackageName[packageName] || [];
          deprecatedCallsByPackageName[packageName].push({ deprecation: deprecation, stack: stack });
        }
      }
      return deprecatedCallsByPackageName;
    }
  }, {
    key: 'getDeprecatedSelectorsByPackageName',
    value: function getDeprecatedSelectorsByPackageName() {
      var deprecatedSelectorsByPackageName = {};
      if (atom.styles.getDeprecations) {
        var deprecatedSelectorsBySourcePath = atom.styles.getDeprecations();
        for (var sourcePath of Object.keys(deprecatedSelectorsBySourcePath)) {
          var deprecation = deprecatedSelectorsBySourcePath[sourcePath];
          var components = sourcePath.split(_path2['default'].sep);
          var packagesComponentIndex = components.indexOf('packages');
          var packageName = null;
          var packagePath = null;
          if (packagesComponentIndex === -1) {
            packageName = 'Other'; // could be Atom Core or the personal style sheet
            packagePath = '';
          } else {
            packageName = components[packagesComponentIndex + 1];
            packagePath = components.slice(0, packagesComponentIndex + 1).join(_path2['default'].sep);
          }

          deprecatedSelectorsByPackageName[packageName] = deprecatedSelectorsByPackageName[packageName] || [];
          deprecatedSelectorsByPackageName[packageName].push({
            packagePath: packagePath,
            sourcePath: sourcePath,
            deprecation: deprecation
          });
        }
      }

      return deprecatedSelectorsByPackageName;
    }
  }, {
    key: 'getPackageName',
    value: function getPackageName(stack) {
      var packagePaths = this.getPackagePathsByPackageName();
      for (var _ref63 of packagePaths) {
        var _ref62 = _slicedToArray(_ref63, 2);

        var packageName = _ref62[0];
        var packagePath = _ref62[1];

        if (packagePath.includes('.atom/dev/packages') || packagePath.includes('.atom/packages')) {
          packagePaths.set(packageName, _fsPlus2['default'].absolute(packagePath));
        }
      }

      for (var i = 1; i < stack.length; i++) {
        var fileName = stack[i].fileName;

        // Empty when it was run from the dev console
        if (!fileName) {
          return null;
        }

        // Continue to next stack entry if call is in node_modules
        if (fileName.includes(_path2['default'].sep + 'node_modules' + _path2['default'].sep)) {
          continue;
        }

        for (var _ref73 of packagePaths) {
          var _ref72 = _slicedToArray(_ref73, 2);

          var packageName = _ref72[0];
          var packagePath = _ref72[1];

          var relativePath = _path2['default'].relative(packagePath, fileName);
          if (!/^\.\./.test(relativePath)) {
            return packageName;
          }
        }

        if (atom.getUserInitScriptPath() === fileName) {
          return 'Your local ' + _path2['default'].basename(fileName) + ' file';
        }
      }

      return null;
    }
  }, {
    key: 'getPackagePathsByPackageName',
    value: function getPackagePathsByPackageName() {
      if (this.packagePathsByPackageName) {
        return this.packagePathsByPackageName;
      } else {
        this.packagePathsByPackageName = new Map();
        for (var pack of atom.packages.getLoadedPackages()) {
          this.packagePathsByPackageName.set(pack.name, pack.path);
        }
        return this.packagePathsByPackageName;
      }
    }
  }, {
    key: 'checkForUpdates',
    value: function checkForUpdates() {
      atom.workspace.open('atom://config/updates');
    }
  }, {
    key: 'disablePackage',
    value: function disablePackage(packageName) {
      if (packageName) {
        atom.packages.disablePackage(packageName);
      }
    }
  }, {
    key: 'openLocation',
    value: function openLocation(location) {
      var pathToOpen = location.replace('file://', '');
      if (process.platform === 'win32') {
        pathToOpen = pathToOpen.replace(/^\//, '');
      }
      atom.open({ pathsToOpen: [pathToOpen] });
    }
  }, {
    key: 'getURI',
    value: function getURI() {
      return this.uri;
    }
  }, {
    key: 'getTitle',
    value: function getTitle() {
      return 'Deprecation Cop';
    }
  }, {
    key: 'getIconName',
    value: function getIconName() {
      return 'alert';
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return DeprecationCopView;
})();

exports['default'] = DeprecationCopView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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