/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.image.readers;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.sunflow.image.Bitmap;
import org.sunflow.image.BitmapReader;
import org.sunflow.image.formats.BitmapRGBE;

public class HDRBitmapReader
implements BitmapReader {
    public Bitmap load(String string, boolean bl) throws IOException, BitmapReader.BitmapFormatException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        InputStream inputStream;
        try {
            JarURLConnection jarURLConnection;
            URL uRL;
            URLConnection uRLConnection = new URL(string).openConnection();
            if (uRLConnection instanceof JarURLConnection && (uRL = (jarURLConnection = (JarURLConnection)uRLConnection).getJarFileURL()).getProtocol().equalsIgnoreCase("file")) {
                try {
                    if (new File(uRL.toURI()).canWrite()) {
                        uRLConnection.setUseCaches(false);
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new IOException(uRISyntaxException);
                }
            }
            inputStream = uRLConnection.getInputStream();
        }
        catch (MalformedURLException malformedURLException) {
            inputStream = new FileInputStream(string);
        }
        inputStream = new BufferedInputStream(inputStream);
        boolean bl2 = false;
        boolean bl3 = false;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        while (n6 == 0 || n7 == 0 || n8 != 10) {
            int n9 = inputStream.read();
            switch (n9) {
                case 89: {
                    bl3 = n8 == 45;
                    bl2 = false;
                    break;
                }
                case 88: {
                    bl3 = false;
                    bl2 = n8 == 43;
                    break;
                }
                case 32: {
                    bl2 &= n6 == 0;
                    bl3 &= n7 == 0;
                    break;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    if (bl3) {
                        n7 = 10 * n7 + (n9 - 48);
                        break;
                    }
                    if (!bl2) break;
                    n6 = 10 * n6 + (n9 - 48);
                    break;
                }
                default: {
                    bl3 = false;
                    bl2 = false;
                }
            }
            n8 = n9;
        }
        int[] nArray = new int[n6 * n7];
        if (n6 < 8 || n6 > Short.MAX_VALUE) {
            this.readFlatRGBE(inputStream, 0, n6 * n7, nArray);
        } else {
            n5 = 0;
            int[] nArray2 = new int[4 * n6];
            for (n4 = n7; n4 > 0; --n4) {
                int n10;
                n3 = inputStream.read();
                n2 = inputStream.read();
                n = inputStream.read();
                int n11 = inputStream.read();
                if (n3 != 2 || n2 != 2 || (n & 0x80) != 0) {
                    nArray[n5] = n3 << 24 | n2 << 16 | n << 8 | n11;
                    this.readFlatRGBE(inputStream, n5 + 1, n6 * n4 - 1, nArray);
                    break;
                }
                if ((n << 8 | n11) != n6) {
                    throw new BitmapReader.BitmapFormatException("Invalid scanline width");
                }
                int n12 = 0;
                for (n10 = 0; n10 < 4; ++n10) {
                    if (n12 % n6 != 0) {
                        throw new BitmapReader.BitmapFormatException("Unaligned access to scanline data");
                    }
                    int n13 = (n10 + 1) * n6;
                    while (n12 < n13) {
                        int n14;
                        int n15 = inputStream.read();
                        int n16 = inputStream.read();
                        if (n15 > 128) {
                            n14 = n15 - 128;
                            if (n14 == 0 || n14 > n13 - n12) {
                                throw new BitmapReader.BitmapFormatException("Bad scanline data - invalid RLE run");
                            }
                            while (n14-- > 0) {
                                nArray2[n12] = n16;
                                ++n12;
                            }
                            continue;
                        }
                        n14 = n15;
                        if (n14 == 0 || n14 > n13 - n12) {
                            throw new BitmapReader.BitmapFormatException("Bad scanline data - invalid count");
                        }
                        nArray2[n12] = n16;
                        ++n12;
                        if (--n14 <= 0) continue;
                        for (int i = 0; i < n14; ++i) {
                            nArray2[n12 + i] = inputStream.read();
                        }
                        n12 += n14;
                    }
                }
                for (n10 = 0; n10 < n6; ++n10) {
                    n3 = nArray2[n10];
                    n2 = nArray2[n10 + n6];
                    n = nArray2[n10 + 2 * n6];
                    n11 = nArray2[n10 + 3 * n6];
                    nArray[n5] = n3 << 24 | n2 << 16 | n << 8 | n11;
                    ++n5;
                }
            }
        }
        inputStream.close();
        n5 = 0;
        n4 = 0;
        int n17 = (n7 - 1) * n6;
        while (n5 < n7 / 2) {
            n3 = 0;
            n2 = n17;
            while (n3 < n6) {
                n = nArray[n4];
                nArray[n4] = nArray[n2];
                nArray[n2] = n;
                ++n3;
                ++n4;
                ++n2;
            }
            ++n5;
            n17 -= n6;
        }
        return new BitmapRGBE(n6, n7, nArray);
    }

    private void readFlatRGBE(InputStream inputStream, int n, int n2, int[] nArray) throws IOException {
        while (n2-- > 0) {
            int n3 = inputStream.read();
            int n4 = inputStream.read();
            int n5 = inputStream.read();
            int n6 = inputStream.read();
            nArray[n] = n3 << 24 | n4 << 16 | n5 << 8 | n6;
            ++n;
        }
    }
}

