/*
 * Decompiled with CFR 0.152.
 */
package hughai.mapping;

import com.springrts.ai.oo.clb.OOAICallback;
import com.springrts.ai.oo.clb.Unit;
import com.springrts.ai.oo.clb.UnitDef;
import hughai.CSAI;
import hughai.GameAdapter;
import hughai.PlayerObjects;
import hughai.VoiceCommandHandler;
import hughai.basictypes.Int2;
import hughai.basictypes.TerrainPos;
import hughai.mapping.HeightMap;
import hughai.ui.MainUI;
import hughai.unitdata.UnitController;
import hughai.unitdata.UnitDefHelp;
import hughai.utils.DrawingUtils;
import hughai.utils.LogFile;
import java.util.HashMap;

public class BuildMap {
    public static final int granularity = 1;
    CSAI csai;
    OOAICallback aicallback;
    LogFile logfile;
    UnitDefHelp unitdefhelp;
    UnitController unitcontroller;
    DrawingUtils drawingUtils;
    HashMap<Unit, BuildingInfo> buildinginfobyunit = new HashMap();
    private boolean[][] SquareAvailable;
    static int mapwidth;
    static int mapheight;
    static int buildmapwidth;
    static int buildmapheight;

    public BuildMap(PlayerObjects playerObjects) {
        this.csai = playerObjects.getCSAI();
        this.aicallback = this.csai.aicallback;
        this.logfile = playerObjects.getLogFile();
        this.unitdefhelp = playerObjects.getUnitDefHelp();
        this.unitcontroller = playerObjects.getUnitController();
        this.drawingUtils = playerObjects.getDrawingUtils();
        this.csai.registerGameListener(new GameListener());
        if (this.csai.DebugOn) {
            // empty if block
        }
        playerObjects.getMainUI().registerButton("Show build map", new ShowBuildMapButton());
        this.Init();
    }

    public void Init() {
        this.logfile.WriteLine("BuildMap.Init()");
        mapwidth = this.aicallback.getMap().getWidth();
        mapheight = this.aicallback.getMap().getHeight();
        buildmapwidth = mapwidth;
        buildmapheight = mapheight;
        this.SquareAvailable = new boolean[mapwidth][mapheight];
        for (int i = 0; i < mapwidth; ++i) {
            for (int j = 0; j < mapheight; ++j) {
                this.SquareAvailable[i][j] = true;
            }
        }
        this.logfile.WriteLine("BuildMap.Init finished()");
    }

    public boolean isSquareAvailable(BuildMapPos buildMapPos) {
        return this.SquareAvailable[buildMapPos.x][buildMapPos.y];
    }

    public void ReserveSpace(Object object, BuildMapPos buildMapPos, int n, int n2) {
        if (this.csai.DebugOn) {
            // empty if block
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n3 = buildMapPos.x + i - n / 2;
                int n4 = buildMapPos.y + j - n2 / 2;
                if (n3 < 0 || n4 < 0 || n3 >= mapwidth || n4 >= mapheight) continue;
                this.SquareAvailable[n3][n4] = false;
            }
        }
    }

    class GameListener
    extends GameAdapter {
        GameListener() {
        }

        @Override
        public void UnitCreated(Unit unit, Unit unit2) {
            UnitDef unitDef = unit.getDef();
            if (!BuildMap.this.buildinginfobyunit.containsKey(unit) && !BuildMap.this.unitdefhelp.IsMobile(unit.getDef())) {
                TerrainPos terrainPos = BuildMap.this.unitcontroller.getPos(unit);
                BuildMapPos buildMapPos = BuildMapPos.fromTerrainPos(terrainPos);
                int n = unitDef.getXSize();
                int n2 = unitDef.getZSize();
                BuildMap.this.logfile.WriteLine("Buildmap static unit created " + unitDef.getName() + " mappos " + buildMapPos + " unitsize " + n + " " + n2);
                BuildMap.this.buildinginfobyunit.put(unit, new BuildingInfo(buildMapPos, n, n2));
                if (BuildMap.this.csai.DebugOn) {
                    // empty if block
                }
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        int n3 = buildMapPos.x + i - unitDef.getXSize() / 2;
                        int n4 = buildMapPos.y + j - unitDef.getZSize() / 2;
                        ((BuildMap)BuildMap.this).SquareAvailable[n3][n4] = false;
                    }
                }
            }
        }

        @Override
        public void UnitDestroyed(Unit unit, Unit unit2) {
            BuildMap.this.logfile.WriteLine("BuildMap.unitdestroyed " + unit.getUnitId() + " " + unit.getDef().getHumanName());
            if (BuildMap.this.buildinginfobyunit.containsKey(unit)) {
                BuildingInfo buildingInfo = BuildMap.this.buildinginfobyunit.get(unit);
                for (int i = 0; i < buildingInfo.mapsizex / 8; ++i) {
                    for (int j = 0; j < buildingInfo.mapsizey / 8; ++j) {
                        ((BuildMap)BuildMap.this).SquareAvailable[buildingInfo.mapPos.x + i][buildingInfo.mapPos.y + j] = true;
                    }
                }
                BuildMap.this.buildinginfobyunit.remove(unit);
            }
        }
    }

    public class DumpBuildMapHandler
    implements VoiceCommandHandler {
        @Override
        public void commandReceived(String string, String[] stringArray, int n) {
            BuildMap.this.drawingUtils.DrawMap(BuildMap.this.SquareAvailable);
        }
    }

    class ShowBuildMapButton
    implements MainUI.ButtonHandler {
        ShowBuildMapButton() {
        }

        @Override
        public void go() {
            BuildMap.this.drawingUtils.DrawMap(BuildMap.this.SquareAvailable);
        }
    }

    static class BuildingInfo {
        BuildMapPos mapPos;
        public int mapsizex;
        public int mapsizey;

        public BuildingInfo(BuildMapPos buildMapPos, int n, int n2) {
            this.mapPos = buildMapPos;
            this.mapsizex = n;
            this.mapsizey = n2;
        }
    }

    public static class BuildMapPos
    extends Int2 {
        public BuildMapPos() {
        }

        public BuildMapPos(Int2 int2) {
            this.x = int2.x;
            this.y = int2.y;
        }

        public BuildMapPos(int n, int n2) {
            super(n, n2);
        }

        public TerrainPos toTerrainPos() {
            return new TerrainPos(this.x * 8 * 1, 0.0f, this.y * 8 * 1);
        }

        HeightMap.HeightMapPos toHeightMapPos() {
            return new HeightMap.HeightMapPos(this.x, this.y);
        }

        public static BuildMapPos fromHeightMapPos(HeightMap.HeightMapPos heightMapPos) {
            return new BuildMapPos(heightMapPos.x, heightMapPos.y);
        }

        public static BuildMapPos fromTerrainPos(TerrainPos terrainPos) {
            return new BuildMapPos((int)terrainPos.x / 8 / 1, (int)terrainPos.z / 8 / 1);
        }

        public boolean validate() {
            return this.x >= 0 && this.y >= 0 && this.x < buildmapwidth && this.y < buildmapheight;
        }
    }
}

