/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.pivotal;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.TaskState;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.tasks.impl.BaseRepositoryImpl;
import com.intellij.tasks.impl.SimpleComment;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.tasks.pivotal.PivotalTrackerRepositoryType;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.HTTPMethod;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="PivotalTracker")
public class PivotalTrackerRepository
extends BaseRepositoryImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.tasks.pivotal.PivotalTrackerRepository");
    private static final String API_URL = "/services/v3";
    private Pattern myPattern;
    private String myProjectId;
    private String myAPIKey;

    public PivotalTrackerRepository() {
        if (StringUtil.isEmpty((String)this.getUrl())) {
            this.setUrl("https://www.pivotaltracker.com");
        }
        this.myCommitMessageFormat = "[fixes #{number}] {summary}";
    }

    public PivotalTrackerRepository(PivotalTrackerRepositoryType type) {
        super((TaskRepositoryType)type);
        if (StringUtil.isEmpty((String)this.getUrl())) {
            this.setUrl("https://www.pivotaltracker.com");
        }
    }

    private PivotalTrackerRepository(PivotalTrackerRepository other) {
        super((BaseRepositoryImpl)other);
        if (StringUtil.isEmpty((String)this.getUrl())) {
            this.setUrl("https://www.pivotaltracker.com");
        }
        this.setProjectId(other.myProjectId);
        this.setAPIKey(other.myAPIKey);
    }

    public void testConnection() throws Exception {
        this.getIssues("", 10, 0L);
    }

    public boolean isConfigured() {
        return super.isConfigured() && StringUtil.isNotEmpty((String)this.getProjectId()) && StringUtil.isNotEmpty((String)this.getAPIKey());
    }

    public Task[] getIssues(@Nullable String query, int max, long since) throws Exception {
        List<Element> children = this.getStories(query, max);
        List tasks = ContainerUtil.mapNotNull(children, (Function)((NullableFunction)o -> this.createIssue((Element)o)));
        return tasks.toArray(Task.EMPTY_ARRAY);
    }

    private List<Element> getStories(@Nullable String query, int max) throws Exception {
        String url = "/services/v3/projects/" + this.myProjectId + "/stories";
        url = url + "?filter=" + PivotalTrackerRepository.encodeUrl((String)"state:started,unstarted,unscheduled,rejected");
        if (!StringUtil.isEmpty((String)query)) {
            url = url + PivotalTrackerRepository.encodeUrl((String)(" \"" + query + '\"'));
        }
        if (max >= 0) {
            url = url + "&limit=" + PivotalTrackerRepository.encodeUrl((String)String.valueOf(max));
        }
        LOG.info("Getting all the stories with url: " + url);
        HttpMethod method = this.doREST(url, HTTPMethod.GET);
        InputStream stream = method.getResponseBodyAsStream();
        Element element = new SAXBuilder(false).build(stream).getRootElement();
        if (!"stories".equals(element.getName())) {
            LOG.warn("Error fetching issues for: " + url + ", HTTP status code: " + method.getStatusCode());
            throw new Exception("Error fetching issues for: " + url + ", HTTP status code: " + method.getStatusCode() + "\n" + element.getText());
        }
        return element.getChildren("story");
    }

    @Nullable
    private Task createIssue(Element element) {
        final String id = element.getChildText("id");
        if (id == null) {
            return null;
        }
        final String summary = element.getChildText("name");
        if (summary == null) {
            return null;
        }
        final String type = element.getChildText("story_type");
        if (type == null) {
            return null;
        }
        final Comment[] comments = PivotalTrackerRepository.parseComments(element.getChild("notes"));
        final boolean isClosed = "accepted".equals(element.getChildText("state")) || "delivered".equals(element.getChildText("state")) || "finished".equals(element.getChildText("state"));
        final String description = element.getChildText("description");
        final Ref updated = new Ref();
        final Ref created = new Ref();
        try {
            updated.set((Object)PivotalTrackerRepository.parseDate(element, "updated_at"));
            created.set((Object)PivotalTrackerRepository.parseDate(element, "created_at"));
        }
        catch (ParseException e) {
            LOG.warn((Throwable)e);
        }
        return new Task(){

            public boolean isIssue() {
                return true;
            }

            public String getIssueUrl() {
                String id2 = PivotalTrackerRepository.this.getRealId(this.getId());
                return id2 != null ? PivotalTrackerRepository.this.getUrl() + "/story/show/" + id2 : null;
            }

            @NotNull
            public String getId() {
                String string = PivotalTrackerRepository.this.myProjectId + "-" + id;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getSummary() {
                String string = summary;
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            public String getDescription() {
                return description;
            }

            @NotNull
            public Comment[] getComments() {
                if (comments == null) {
                    1.$$$reportNull$$$0(2);
                }
                return comments;
            }

            @NotNull
            public Icon getIcon() {
                Icon icon = IconLoader.getIcon((String)this.getCustomIcon(), PivotalTrackerRepository.class);
                if (icon == null) {
                    1.$$$reportNull$$$0(3);
                }
                return icon;
            }

            @NotNull
            public TaskType getType() {
                TaskType taskType = TaskType.OTHER;
                if (taskType == null) {
                    1.$$$reportNull$$$0(4);
                }
                return taskType;
            }

            public Date getUpdated() {
                return (Date)updated.get();
            }

            public Date getCreated() {
                return (Date)created.get();
            }

            public boolean isClosed() {
                return isClosed;
            }

            public TaskRepository getRepository() {
                return PivotalTrackerRepository.this;
            }

            public String getPresentableName() {
                return this.getId() + ": " + this.getSummary();
            }

            @NotNull
            public String getCustomIcon() {
                String string = "/icons/pivotal/" + type + ".png";
                if (string == null) {
                    1.$$$reportNull$$$0(5);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/tasks/pivotal/PivotalTrackerRepository$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSummary";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getComments";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIcon";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getType";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCustomIcon";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private static Comment[] parseComments(Element notes) {
        if (notes == null) {
            return Comment.EMPTY_ARRAY;
        }
        ArrayList<SimpleComment> result = new ArrayList<SimpleComment>();
        for (Element note : notes.getChildren("note")) {
            String text = note.getChildText("text");
            if (text == null) continue;
            Ref date = new Ref();
            try {
                date.set((Object)PivotalTrackerRepository.parseDate(note, "noted_at"));
            }
            catch (ParseException e) {
                LOG.warn((Throwable)e);
            }
            String author = note.getChildText("author");
            result.add(new SimpleComment((Date)date.get(), author, text));
        }
        return result.toArray(Comment.EMPTY_ARRAY);
    }

    @Nullable
    private static Date parseDate(Element element, String name) throws ParseException {
        String date = element.getChildText(name);
        return TaskUtil.parseDate((String)date);
    }

    private HttpMethod doREST(String request, HTTPMethod type) throws Exception {
        HttpClient client = this.getHttpClient();
        client.getParams().setContentCharset("UTF-8");
        String uri = this.getUrl() + request;
        PostMethod method = type == HTTPMethod.POST ? new PostMethod(uri) : (type == HTTPMethod.PUT ? new PutMethod(uri) : new GetMethod(uri));
        this.configureHttpMethod((HttpMethod)method);
        client.executeMethod((HttpMethod)method);
        return method;
    }

    @Nullable
    public Task findTask(@NotNull String id) throws Exception {
        String realId;
        if (id == null) {
            PivotalTrackerRepository.$$$reportNull$$$0(0);
        }
        if ((realId = this.getRealId(id)) == null) {
            return null;
        }
        String url = "/services/v3/projects/" + this.myProjectId + "/stories/" + realId;
        LOG.info("Retrieving issue by id: " + url);
        HttpMethod method = this.doREST(url, HTTPMethod.GET);
        InputStream stream = method.getResponseBodyAsStream();
        Element element = new SAXBuilder(false).build(stream).getRootElement();
        return element.getName().equals("story") ? this.createIssue(element) : null;
    }

    @Nullable
    private String getRealId(String id) {
        String[] split = id.split("\\-");
        String projectId = split[0];
        return Comparing.strEqual((String)projectId, (String)this.myProjectId) ? split[1] : null;
    }

    @Nullable
    public String extractId(@NotNull String taskName) {
        Matcher matcher;
        if (taskName == null) {
            PivotalTrackerRepository.$$$reportNull$$$0(1);
        }
        return (matcher = this.myPattern.matcher(taskName)).find() ? matcher.group(1) : null;
    }

    @NotNull
    public BaseRepository clone() {
        PivotalTrackerRepository pivotalTrackerRepository = new PivotalTrackerRepository(this);
        if (pivotalTrackerRepository == null) {
            PivotalTrackerRepository.$$$reportNull$$$0(2);
        }
        return pivotalTrackerRepository;
    }

    protected void configureHttpMethod(HttpMethod method) {
        method.addRequestHeader("X-TrackerToken", this.myAPIKey);
    }

    public String getProjectId() {
        return this.myProjectId;
    }

    public void setProjectId(String projectId) {
        this.myProjectId = projectId;
        this.myPattern = Pattern.compile("(" + projectId + "\\-\\d+):\\s+");
    }

    public String getAPIKey() {
        return this.myAPIKey;
    }

    public void setAPIKey(String APIKey) {
        this.myAPIKey = APIKey;
    }

    public String getPresentableName() {
        String name = super.getPresentableName();
        return name + (!StringUtil.isEmpty((String)this.getProjectId()) ? "/" + this.getProjectId() : "");
    }

    @Nullable
    public String getTaskComment(@NotNull Task task) {
        if (task == null) {
            PivotalTrackerRepository.$$$reportNull$$$0(3);
        }
        if (this.isShouldFormatCommitMessage()) {
            String id = task.getId();
            String realId = this.getRealId(id);
            return realId != null ? this.myCommitMessageFormat.replace("{id}", realId).replace("{project}", this.myProjectId) + " " + task.getSummary() : null;
        }
        return super.getTaskComment(task);
    }

    public void setTaskState(@NotNull Task task, @NotNull TaskState state) throws Exception {
        String stateName;
        String realId;
        if (task == null) {
            PivotalTrackerRepository.$$$reportNull$$$0(4);
        }
        if (state == null) {
            PivotalTrackerRepository.$$$reportNull$$$0(5);
        }
        if ((realId = this.getRealId(task.getId())) == null) {
            return;
        }
        switch (state) {
            case IN_PROGRESS: {
                stateName = "started";
                break;
            }
            case RESOLVED: {
                stateName = "finished";
                break;
            }
            default: {
                return;
            }
        }
        String url = "/services/v3/projects/" + this.myProjectId + "/stories/" + realId;
        url = url + "?" + PivotalTrackerRepository.encodeUrl((String)"story[current_state]") + "=" + PivotalTrackerRepository.encodeUrl((String)stateName);
        LOG.info("Updating issue state by id: " + url);
        HttpMethod method = this.doREST(url, HTTPMethod.PUT);
        InputStream stream = method.getResponseBodyAsStream();
        Element element = new SAXBuilder(false).build(stream).getRootElement();
        if (!element.getName().equals("story")) {
            if (element.getName().equals("errors")) {
                throw new Exception(PivotalTrackerRepository.extractErrorMessage(element));
            }
            LOG.warn("Error setting state for: " + url + ", HTTP status code: " + method.getStatusCode());
            throw new Exception(String.format("Cannot set state '%s' for issue.", stateName));
        }
    }

    @NotNull
    private static String extractErrorMessage(@NotNull Element element) {
        if (element == null) {
            PivotalTrackerRepository.$$$reportNull$$$0(6);
        }
        String string = StringUtil.notNullize((String)element.getChild("error").getText());
        if (string == null) {
            PivotalTrackerRepository.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof PivotalTrackerRepository)) {
            return false;
        }
        PivotalTrackerRepository that = (PivotalTrackerRepository)((Object)o);
        if (this.getAPIKey() != null ? !this.getAPIKey().equals(that.getAPIKey()) : that.getAPIKey() != null) {
            return false;
        }
        if (this.getProjectId() != null ? !this.getProjectId().equals(that.getProjectId()) : that.getProjectId() != null) {
            return false;
        }
        if (this.getCommitMessageFormat() != null ? !this.getCommitMessageFormat().equals(that.getCommitMessageFormat()) : that.getCommitMessageFormat() != null) {
            return false;
        }
        return this.isShouldFormatCommitMessage() == that.isShouldFormatCommitMessage();
    }

    protected int getFeatures() {
        return super.getFeatures() | 1 | 8;
    }

    public void setUrl(String url) {
        if (url.startsWith("http:")) {
            url = "https:" + StringUtil.trimStart((String)url, (String)"http:");
        }
        super.setUrl(url);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/pivotal/PivotalTrackerRepository";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/pivotal/PivotalTrackerRepository";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "extractErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findTask";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "extractId";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTaskComment";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setTaskState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "extractErrorMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

