/*
 * Decompiled with CFR 0.152.
 */
package git4idea.vfs;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ObjectsConvertor;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsVFSListener;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepositoryFiles;
import git4idea.util.GitFileUtils;
import git4idea.util.GitVcsConsoleWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class GitVFSListener
extends VcsVFSListener {
    private final AtomicInteger myEventsSuppressLevel;
    private final Git myGit;
    private final GitVcsConsoleWriter myVcsConsoleWriter;

    public GitVFSListener(@NotNull Project project, @NotNull GitVcs vcs, @NotNull Git git, @NotNull GitVcsConsoleWriter vcsConsoleWriter) {
        if (project == null) {
            GitVFSListener.$$$reportNull$$$0(0);
        }
        if (vcs == null) {
            GitVFSListener.$$$reportNull$$$0(1);
        }
        if (git == null) {
            GitVFSListener.$$$reportNull$$$0(2);
        }
        if (vcsConsoleWriter == null) {
            GitVFSListener.$$$reportNull$$$0(3);
        }
        super(project, (AbstractVcs)vcs);
        this.myEventsSuppressLevel = new AtomicInteger(0);
        this.myGit = git;
        this.myVcsConsoleWriter = vcsConsoleWriter;
    }

    public void setEventsSuppressed(boolean value) {
        if (value) {
            this.myEventsSuppressLevel.incrementAndGet();
        } else {
            int v = this.myEventsSuppressLevel.decrementAndGet();
            assert (v >= 0);
        }
    }

    protected boolean isEventIgnored(@NotNull VirtualFileEvent event) {
        if (event == null) {
            GitVFSListener.$$$reportNull$$$0(4);
        }
        return super.isEventIgnored(event) || this.myEventsSuppressLevel.get() != 0;
    }

    @NotNull
    protected String getAddTitle() {
        String string = GitBundle.getString("vfs.listener.add.title");
        if (string == null) {
            GitVFSListener.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    protected String getSingleFileAddTitle() {
        String string = GitBundle.getString("vfs.listener.add.single.title");
        if (string == null) {
            GitVFSListener.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    protected String getSingleFileAddPromptTemplate() {
        String string = GitBundle.getString("vfs.listener.add.single.prompt");
        if (string == null) {
            GitVFSListener.$$$reportNull$$$0(7);
        }
        return string;
    }

    protected void executeAdd(final @NotNull List<VirtualFile> addedFiles, final @NotNull Map<VirtualFile, VirtualFile> copiedFiles) {
        Map<VirtualFile, List<VirtualFile>> sortedFiles;
        if (addedFiles == null) {
            GitVFSListener.$$$reportNull$$$0(8);
        }
        if (copiedFiles == null) {
            GitVFSListener.$$$reportNull$$$0(9);
        }
        try {
            sortedFiles = GitUtil.sortFilesByGitRoot(addedFiles, true);
        }
        catch (VcsException e) {
            throw new RuntimeException("The exception is not expected here", e);
        }
        final HashSet retainedFiles = new HashSet();
        ProgressManager progressManager = ProgressManager.getInstance();
        GitVFSListener.saveGitignoreFileIfNeeded(this.myProject);
        progressManager.run((Task)new Task.Backgroundable(this.myProject, GitBundle.getString("vfs.listener.checking.ignored"), true){

            public void run(@NotNull ProgressIndicator pi) {
                if (pi == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (Map.Entry e : sortedFiles.entrySet()) {
                    VirtualFile root = (VirtualFile)e.getKey();
                    List files = (List)e.getValue();
                    pi.setText(root.getPresentableUrl());
                    try {
                        retainedFiles.addAll(GitVFSListener.this.myGit.untrackedFiles(this.myProject, root, files));
                    }
                    catch (VcsException ex) {
                        GitVFSListener.this.myVcsConsoleWriter.showMessage(ex.getMessage());
                    }
                }
                addedFiles.retainAll(retainedFiles);
                AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, () -> GitVFSListener.this.originalExecuteAdd(addedFiles, copiedFiles));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "git4idea/vfs/GitVFSListener$1", "run"));
            }
        });
    }

    private static void saveGitignoreFileIfNeeded(@NotNull Project project) {
        String basePath;
        if (project == null) {
            GitVFSListener.$$$reportNull$$$0(10);
        }
        if ((basePath = project.getBasePath()) == null) {
            return;
        }
        VirtualFile projectRootDir = LocalFileSystem.getInstance().findFileByPath(basePath);
        if (projectRootDir == null) {
            return;
        }
        VirtualFile gitDir = GitUtil.findGitDir(projectRootDir);
        if (gitDir == null) {
            return;
        }
        GitRepositoryFiles gitRepositoryFiles = GitRepositoryFiles.getInstance(gitDir);
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        for (Document document : fileDocumentManager.getUnsavedDocuments()) {
            VirtualFile documentVFile = fileDocumentManager.getFile(document);
            if (documentVFile == null || !gitRepositoryFiles.isGitIgnore(PathUtil.toSystemIndependentName((String)documentVFile.getPath()))) continue;
            fileDocumentManager.saveDocument(document);
        }
    }

    private void originalExecuteAdd(List<VirtualFile> addedFiles, Map<VirtualFile, VirtualFile> copiedFiles) {
        super.executeAdd(addedFiles, copiedFiles);
    }

    protected void performAdding(@NotNull Collection<VirtualFile> addedFiles, @NotNull Map<VirtualFile, VirtualFile> copyFromMap) {
        if (addedFiles == null) {
            GitVFSListener.$$$reportNull$$$0(11);
        }
        if (copyFromMap == null) {
            GitVFSListener.$$$reportNull$$$0(12);
        }
        this.performAdding(ObjectsConvertor.vf2fp(new ArrayList<VirtualFile>(addedFiles)));
    }

    private GitVcs gitVcs() {
        return (GitVcs)this.myVcs;
    }

    private void performAdding(Collection<FilePath> filesToAdd) {
        this.performBackgroundOperation(filesToAdd, GitBundle.getString("add.adding"), new LongOperationPerRootExecutor(){

            @Override
            public void execute(@NotNull VirtualFile root, @NotNull List<FilePath> files) throws VcsException {
                if (root == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (files == null) {
                    2.$$$reportNull$$$0(1);
                }
                LOG.debug("Git: adding files: " + files);
                GitFileUtils.addPaths(GitVFSListener.this.myProject, root, files);
                VcsFileUtil.markFilesDirty((Project)GitVFSListener.this.myProject, files);
            }

            @Override
            public Collection<File> getFilesToRefresh() {
                return Collections.emptyList();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "root";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "files";
                        break;
                    }
                }
                objectArray[1] = "git4idea/vfs/GitVFSListener$2";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    protected String getDeleteTitle() {
        String string = GitBundle.getString("vfs.listener.delete.title");
        if (string == null) {
            GitVFSListener.$$$reportNull$$$0(13);
        }
        return string;
    }

    protected String getSingleFileDeleteTitle() {
        return GitBundle.getString("vfs.listener.delete.single.title");
    }

    protected String getSingleFileDeletePromptTemplate() {
        return GitBundle.getString("vfs.listener.delete.single.prompt");
    }

    protected void performDeletion(@NotNull List<FilePath> filesToDelete) {
        if (filesToDelete == null) {
            GitVFSListener.$$$reportNull$$$0(14);
        }
        this.performBackgroundOperation(filesToDelete, GitBundle.getString("remove.removing"), new LongOperationPerRootExecutor(){
            HashSet<File> filesToRefresh = new HashSet();

            @Override
            public void execute(@NotNull VirtualFile root, @NotNull List<FilePath> files) throws VcsException {
                if (root == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (files == null) {
                    3.$$$reportNull$$$0(1);
                }
                GitFileUtils.deletePaths(GitVFSListener.this.myProject, root, files, "--ignore-unmatch", "--cached");
                if (!GitVFSListener.this.myProject.isDisposed()) {
                    VcsFileUtil.markFilesDirty((Project)GitVFSListener.this.myProject, files);
                }
                File rootFile = new File(root.getPath());
                for (FilePath p : files) {
                    for (File f = p.getIOFile(); f != null && !FileUtil.filesEqual((File)f, (File)rootFile); f = f.getParentFile()) {
                        this.filesToRefresh.add(f);
                    }
                }
            }

            @Override
            public Collection<File> getFilesToRefresh() {
                return this.filesToRefresh;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "root";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "files";
                        break;
                    }
                }
                objectArray[1] = "git4idea/vfs/GitVFSListener$3";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    protected void performMoveRename(@NotNull List<VcsVFSListener.MovedFileInfo> movedFiles) {
        if (movedFiles == null) {
            GitVFSListener.$$$reportNull$$$0(15);
        }
        ArrayList toAdd = ContainerUtil.newArrayList();
        ArrayList toRemove = ContainerUtil.newArrayList();
        ArrayList toForceMove = ContainerUtil.newArrayList();
        for (VcsVFSListener.MovedFileInfo movedInfo : movedFiles) {
            String oldPath = movedInfo.myOldPath;
            String newPath = movedInfo.myNewPath;
            if (!SystemInfo.isFileSystemCaseSensitive && GitUtil.isCaseOnlyChange(oldPath, newPath)) {
                toForceMove.add(movedInfo);
                continue;
            }
            toRemove.add(VcsUtil.getFilePath((String)oldPath));
            toAdd.add(VcsUtil.getFilePath((String)newPath));
        }
        LOG.debug("performMoveRename. \ntoAdd: " + toAdd + "\ntoRemove: " + toRemove + "\ntoForceMove: " + toForceMove);
        this.performAdding(toAdd);
        this.performDeletion(toRemove);
        this.performForceMove(toForceMove);
    }

    private void performForceMove(@NotNull List<VcsVFSListener.MovedFileInfo> files) {
        if (files == null) {
            GitVFSListener.$$$reportNull$$$0(16);
        }
        final Map filesToMove = ContainerUtil.map2Map(files, info -> Pair.create((Object)VcsUtil.getFilePath((String)info.myNewPath), (Object)info));
        final HashSet toRefresh = ContainerUtil.newHashSet();
        this.performBackgroundOperation(filesToMove.keySet(), "Moving Files...", new LongOperationPerRootExecutor(){

            @Override
            public void execute(@NotNull VirtualFile root, @NotNull List<FilePath> files) {
                if (root == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (files == null) {
                    4.$$$reportNull$$$0(1);
                }
                for (FilePath file : files) {
                    VcsVFSListener.MovedFileInfo info = (VcsVFSListener.MovedFileInfo)filesToMove.get(file);
                    GitLineHandler h = new GitLineHandler(GitVFSListener.this.myProject, root, GitCommand.MV);
                    h.addParameters("-f", info.myOldPath, info.myNewPath);
                    GitVFSListener.this.myGit.runCommand(h);
                    toRefresh.add(new File(info.myOldPath));
                    toRefresh.add(new File(info.myNewPath));
                }
            }

            @Override
            public Collection<File> getFilesToRefresh() {
                return toRefresh;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "root";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "files";
                        break;
                    }
                }
                objectArray[1] = "git4idea/vfs/GitVFSListener$4";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    protected boolean isDirectoryVersioningSupported() {
        return false;
    }

    protected Collection<FilePath> selectFilePathsToDelete(@NotNull List<FilePath> deletedFiles) {
        if (deletedFiles == null) {
            GitVFSListener.$$$reportNull$$$0(17);
        }
        return deletedFiles;
    }

    private void performBackgroundOperation(@NotNull Collection<FilePath> files, @NotNull String operationTitle, final @NotNull LongOperationPerRootExecutor executor) {
        Map<VirtualFile, List<FilePath>> sortedFiles;
        if (files == null) {
            GitVFSListener.$$$reportNull$$$0(18);
        }
        if (operationTitle == null) {
            GitVFSListener.$$$reportNull$$$0(19);
        }
        if (executor == null) {
            GitVFSListener.$$$reportNull$$$0(20);
        }
        try {
            sortedFiles = GitUtil.sortFilePathsByGitRoot(files, true);
        }
        catch (VcsException e) {
            this.myVcsConsoleWriter.showMessage(e.getMessage());
            return;
        }
        GitVcs.runInBackground(new Task.Backgroundable(this.myProject, operationTitle){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    5.$$$reportNull$$$0(0);
                }
                for (Map.Entry e : sortedFiles.entrySet()) {
                    try {
                        executor.execute((VirtualFile)e.getKey(), (List)e.getValue());
                    }
                    catch (VcsException ex) {
                        GitVFSListener.this.myVcsConsoleWriter.showMessage(ex.getMessage());
                    }
                }
                RefreshVFsSynchronously.refreshFiles(executor.getFilesToRefresh());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/vfs/GitVFSListener$5", "run"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsConsoleWriter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/vfs/GitVFSListener";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedFiles";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copiedFiles";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyFromMap";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToDelete";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "movedFiles";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deletedFiles";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationTitle";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/vfs/GitVFSListener";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddTitle";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingleFileAddTitle";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingleFileAddPromptTemplate";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeleteTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isEventIgnored";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "executeAdd";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "saveGitignoreFileIfNeeded";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "performAdding";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "performDeletion";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "performMoveRename";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "performForceMove";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "selectFilePathsToDelete";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "performBackgroundOperation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface LongOperationPerRootExecutor {
        public void execute(@NotNull VirtualFile var1, @NotNull List<FilePath> var2) throws VcsException;

        public Collection<File> getFilesToRefresh();
    }
}

