/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.configurable.ModuleVcsListener;
import com.intellij.openapi.vcs.configurable.VcsDirectoryConfigurationPanel;
import com.intellij.openapi.vcs.configurable.VcsGeneralConfigurationPanel;
import com.intellij.openapi.vcs.configurable.VcsManagerConfigurable;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsGeneralConfigurationConfigurable
implements SearchableConfigurable {
    private VcsGeneralConfigurationPanel myPanel;
    private final Project myProject;
    private final VcsManagerConfigurable myMainConfigurable;

    public VcsGeneralConfigurationConfigurable(Project project, VcsManagerConfigurable configurable) {
        this.myProject = project;
        this.myMainConfigurable = configurable;
    }

    @Nullable
    public JComponent createComponent() {
        this.myPanel = new VcsGeneralConfigurationPanel(this.myProject);
        if (this.getMappings() != null) {
            this.myPanel.updateAvailableOptions(this.getMappings().getActiveVcses());
            this.addListenerToGeneralPanel();
        } else {
            this.myPanel.updateAvailableOptions(Arrays.asList(ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllActiveVcss()));
        }
        this.addListenerToGeneralPanel();
        return this.myPanel.getPanel();
    }

    private VcsDirectoryConfigurationPanel getMappings() {
        return this.myMainConfigurable.getMappings();
    }

    private void addListenerToGeneralPanel() {
        VcsDirectoryConfigurationPanel mappings = this.getMappings();
        if (mappings != null) {
            mappings.addVcsListener(new ModuleVcsListener(){

                @Override
                public void activeVcsSetChanged(Collection<AbstractVcs> activeVcses) {
                    VcsGeneralConfigurationConfigurable.this.myPanel.updateAvailableOptions(activeVcses);
                }
            });
        }
    }

    public void apply() throws ConfigurationException {
        this.myPanel.apply();
    }

    public boolean isModified() {
        return this.myPanel.isModified();
    }

    public void reset() {
        this.myPanel.reset();
    }

    public void disposeUIResources() {
        this.myPanel = null;
    }

    @Nls
    public String getDisplayName() {
        return "Confirmation";
    }

    @NotNull
    public String getHelpTopic() {
        if ("project.propVCSSupport.Confirmation" == null) {
            VcsGeneralConfigurationConfigurable.$$$reportNull$$$0(0);
        }
        return "project.propVCSSupport.Confirmation";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            VcsGeneralConfigurationConfigurable.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/vcs/configurable/VcsGeneralConfigurationConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpTopic";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

