/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.repository;

import com.google.common.base.Optional;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.protege.editor.owl.model.repository.extractors.LastResortExtractor;
import org.protege.editor.owl.model.repository.extractors.OntologyIdExtractor;
import org.protege.editor.owl.model.repository.extractors.RdfXmlExtractor;
import org.semanticweb.owlapi.model.OWLOntologyID;

public class MasterOntologyIDExtractor
implements OntologyIdExtractor {
    private List<OntologyIdExtractor> extractors = new ArrayList<OntologyIdExtractor>();

    public MasterOntologyIDExtractor() {
        this.extractors.add(new RdfXmlExtractor());
        this.extractors.add(new LastResortExtractor());
    }

    @Override
    public Optional<OWLOntologyID> getOntologyId(URI location) {
        OntologyIdExtractor extractor;
        Optional<OWLOntologyID> id = Optional.absent();
        Iterator<OntologyIdExtractor> iterator = this.extractors.iterator();
        while (iterator.hasNext() && !(id = (extractor = iterator.next()).getOntologyId(location)).isPresent()) {
        }
        return id;
    }
}

