/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.node;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.docker.api.Credentials;
import org.netbeans.modules.docker.api.DockerAction;
import org.netbeans.modules.docker.api.DockerAuthenticationException;
import org.netbeans.modules.docker.api.DockerException;
import org.netbeans.modules.docker.api.DockerName;
import org.netbeans.modules.docker.api.DockerTag;
import org.netbeans.modules.docker.api.StatusEvent;
import org.netbeans.modules.docker.ui.credentials.CredentialsUtils;
import org.netbeans.modules.docker.ui.node.Bundle;
import org.netbeans.modules.docker.ui.output.StatusOutputListener;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class PushTagAction
extends NodeAction {
    private static final Logger LOGGER = Logger.getLogger(PushTagAction.class.getName());

    protected void performAction(Node[] activatedNodes) {
        for (Node node : activatedNodes) {
            DockerTag tag = (DockerTag)node.getLookup().lookup(DockerTag.class);
            if (tag == null) continue;
            this.perform(tag);
        }
    }

    private void perform(DockerTag tag) {
        NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)Bundle.MSG_PushQuestion(tag.getTag()), 0);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)desc) != NotifyDescriptor.YES_OPTION) {
            return;
        }
        RequestProcessor.getDefault().post((Runnable)new Push(tag));
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes.length != 1) {
            return false;
        }
        DockerTag tag = (DockerTag)activatedNodes[0].getLookup().lookup(DockerTag.class);
        if (tag == null) {
            return false;
        }
        return !"<none>:<none>".equals(tag.getTag());
    }

    public String getName() {
        return Bundle.LBL_PushTagAction();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    private static class Push
    implements Runnable {
        private final DockerTag tag;

        public Push(DockerTag tag) {
            this.tag = tag;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String image = this.tag.getTag();
            final InputOutput io = IOProvider.getDefault().getIO(Bundle.MSG_Pushing(image), false);
            ProgressHandle handle = ProgressHandleFactory.createHandle((String)Bundle.MSG_Pushing(image), (Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    io.select();
                }
            });
            handle.start();
            try {
                io.getOut().reset();
                io.select();
                DockerAction facade = new DockerAction(this.tag.getImage().getInstance());
                facade.push(this.tag, (StatusEvent.Listener)new StatusOutputListener(io));
            }
            catch (DockerAuthenticationException ex) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)Bundle.MSG_EditCredentials(), 0);
                        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)desc) != NotifyDescriptor.YES_OPTION) {
                            return;
                        }
                        DockerName name = DockerName.parse((String)tag.getTag());
                        Credentials c = CredentialsUtils.askForCredentials(name.getRegistry());
                        if (c != null) {
                            RequestProcessor.getDefault().post((Runnable)this);
                        }
                    }
                });
            }
            catch (DockerException ex) {
                LOGGER.log(Level.INFO, null, ex);
                io.getErr().println(ex.getMessage());
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            finally {
                io.getOut().close();
                handle.finish();
            }
        }
    }
}

