/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cordova.Bundle;
import org.netbeans.modules.cordova.CordovaPlatform;
import org.netbeans.modules.cordova.platforms.api.ClientProjectUtilities;
import org.netbeans.modules.cordova.platforms.api.PlatformManager;
import org.netbeans.modules.cordova.platforms.api.WebKitDebuggingSupport;
import org.netbeans.modules.cordova.platforms.spi.BuildPerformer;
import org.netbeans.modules.cordova.platforms.spi.Device;
import org.netbeans.modules.cordova.platforms.spi.MobilePlatform;
import org.netbeans.modules.cordova.platforms.spi.SDK;
import org.netbeans.modules.cordova.project.ConfigUtils;
import org.netbeans.modules.cordova.project.CordovaBrowserFactory;
import org.netbeans.modules.cordova.project.CordovaCustomizerPanel;
import org.netbeans.modules.cordova.project.MobileConfigurationImpl;
import org.netbeans.modules.cordova.updatetask.SourceConfig;
import org.netbeans.modules.cordova.wizard.CordovaProjectExtender;
import org.netbeans.modules.web.browser.api.BrowserFamilyId;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.modules.web.browser.spi.BrowserURLMapperImplementation;
import org.netbeans.modules.web.browser.spi.ProjectBrowserProvider;
import org.netbeans.modules.web.common.api.ServerURLMapping;
import org.netbeans.spi.project.ui.CustomizerProvider2;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.lookup.Lookups;

public class CordovaPerformer
implements BuildPerformer {
    public static final String NAME_BUILD_XML = "build.xml";
    public static final String NAME_PLUGINS_PROPERTIES = "plugins.properties";
    public static final String NAME_CONFIG_XML = "config.xml";
    public static final String PATH_BUILD_XML = "nbproject/build.xml";
    public static final String PATH_PLUGINS_PROPERTIES = "nbproject/plugins.properties";
    public static final String PATH_EXTRA_ANT_JAR = "ant/extra/org-netbeans-modules-cordova-projectupdate.jar";
    public static final String DEFAULT_ID_PREFIX = "com.coolappz";
    public static final String DEFAULT_EMAIL = "info@com.coolappz";
    public static final String DEFAULT_WWW = "http://www.coolappz.com";
    public static final String DEFAULT_VERSION = "1.0.0";
    public static final String DEFAULT_DESCRIPTION = Bundle.DSC_Cordova();
    public static final String PROP_BUILD_SCRIPT_VERSION = "cordova_build_script_version";
    public static final String PROP_PROVISIONING_PROFILE = "ios.provisioning.profile";
    public static final String PROP_CERTIFICATE_NAME = "ios.certificate.name";
    public static final String WWW_NB_TEMP = "www_nb_temp";
    public static final String WWW = "www";
    static final String GRUNT_CUSTOMIZER_IDENT = "Grunt";
    static final String GULP_CUSTOMIZER_IDENT = "Gulp";
    private final RequestProcessor RP = new RequestProcessor(CordovaPerformer.class.getName(), 10);
    private final int BUILD_SCRIPT_VERSION = 52;

    public static CordovaPerformer getDefault() {
        return (CordovaPerformer)Lookup.getDefault().lookup(CordovaPerformer.class);
    }

    public Task createPlatforms(Project project) {
        return this.perform("upgrade-to-cordova-project", project, false);
    }

    public ExecutorTask perform(String target, Project project) {
        return this.perform(target, project, true);
    }

    private ExecutorTask perform(final String target, final Project project, final boolean checkOtherScripts) {
        FileObject siteRoot;
        if ((target.startsWith("build") || target.startsWith("sim")) && ClientProjectUtilities.getStartFile((Project)project) == null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.ERR_StartFileNotFound()));
            CustomizerProvider2 cust = (CustomizerProvider2)project.getLookup().lookup(CustomizerProvider2.class);
            cust.showCustomizer("RUN", null);
            return null;
        }
        if ((target.startsWith("build") || target.startsWith("sim") || target.startsWith("rebuild")) && !CordovaPlatform.isCordovaProject(project)) {
            NotifyDescriptor desc = new NotifyDescriptor((Object)Bundle.ERR_NOT_Cordova(), NbBundle.getMessage(CordovaCustomizerPanel.class, (String)"CordovaPanel.createConfigs.text"), 2, 3, null, NotifyDescriptor.OK_OPTION);
            DialogDisplayer.getDefault().notify(desc);
            if (desc.getValue() != NotifyDescriptor.OK_OPTION) {
                return null;
            }
        }
        if ((siteRoot = ClientProjectUtilities.getSiteRoot((Project)project)) == null || FileUtil.getRelativePath((FileObject)project.getProjectDirectory(), (FileObject)siteRoot) == null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.ERR_SiteRootNotDefined()));
            CustomizerProvider2 cust = (CustomizerProvider2)project.getLookup().lookup(CustomizerProvider2.class);
            cust.showCustomizer("SOURCES", null);
            return null;
        }
        if (!CordovaPlatform.getDefault().isReady()) {
            throw new UnsupportedOperationException(Bundle.ERR_NO_Cordova());
        }
        ProjectBrowserProvider provider = (ProjectBrowserProvider)project.getLookup().lookup(ProjectBrowserProvider.class);
        if (provider != null && "ios_1".equals(provider.getActiveBrowser().getId()) && (target.equals("sim-ios") || target.equals("build-ios")) && PlatformManager.getPlatform((String)"ios") != null && PlatformManager.getPlatform((String)"ios").getProvisioningProfilePath() == null) {
            throw new IllegalStateException(Bundle.ERR_NO_Provisioning());
        }
        final ExecutorTask[] runTarget = new ExecutorTask[1];
        Runnable run = new Runnable(){

            @Override
            public void run() {
                block15: {
                    try {
                        ProjectBrowserProvider provider;
                        boolean rename;
                        FileObject siteRoot = ClientProjectUtilities.getSiteRoot((Project)project);
                        DataObject siteRootDOB = DataObject.find((FileObject)siteRoot);
                        boolean bl = rename = target.startsWith("build") || target.startsWith("sim") || target.startsWith("rebuild") || target.startsWith("upgrade");
                        if (rename) {
                            if (!CordovaPlatform.isCordovaProject(project)) {
                                siteRootDOB.rename(CordovaPerformer.WWW_NB_TEMP);
                            } else {
                                siteRootDOB.rename(CordovaPerformer.WWW);
                            }
                        }
                        if (checkOtherScripts && project.getProjectDirectory().getFileObject(CordovaPerformer.PATH_BUILD_XML) == null && CordovaPerformer.this.checkOtherBuildScripts(project)) {
                            return;
                        }
                        CordovaPerformer.this.generateBuildScripts(project);
                        FileObject buildFo = project.getProjectDirectory().getFileObject(CordovaPerformer.PATH_BUILD_XML);
                        Properties properties = CordovaPerformer.this.properties(project);
                        runTarget[0] = ActionUtils.runTarget((FileObject)buildFo, (String[])new String[]{target}, (Properties)properties);
                        int result = runTarget[0].result();
                        project.getProjectDirectory().refresh();
                        if (rename && !CordovaPerformer.WWW.equals(siteRootDOB.getName())) {
                            FileObject www = project.getProjectDirectory().getFileObject(CordovaPerformer.WWW);
                            if (www != null) {
                                DataObject.find((FileObject)www).delete();
                            }
                            siteRootDOB.rename(CordovaPerformer.WWW);
                        }
                        if (!target.equals("sim-ios") && (!target.equals("sim-android") || !this.isAndroidDebugSupported(project)) || result != 0 || (provider = (ProjectBrowserProvider)project.getLookup().lookup(ProjectBrowserProvider.class)) == null) break block15;
                        WebBrowser activeConfiguration = provider.getActiveBrowser();
                        MobileConfigurationImpl mobileConfig = MobileConfigurationImpl.create(project, activeConfiguration.getId());
                        Device device = mobileConfig.getDevice();
                        if (!device.isWebViewDebugSupported()) {
                            return;
                        }
                        FileObject startFile = ClientProjectUtilities.getStartFile((Project)project);
                        URL u = ServerURLMapping.toServer((Project)project, (FileObject)startFile);
                        activeConfiguration.toBrowserURL(project, startFile, u);
                        BrowserURLMapperImplementation.BrowserURLMapper mapper = ((CordovaBrowserFactory)activeConfiguration.getHtmlBrowserFactory()).getMapper();
                        if (!device.isEmulator() && target.equals("sim-ios")) {
                            DialogDescriptor dd = new DialogDescriptor((Object)Bundle.LBL_InstallThroughItunes(), Bundle.CTL_InstallAndRun());
                            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) != DialogDescriptor.OK_OPTION) {
                                return;
                            }
                        } else {
                            try {
                                Thread.sleep(target.equals("sim-ios") ? 2000L : 5000L);
                            }
                            catch (InterruptedException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                        WebKitDebuggingSupport.getDefault().startDebugging(device, project, Lookups.fixed((Object[])new Object[]{mapper, ImageUtilities.loadImage((String)("org/netbeans/modules/cordova/platforms/ios/ios" + (device.isEmulator() ? "simulator16.png" : "device16.png"))), CordovaPerformer.getConfig(project).getId()}), false);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (IllegalArgumentException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private boolean isAndroidDebugSupported(Project project2) {
                if (CordovaPlatform.getDefault().getVersion().getApiVersion().compareTo(new CordovaPlatform.Version.SubVersion("3.3.0")) < 0) return false;
                try {
                    FileObject manifestFile = project2.getProjectDirectory().getFileObject("platforms/android/AndroidManifest.xml");
                    if (manifestFile == null) {
                        return false;
                    }
                    FileObject propertiesFile = project2.getProjectDirectory().getFileObject("platforms/android/project.properties");
                    if (propertiesFile == null) {
                        return false;
                    }
                    try (InputStream s = propertiesFile.getInputStream();){
                        Properties props = new Properties();
                        props.load(s);
                        String target2 = props.getProperty("target");
                        if (target2 != null) {
                            if (target2.trim().compareTo("android-19") >= 0) return true;
                        }
                        boolean bl = false;
                        return bl;
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                return false;
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            this.RP.post(run);
        } else {
            run.run();
        }
        return runTarget[0];
    }

    private Properties properties(Project p) {
        ProjectBrowserProvider provider;
        Properties props = new Properties();
        CordovaPlatform cordovaPlatform = CordovaPlatform.getDefault();
        props.put("cordova.version", cordovaPlatform.getVersion().toString());
        FileObject siteRoot = ClientProjectUtilities.getSiteRoot((Project)p);
        if (siteRoot != null) {
            String siteRootRelative = FileUtil.getRelativePath((FileObject)p.getProjectDirectory(), (FileObject)siteRoot);
            props.put("site.root", siteRootRelative);
        } else {
            props.put("site.root", WWW_NB_TEMP);
        }
        FileObject startFile = ClientProjectUtilities.getStartFile((Project)p);
        if (startFile != null) {
            String startFileRelative = FileUtil.getRelativePath((FileObject)siteRoot, (FileObject)startFile);
            props.put("start.file", startFileRelative);
        }
        File antTaskJar = InstalledFileLocator.getDefault().locate(PATH_EXTRA_ANT_JAR, "org.netbeans.modules.cordova", true);
        props.put("update.task.jar", antTaskJar.getAbsolutePath());
        String id = CordovaPerformer.getConfig(p).getId();
        String activity = id.substring(id.lastIndexOf(".") + 1, id.length());
        props.put("android.project.activity", activity);
        MobilePlatform iosPlatform = PlatformManager.getPlatform((String)"ios");
        if (iosPlatform != null) {
            String codeSignIdentity;
            String provisioningProfilePath = iosPlatform.getProvisioningProfilePath();
            if (provisioningProfilePath != null) {
                props.put(PROP_PROVISIONING_PROFILE, provisioningProfilePath);
            }
            if ((codeSignIdentity = iosPlatform.getCodeSignIdentity()) != null) {
                props.put(PROP_CERTIFICATE_NAME, codeSignIdentity);
            }
        }
        props.put("env.DISPLAY", ":0.0");
        String sdkLocation = PlatformManager.getPlatform((String)"android").getSdkLocation();
        if (sdkLocation != null) {
            props.put("android.sdk.home", sdkLocation);
        }
        if ((provider = (ProjectBrowserProvider)p.getLookup().lookup(ProjectBrowserProvider.class)) != null && provider.getActiveBrowser().getBrowserFamily() == BrowserFamilyId.PHONEGAP) {
            WebBrowser activeConfiguration = provider.getActiveBrowser();
            MobileConfigurationImpl mobileConfig = MobileConfigurationImpl.create(p, activeConfiguration.getId());
            props.put("config", mobileConfig.getId());
            mobileConfig.getDevice().addProperties(props);
            if (mobileConfig.getId().equals("ios") && iosPlatform != null) {
                boolean sdkVerified = false;
                try {
                    for (SDK sdk : iosPlatform.getSDKs()) {
                        if (!sdk.getIdentifier().equals(mobileConfig.getProperty("ios.build.sdk"))) continue;
                        sdkVerified = true;
                        break;
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (!sdkVerified) {
                    mobileConfig.putProperty("ios.build.sdk", iosPlatform.getPrefferedTarget().getIdentifier());
                    mobileConfig.save();
                }
            }
        }
        return props;
    }

    private void generateBuildScripts(Project project) {
        try {
            CordovaProjectExtender.createMobileConfigs(project.getProjectDirectory());
            Preferences preferences = ProjectUtils.getPreferences((Project)project, CordovaPlatform.class, (boolean)true);
            int version = preferences.getInt(PROP_BUILD_SCRIPT_VERSION, 0);
            boolean fresh = version < 52 ? CordovaPerformer.createScript(project, NAME_BUILD_XML, PATH_BUILD_XML, true) : CordovaPerformer.createScript(project, NAME_BUILD_XML, PATH_BUILD_XML, false);
            if (fresh) {
                preferences.putInt(PROP_BUILD_SCRIPT_VERSION, 52);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("__PROJECT_NAME__", ProjectUtils.getInformation((Project)project).getName());
                ConfigUtils.replaceToken(project.getProjectDirectory().getFileObject(PATH_BUILD_XML), map);
                CordovaPerformer.createScript(project, "empty.properties", PATH_PLUGINS_PROPERTIES, false);
            }
            CordovaPerformer.getConfig(project);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private boolean checkOtherBuildScripts(Project project) {
        return this.hasOtherBuildTool(project, "Gruntfile.js", GRUNT_CUSTOMIZER_IDENT, () -> ((CustomizerProvider2)project.getLookup().lookup(CustomizerProvider2.class)).showCustomizer(GRUNT_CUSTOMIZER_IDENT, null)) || this.hasOtherBuildTool(project, "gulpfile.js", GULP_CUSTOMIZER_IDENT, () -> ((CustomizerProvider2)project.getLookup().lookup(CustomizerProvider2.class)).showCustomizer(GULP_CUSTOMIZER_IDENT, null));
    }

    private boolean hasOtherBuildTool(Project project, String toolfile, String toolName, Runnable r) {
        if (project.getProjectDirectory().getFileObject(toolfile) != null) {
            ProjectInformation info = ProjectUtils.getInformation((Project)project);
            String name = info != null ? info.getDisplayName() : project.getProjectDirectory().getNameExt();
            JButton tool = new JButton(toolName);
            NotifyDescriptor desc = new NotifyDescriptor((Object)Bundle.MSG_SelectBuildTool(name, toolfile, toolName), Bundle.CTL_SelectBuildTool(), 2, 3, new Object[]{tool, new JButton("Ant"), NotifyDescriptor.CANCEL_OPTION}, NotifyDescriptor.OK_OPTION);
            DialogDisplayer.getDefault().notify(desc);
            if (desc.getValue() == tool) {
                r.run();
                return true;
            }
            if (desc.getValue() == NotifyDescriptor.CANCEL_OPTION) {
                return true;
            }
        }
        return false;
    }

    private static String getConfigPath(Project project) {
        boolean configExists;
        FileObject siteRoot = ClientProjectUtilities.getSiteRoot((Project)project);
        String configPath = (siteRoot == null ? WWW_NB_TEMP : siteRoot.getNameExt()) + "/" + NAME_CONFIG_XML;
        boolean bl = configExists = project.getProjectDirectory().getFileObject(configPath) != null;
        if (CordovaPlatform.getDefault().getVersion().getApiVersion().compareTo(new CordovaPlatform.Version.SubVersion("3.4.0")) >= 0) {
            boolean newConfigPathExists;
            String newConfigPath = "/config.xml";
            boolean bl2 = newConfigPathExists = project.getProjectDirectory().getFileObject(newConfigPath) != null;
            if (newConfigPathExists) {
                return newConfigPath;
            }
            if (configExists) {
                return configPath;
            }
            return newConfigPath;
        }
        return configPath;
    }

    public static SourceConfig getConfig(Project project) {
        try {
            String configPath = CordovaPerformer.getConfigPath(project);
            boolean fresh = CordovaPerformer.createScript(project, NAME_CONFIG_XML, configPath, false);
            FileObject config = project.getProjectDirectory().getFileObject(configPath);
            SourceConfig conf = new SourceConfig(FileUtil.toFile((FileObject)config));
            if (fresh) {
                String appName = ProjectUtils.getInformation((Project)project).getDisplayName().replaceAll(" ", "_").replaceAll("-", "_").replaceAll("\\.", "_");
                conf.setId("com.coolappz." + appName);
                conf.setName(appName);
                conf.setDescription(DEFAULT_DESCRIPTION);
                conf.setAuthor(System.getProperty("user.name"));
                conf.setAuthorEmail(DEFAULT_EMAIL);
                conf.setAuthorHref(DEFAULT_WWW);
                conf.setVersion(DEFAULT_VERSION);
                conf.save();
            }
            return conf;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createScript(Project project, String source, String target, boolean overwrite) throws IOException {
        FileObject build = null;
        if (!overwrite) {
            build = project.getProjectDirectory().getFileObject(target);
        }
        if (build == null) {
            build = FileUtil.createData((FileObject)project.getProjectDirectory(), (String)target);
            InputStream resourceAsStream = CordovaPerformer.class.getResourceAsStream(source);
            OutputStream outputStream = build.getOutputStream();
            try {
                FileUtil.copy((InputStream)resourceAsStream, (OutputStream)outputStream);
            }
            finally {
                outputStream.close();
                resourceAsStream.close();
            }
            return true;
        }
        return false;
    }

    private class CompoundTask
    extends Task {
        private final Task task1;
        private final Task task2;

        public CompoundTask(Task task1, Task task2) {
            this.task1 = task1;
            this.task2 = task2;
        }

        public void waitFinished() {
            if (this.task1 != null) {
                this.task1.waitFinished();
            }
            if (this.task2 != null) {
                this.task2.waitFinished();
            }
        }
    }
}

