/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.twig.editor.lexer;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.php.twig.editor.lexer.TwigBlockTokenId;
import org.netbeans.modules.php.twig.editor.lexer.TwigTopLexer;
import org.netbeans.modules.php.twig.editor.lexer.TwigVariableTokenId;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;

public enum TwigTopTokenId implements TokenId
{
    T_TWIG_OTHER("twig_error"),
    T_TWIG_COMMENT("twig_comment"),
    T_TWIG_BLOCK_START("twig_block_delimiter"),
    T_TWIG_BLOCK("twig_block"),
    T_TWIG_BLOCK_END("twig_block_delimiter"),
    T_TWIG_VAR_START("twig_var_delimiter"),
    T_TWIG_VAR("twig_var"),
    T_TWIG_VAR_END("twig_var_delimiter"),
    T_HTML("twig_html");

    private final String primaryCategory;
    private static final Language<TwigTopTokenId> LANGUAGE;

    private TwigTopTokenId(String primaryCategory) {
        this.primaryCategory = primaryCategory;
    }

    public String primaryCategory() {
        return this.primaryCategory;
    }

    public static Language<TwigTopTokenId> language() {
        return LANGUAGE;
    }

    static {
        LANGUAGE = new LanguageHierarchy<TwigTopTokenId>(){

            protected Collection<TwigTopTokenId> createTokenIds() {
                return EnumSet.allOf(TwigTopTokenId.class);
            }

            protected Map<String, Collection<TwigTopTokenId>> createTokenCategories() {
                HashMap<String, Collection<TwigTopTokenId>> cats = new HashMap<String, Collection<TwigTopTokenId>>();
                return cats;
            }

            protected Lexer<TwigTopTokenId> createLexer(LexerRestartInfo<TwigTopTokenId> info) {
                return new TwigTopLexer(info);
            }

            protected String mimeType() {
                return "text/x-twig";
            }

            protected LanguageEmbedding<?> embedding(Token<TwigTopTokenId> token, LanguagePath languagePath, InputAttributes inputAttributes) {
                TwigTopTokenId id = (TwigTopTokenId)token.id();
                if (id == T_HTML) {
                    return LanguageEmbedding.create((Language)HTMLTokenId.language(), (int)0, (int)0, (boolean)true);
                }
                if (id == T_TWIG_BLOCK) {
                    return LanguageEmbedding.create(TwigBlockTokenId.language(), (int)0, (int)0);
                }
                if (id == T_TWIG_VAR) {
                    return LanguageEmbedding.create(TwigVariableTokenId.language(), (int)0, (int)0);
                }
                return null;
            }
        }.language();
    }
}

