/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.impl.common.annotation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.modules.j2ee.dd.api.common.EnvEntry;
import org.netbeans.modules.j2ee.dd.api.common.MessageDestinationRef;
import org.netbeans.modules.j2ee.dd.api.common.PortComponentRef;
import org.netbeans.modules.j2ee.dd.api.common.ResourceEnvRef;
import org.netbeans.modules.j2ee.dd.api.common.ResourceRef;
import org.netbeans.modules.j2ee.dd.api.common.SecurityRole;
import org.netbeans.modules.j2ee.dd.api.common.ServiceRef;
import org.netbeans.modules.j2ee.dd.impl.common.annotation.EnvEntryImpl;
import org.netbeans.modules.j2ee.dd.impl.common.annotation.MessageDestinationRefImpl;
import org.netbeans.modules.j2ee.dd.impl.common.annotation.ResourceEnvRefImpl;
import org.netbeans.modules.j2ee.dd.impl.common.annotation.ResourceImpl;
import org.netbeans.modules.j2ee.dd.impl.common.annotation.ResourceRefImpl;
import org.netbeans.modules.j2ee.dd.impl.common.annotation.SecurityRoleImpl;
import org.netbeans.modules.j2ee.dd.impl.common.annotation.ServiceRefImpl;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationHandler;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationScanner;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.AnnotationParser;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ArrayValueHandler;

public class CommonAnnotationHelper {
    private static final Set<String> RESOURCE_REF_TYPES = new HashSet<String>(Arrays.asList("javax.sql.DataSource", "javax.jms.ConnectionFactory", "javax.jms.QueueConnectionFactory", "javax.jms.TopicConnectionFactory", "javax.mail.Session", "java.net.URL", "javax.resource.cci.ConnectionFactory", "org.omg.CORBA_2_3.ORB"));
    private static final Set<String> ENV_ENTRY_TYPES = new HashSet<String>(Arrays.asList("java.lang.String", "java.lang.Character", "java.lang.Integer", "java.lang.Boolean", "java.lang.Double", "java.lang.Byte", "java.lang.Short", "java.lang.Long", "java.lang.Float"));
    private static final Set<String> SERVICE_REF_TYPES = new HashSet<String>(Arrays.asList("javax.xml.rpc.Service", "javax.xml.ws.Service", "javax.jws.WebService"));
    private static final Set<String> MESSAGE_DESTINATION_TYPES = new HashSet<String>(Arrays.asList("javax.jms.Queue", "javax.jms.Topic"));

    private CommonAnnotationHelper() {
    }

    public static SecurityRole[] getSecurityRoles(AnnotationModelHelper helper) {
        final ArrayList result = new ArrayList();
        final AnnotationParser parser = AnnotationParser.create((AnnotationModelHelper)helper);
        parser.expectStringArray("value", new ArrayValueHandler(){

            public Object handleArray(List<AnnotationValue> arrayMembers) {
                for (AnnotationValue arrayMember : arrayMembers) {
                    String value = (String)arrayMember.getValue();
                    result.add(new SecurityRoleImpl(value));
                }
                return null;
            }
        }, null);
        try {
            helper.getAnnotationScanner().findAnnotations("javax.annotation.security.DeclareRoles", AnnotationScanner.TYPE_KINDS, new AnnotationHandler(){

                public void handleAnnotation(TypeElement type, Element element, AnnotationMirror annotation) {
                    parser.parse(annotation);
                }
            });
        }
        catch (InterruptedException e) {
            return new SecurityRole[0];
        }
        return result.toArray(new SecurityRole[result.size()]);
    }

    public static ResourceRef[] getResourceRefs(AnnotationModelHelper helper, TypeElement typeElement) {
        assert (helper != null);
        assert (typeElement != null);
        List<ResourceImpl> resources = CommonAnnotationHelper.getResources(helper, typeElement);
        return CommonAnnotationHelper.getResourceRefs(resources);
    }

    public static ResourceRef[] getResourceRefs(AnnotationModelHelper helper) {
        assert (helper != null);
        List<ResourceImpl> resources = CommonAnnotationHelper.getResources(helper);
        return CommonAnnotationHelper.getResourceRefs(resources);
    }

    public static ResourceEnvRef[] getResourceEnvRefs(AnnotationModelHelper helper, TypeElement typeElement) {
        assert (helper != null);
        assert (typeElement != null);
        List<ResourceImpl> resources = CommonAnnotationHelper.getResources(helper, typeElement);
        return CommonAnnotationHelper.getResourceEnvRefs(resources);
    }

    public static ResourceEnvRef[] getResourceEnvRefs(AnnotationModelHelper helper) {
        assert (helper != null);
        List<ResourceImpl> resources = CommonAnnotationHelper.getResources(helper);
        return CommonAnnotationHelper.getResourceEnvRefs(resources);
    }

    public static EnvEntry[] getEnvEntries(AnnotationModelHelper helper, TypeElement typeElement) {
        assert (helper != null);
        assert (typeElement != null);
        List<ResourceImpl> resources = CommonAnnotationHelper.getResources(helper, typeElement);
        return CommonAnnotationHelper.getEnvEntries(resources);
    }

    public static EnvEntry[] getEnvEntries(AnnotationModelHelper helper) {
        assert (helper != null);
        List<ResourceImpl> resources = CommonAnnotationHelper.getResources(helper);
        return CommonAnnotationHelper.getEnvEntries(resources);
    }

    public static MessageDestinationRef[] getMessageDestinationRefs(AnnotationModelHelper helper, TypeElement typeElement) {
        assert (helper != null);
        assert (typeElement != null);
        List<ResourceImpl> resources = CommonAnnotationHelper.getResources(helper, typeElement);
        return CommonAnnotationHelper.getMessageDestinationRefs(resources);
    }

    public static MessageDestinationRef[] getMessageDestinationRefs(AnnotationModelHelper helper) {
        assert (helper != null);
        List<ResourceImpl> resources = CommonAnnotationHelper.getResources(helper);
        return CommonAnnotationHelper.getMessageDestinationRefs(resources);
    }

    public static ServiceRef[] getServiceRefs(AnnotationModelHelper helper, TypeElement typeElement) {
        assert (helper != null);
        assert (typeElement != null);
        List<ServiceRef> serviceRefs = CommonAnnotationHelper.getWebServiceRefs(helper, typeElement);
        List<ResourceImpl> resources = CommonAnnotationHelper.getResources(helper, typeElement);
        serviceRefs.addAll(CommonAnnotationHelper.getServiceRefs(resources));
        return serviceRefs.toArray(new ServiceRef[serviceRefs.size()]);
    }

    public static ServiceRef[] getServiceRefs(AnnotationModelHelper helper) {
        assert (helper != null);
        List<ServiceRef> serviceRefs = CommonAnnotationHelper.getWebServiceRefs(helper);
        List<ResourceImpl> resources = CommonAnnotationHelper.getResources(helper);
        serviceRefs.addAll(CommonAnnotationHelper.getServiceRefs(resources));
        return serviceRefs.toArray(new ServiceRef[serviceRefs.size()]);
    }

    public static String getServiceEndpoint(AnnotationModelHelper helper, TypeElement typeElement) {
        assert (helper != null);
        if (typeElement == null) {
            return null;
        }
        Map ans = helper.getAnnotationsByType(typeElement.getAnnotationMirrors());
        AnnotationMirror wsMirror = (AnnotationMirror)ans.get("javax.jws.WebService");
        if (wsMirror != null) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : wsMirror.getElementValues().entrySet()) {
                ExecutableElement key = entry.getKey();
                if (!key.getSimpleName().contentEquals("endpointInterface")) continue;
                AnnotationValue value = entry.getValue();
                return value.toString();
            }
            return ElementUtilities.getBinaryName((TypeElement)typeElement);
        }
        return null;
    }

    private static List<ResourceImpl> getResources(AnnotationModelHelper helper, TypeElement typeElement) {
        ResourceImpl resource;
        ArrayList<ResourceImpl> result = new ArrayList<ResourceImpl>();
        for (VariableElement field : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
            if (!helper.hasAnnotation(field.getAnnotationMirrors(), "javax.annotation.Resource")) continue;
            resource = new ResourceImpl(field, typeElement, helper);
            result.add(resource);
        }
        for (ExecutableElement method : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
            if (!helper.hasAnnotation(method.getAnnotationMirrors(), "javax.annotation.Resource")) continue;
            resource = new ResourceImpl(method, typeElement, helper);
            result.add(resource);
        }
        return result;
    }

    private static List<ResourceImpl> getResources(final AnnotationModelHelper helper) {
        final ArrayList<ResourceImpl> result = new ArrayList<ResourceImpl>();
        try {
            helper.getAnnotationScanner().findAnnotations("javax.annotation.Resource", EnumSet.of(ElementKind.CLASS, ElementKind.METHOD, ElementKind.FIELD), new AnnotationHandler(){

                public void handleAnnotation(TypeElement typeElement, Element element, AnnotationMirror annotation) {
                    ResourceImpl resource = new ResourceImpl(element, typeElement, helper);
                    result.add(resource);
                }
            });
        }
        catch (InterruptedException e) {
            return Collections.emptyList();
        }
        return result;
    }

    private static List<ServiceRef> getWebServiceRefs(AnnotationModelHelper helper, TypeElement typeElement) {
        ArrayList<ServiceRef> result = new ArrayList<ServiceRef>();
        for (VariableElement field : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
            if (!helper.hasAnnotation(field.getAnnotationMirrors(), "javax.xml.ws.WebServiceRef")) continue;
            CommonAnnotationHelper.addServiceReference(result, field, typeElement, helper);
        }
        return result;
    }

    private static List<ServiceRef> getWebServiceRefs(final AnnotationModelHelper helper) {
        final ArrayList<ServiceRef> result = new ArrayList<ServiceRef>();
        try {
            helper.getAnnotationScanner().findAnnotations("javax.xml.ws.WebServiceRef", EnumSet.of(ElementKind.FIELD), new AnnotationHandler(){

                public void handleAnnotation(TypeElement typeElement, Element element, AnnotationMirror annotation) {
                    CommonAnnotationHelper.addServiceReference(result, element, typeElement, helper);
                }
            });
        }
        catch (InterruptedException e) {
            return Collections.emptyList();
        }
        return result;
    }

    private static ResourceRef[] getResourceRefs(List<ResourceImpl> resources) {
        ArrayList<ResourceRefImpl> elements = new ArrayList<ResourceRefImpl>(resources.size());
        for (ResourceImpl resource : resources) {
            if (!RESOURCE_REF_TYPES.contains(resource.getType())) continue;
            elements.add(new ResourceRefImpl(resource));
        }
        return elements.toArray(new ResourceRef[elements.size()]);
    }

    private static EnvEntry[] getEnvEntries(List<ResourceImpl> resources) {
        ArrayList<EnvEntryImpl> elements = new ArrayList<EnvEntryImpl>(resources.size());
        for (ResourceImpl resource : resources) {
            if (!ENV_ENTRY_TYPES.contains(resource.getType())) continue;
            elements.add(new EnvEntryImpl(resource));
        }
        return elements.toArray(new EnvEntry[elements.size()]);
    }

    private static MessageDestinationRef[] getMessageDestinationRefs(List<ResourceImpl> resources) {
        ArrayList<MessageDestinationRefImpl> elements = new ArrayList<MessageDestinationRefImpl>(resources.size());
        for (ResourceImpl resource : resources) {
            if (!MESSAGE_DESTINATION_TYPES.contains(resource.getType())) continue;
            elements.add(new MessageDestinationRefImpl(resource));
        }
        return elements.toArray(new MessageDestinationRef[elements.size()]);
    }

    private static List<ServiceRef> getServiceRefs(List<ResourceImpl> resources) {
        ArrayList<ServiceRef> elements = new ArrayList<ServiceRef>(resources.size());
        for (ResourceImpl resource : resources) {
            if (!SERVICE_REF_TYPES.contains(resource.getType())) continue;
            elements.add(new ServiceRefImpl(resource));
        }
        return elements;
    }

    private static ResourceEnvRef[] getResourceEnvRefs(List<ResourceImpl> resources) {
        ArrayList<ResourceEnvRefImpl> elements = new ArrayList<ResourceEnvRefImpl>(resources.size());
        for (ResourceImpl resource : resources) {
            if (RESOURCE_REF_TYPES.contains(resource.getType()) || ENV_ENTRY_TYPES.contains(resource.getType()) || MESSAGE_DESTINATION_TYPES.contains(resource.getType()) || SERVICE_REF_TYPES.contains(resource.getType())) continue;
            elements.add(new ResourceEnvRefImpl(resource));
        }
        return elements.toArray(new ResourceEnvRef[elements.size()]);
    }

    private static void addServiceReference(List<ServiceRef> serviceRefs, Element element, TypeElement parentElement, AnnotationModelHelper helper) {
        DeclaredType fieldDeclaredType;
        Element fieldTypeElement;
        TypeMirror fieldTypeMirror = element.asType();
        if (fieldTypeMirror.getKind() == TypeKind.DECLARED && (ElementKind.INTERFACE == (fieldTypeElement = (fieldDeclaredType = (DeclaredType)fieldTypeMirror).asElement()).getKind() || ElementKind.CLASS == fieldTypeElement.getKind())) {
            TypeElement typeElement = (TypeElement)fieldTypeElement;
            ServiceRefImpl newServiceRef = new ServiceRefImpl(element, typeElement, parentElement, helper);
            ServiceRef existingServiceRef = null;
            for (ServiceRef sr : serviceRefs) {
                if (!newServiceRef.getServiceRefName().equals(sr.getServiceRefName())) continue;
                existingServiceRef = sr;
            }
            if (existingServiceRef != null) {
                if (newServiceRef.sizePortComponentRef() > 0) {
                    PortComponentRef newPortComp = newServiceRef.getPortComponentRef(0);
                    PortComponentRef[] portComps = existingServiceRef.getPortComponentRef();
                    boolean foundPortComponent = false;
                    for (PortComponentRef portComp : portComps) {
                        if (!portComp.getServiceEndpointInterface().equals(newPortComp.getServiceEndpointInterface())) continue;
                        foundPortComponent = true;
                    }
                    if (!foundPortComponent) {
                        existingServiceRef.addPortComponentRef(newPortComp);
                    }
                }
            } else {
                serviceRefs.add(newServiceRef);
            }
        }
    }
}

