/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.output;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.debugger.jpda.DebuggerStartException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.gradle.api.execute.RunConfig;
import org.netbeans.modules.gradle.api.output.OutputDisplayer;
import org.netbeans.modules.gradle.api.output.OutputProcessor;
import org.netbeans.modules.gradle.api.output.OutputProcessorFactory;
import org.netbeans.modules.gradle.java.api.ProjectSourcesClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOColors;

public class JDPAProcessorFactory
implements OutputProcessorFactory {
    private static final RequestProcessor RP = new RequestProcessor("GradleDebug", 1);

    public Set<? extends OutputProcessor> createOutputProcessors(RunConfig cfg) {
        return Collections.singleton(new JDPAOutputProcessor(cfg));
    }

    private static class JDPAOutputProcessor
    implements OutputProcessor {
        private static final Pattern JDPA_LISTEN = Pattern.compile("Listening for transport dt_socket at address: (\\d+)");
        final RunConfig cfg;
        boolean activated;

        public JDPAOutputProcessor(RunConfig cfg) {
            this.cfg = cfg;
        }

        public boolean processLine(OutputDisplayer out, String line) {
            Matcher m = JDPA_LISTEN.matcher(line);
            if (m.matches()) {
                String portStr = m.group(1);
                int port = 5005;
                try {
                    port = Integer.parseInt(portStr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                final int finalPort = port;
                if (!this.activated) {
                    this.activated = true;
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                            HashMap<String, Object> services = new HashMap<String, Object>();
                            services.put("name", cfg.getTaskDisplayName());
                            services.put("baseDir", FileUtil.toFile((FileObject)cfg.getProject().getProjectDirectory()));
                            services.put("jdksources", this.getJdkSources());
                            services.put("sourcepath", this.getSources());
                            try {
                                JPDADebugger.attach((String)"localhost", (int)finalPort, (Object[])new Object[]{services});
                            }
                            catch (DebuggerStartException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    });
                }
                out.print(line, null, IOColors.OutputType.LOG_DEBUG);
                return true;
            }
            return false;
        }

        private ClassPath getJdkSources() {
            JavaPlatform jdk = JavaPlatformManager.getDefault().getDefaultPlatform();
            if (jdk != null) {
                return jdk.getSourceFolders();
            }
            return null;
        }

        private ClassPath getSources() {
            ProjectSourcesClassPathProvider pgcpp = (ProjectSourcesClassPathProvider)this.cfg.getProject().getLookup().lookup(ProjectSourcesClassPathProvider.class);
            ArrayList sourceQueryImpls = new ArrayList(2);
            sourceQueryImpls.addAll(this.cfg.getProject().getLookup().lookupAll(SourceForBinaryQueryImplementation2.class));
            sourceQueryImpls.addAll(Lookup.getDefault().lookupAll(SourceForBinaryQueryImplementation2.class));
            LinkedHashSet<FileObject> srcs = new LinkedHashSet<FileObject>();
            for (ClassPath projectSourcePath : pgcpp.getProjectClassPath("classpath/source")) {
                srcs.addAll(Arrays.asList(projectSourcePath.getRoots()));
            }
            for (ClassPath cp : pgcpp.getProjectClassPath("classpath/execute")) {
                block2: for (ClassPath.Entry entry : cp.entries()) {
                    URL url = entry.getURL();
                    for (SourceForBinaryQueryImplementation2 sourceQuery : sourceQueryImpls) {
                        List<FileObject> roots;
                        SourceForBinaryQueryImplementation2.Result ret = sourceQuery.findSourceRoots2(url);
                        if (ret == null || (roots = Arrays.asList(ret.getRoots())).isEmpty()) continue;
                        srcs.addAll(roots);
                        continue block2;
                    }
                }
            }
            FileObject[] roots = srcs.toArray(new FileObject[srcs.size()]);
            return ClassPathSupport.createClassPath((FileObject[])roots);
        }
    }
}

