/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.actions;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.netbeans.modules.gradle.actions.DefaultActionMapping;
import org.netbeans.modules.gradle.api.execute.ActionMapping;

public final class ActionMappingPropertyReader {
    final Properties props;

    ActionMappingPropertyReader(Properties props) {
        this.props = props;
    }

    public static Set<ActionMapping> loadMappings(Properties props) {
        ActionMappingPropertyReader reader = new ActionMappingPropertyReader(props);
        return Collections.unmodifiableSet(reader.buildMappings());
    }

    private Set<ActionMapping> buildMappings() {
        HashSet<ActionMapping> mappings = new HashSet<ActionMapping>();
        for (String actionName : this.getActionNames()) {
            mappings.add(this.createMapping(actionName));
        }
        return mappings;
    }

    private Set<String> getActionNames() {
        HashSet<String> ret = new HashSet<String>();
        for (String key : this.props.stringPropertyNames()) {
            int dot;
            if (!key.startsWith("action.") || (dot = key.indexOf(46, "action.".length() + 1)) <= 0) continue;
            String name = key.substring("action.".length(), dot);
            ret.add(name);
        }
        return ret;
    }

    private ActionMapping createMapping(String name) {
        DefaultActionMapping ret = new DefaultActionMapping(name);
        String prefix = "action." + name + '.';
        ret.displayName = this.props.getProperty("action." + name);
        ret.args = this.props.getProperty(prefix + "args");
        ret.reloadArgs = this.props.getProperty(prefix + "reload.args");
        String rule = this.props.getProperty(prefix + "reload.rule", ActionMapping.ReloadRule.DEFAULT.name());
        try {
            ret.reloadRule = ActionMapping.ReloadRule.valueOf(rule.trim());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        String repeatable = this.props.getProperty(prefix + "repeatable");
        if (repeatable != null) {
            ret.repeatableAction = Boolean.valueOf(repeatable);
        }
        if (this.props.containsKey(prefix + "plugins")) {
            String[] plugins = this.props.getProperty(prefix + "plugins").split(",\\s");
            ret.withPlugins = new LinkedHashSet<String>();
            ret.withPlugins.addAll(Arrays.asList(plugins));
        }
        if (this.props.containsKey(prefix + "priority")) {
            try {
                ret.priority = Integer.parseInt(this.props.getProperty(prefix + "priority"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ret;
    }
}

