/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.action;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.core.api.support.java.method.MethodModel;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.ejbcore.action.AbstractMethodGenerator;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.openide.filesystems.FileObject;

public final class BusinessMethodGenerator
extends AbstractMethodGenerator {
    private BusinessMethodGenerator(String ejbClass, FileObject ejbClassFileObject) {
        super(ejbClass, ejbClassFileObject);
    }

    public static BusinessMethodGenerator create(String ejbClass, FileObject ejbClassFileObject) {
        return new BusinessMethodGenerator(ejbClass, ejbClassFileObject);
    }

    public void generate(final MethodModel methodModel, boolean generateLocal, boolean generateRemote) throws IOException {
        Map<String, String> interfaces = this.getInterfaces();
        String local = interfaces.get("Local");
        String remote = interfaces.get("Remote");
        if (generateLocal && local != null) {
            MethodModel methodModelCopy = MethodModel.create((String)methodModel.getName(), (String)methodModel.getReturnType(), null, (List)methodModel.getParameters(), (List)methodModel.getExceptions(), (Set)methodModel.getModifiers());
            this.addMethodToInterface(methodModelCopy, local);
        }
        if (generateRemote && remote != null) {
            final ArrayList exceptions = new ArrayList(methodModel.getExceptions());
            MetadataModel metadataModel = EjbJar.getEjbJar((FileObject)this.ejbClassFileObject).getMetadataModel();
            BigDecimal version = (BigDecimal)metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, BigDecimal>(){

                public BigDecimal run(EjbJarMetadata metadata) throws Exception {
                    return metadata.getRoot().getVersion();
                }
            });
            final boolean isEjb2x = version != null && version.doubleValue() <= 2.1;
            JavaSource javaSource = JavaSource.forFileObject((FileObject)this.ejbClassFileObject);
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    if (isEjb2x) {
                        exceptions.add("java.rmi.RemoteException");
                    } else {
                        TypeElement typeElement = controller.getElements().getTypeElement(BusinessMethodGenerator.this.ejbClass);
                        TypeMirror remoteType = controller.getElements().getTypeElement("java.rmi.Remote").asType();
                        if (typeElement != null) {
                            for (TypeMirror typeMirror : typeElement.getInterfaces()) {
                                if (!controller.getTypes().isSameType(remoteType, typeMirror) || methodModel.getExceptions().contains("java.rmi.RemoteException")) continue;
                                exceptions.add("java.rmi.RemoteException");
                            }
                        }
                    }
                }
            }, true);
            MethodModel methodModelCopy = MethodModel.create((String)methodModel.getName(), (String)methodModel.getReturnType(), null, (List)methodModel.getParameters(), exceptions, (Set)methodModel.getModifiers());
            this.addMethodToInterface(methodModelCopy, remote);
        }
        ArrayList<MethodModel.Annotation> annotations = new ArrayList<MethodModel.Annotation>();
        if (!methodModel.getAnnotations().isEmpty()) {
            annotations.addAll(methodModel.getAnnotations());
        }
        if (generateLocal && local != null || generateRemote && remote != null) {
            annotations.add(MethodModel.Annotation.create((String)"java.lang.Override"));
        }
        MethodModel methodModelCopy = MethodModel.create((String)methodModel.getName(), (String)methodModel.getReturnType(), (String)methodModel.getBody(), (List)methodModel.getParameters(), (List)methodModel.getExceptions(), Collections.singleton(Modifier.PUBLIC), annotations);
        BusinessMethodGenerator.addMethod(methodModelCopy, this.ejbClassFileObject, this.ejbClass);
    }
}

