/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.prep.editor;

import javax.swing.ImageIcon;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.css.prep.editor.CPCompletionItem;
import org.netbeans.modules.css.prep.editor.model.CPElementHandle;
import org.netbeans.modules.css.prep.editor.model.CPElementType;
import org.openide.util.ImageUtilities;

public class VariableCompletionItem
extends CPCompletionItem {
    private static final ImageIcon LOCAL_VAR_ICON = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/css/prep/editor/resources/localVariable.gif"));

    public VariableCompletionItem(@NonNull ElementHandle elementHandle, @NonNull CPElementHandle handle, int anchorOffset, @NullAllowed String origin) {
        super(elementHandle, handle, anchorOffset, origin);
    }

    public ElementKind getKind() {
        return ElementKind.VARIABLE;
    }

    public ImageIcon getIcon() {
        switch (this.handle.getType()) {
            case VARIABLE_LOCAL_DECLARATION: 
            case VARIABLE_DECLARATION_IN_BLOCK_CONTROL: {
                return LOCAL_VAR_ICON;
            }
        }
        return super.getIcon();
    }

    public String getInsertPrefix() {
        return this.handle.getName();
    }

    public String getName() {
        return this.handle.getName().substring(1);
    }

    private boolean isGlobalVar() {
        return this.handle.getType() == CPElementType.VARIABLE_GLOBAL_DECLARATION;
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + (this.origin != null ? this.origin.hashCode() : 0);
        hash = 89 * hash + this.getName().hashCode();
        hash = 89 * hash + (this.isGlobalVar() ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        VariableCompletionItem other = (VariableCompletionItem)((Object)obj);
        if (this.origin == null ? other.origin != null : !this.origin.equals(other.origin)) {
            return false;
        }
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        return this.isGlobalVar() == other.isGlobalVar();
    }

    public int getSortPrioOverride() {
        int prio = 50;
        if (this.origin == null) {
            prio -= 40;
        }
        switch (this.handle.getType()) {
            case VARIABLE_GLOBAL_DECLARATION: {
                prio -= 5;
                break;
            }
            case VARIABLE_LOCAL_DECLARATION: 
            case VARIABLE_DECLARATION_IN_BLOCK_CONTROL: {
                prio -= 10;
                break;
            }
        }
        return prio;
    }
}

