/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.viewmodel;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;
import org.netbeans.modules.viewmodel.TreeModelNode;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.netbeans.swing.outline.Outline;
import org.netbeans.swing.outline.OutlineModel;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;

class DelegatingCellRenderer
implements TableCellRenderer {
    private String columnID;
    private TableCellRenderer defaultRenderer;

    public DelegatingCellRenderer(String columnID, TableCellRenderer defaultRenderer) {
        this.columnID = columnID;
        this.defaultRenderer = defaultRenderer;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Outline outline = (Outline)table;
        Node n = DelegatingCellRenderer.getNodeAt(outline, row);
        if (n instanceof TreeModelNode) {
            TreeModelNode tmn = (TreeModelNode)n;
            Models.CompoundModel trm = tmn.getModel();
            try {
                TableCellRenderer renderer;
                if (trm.canRenderCell(tmn.getObject(), this.columnID) && (renderer = trm.getCellRenderer(tmn.getObject(), this.columnID)) != null) {
                    return renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                }
            }
            catch (UnknownTypeException unknownTypeException) {
                // empty catch block
            }
        }
        return this.defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    static final Node getNodeAt(Outline outline, int rowInUI) {
        Node result = null;
        OutlineModel om = (OutlineModel)outline.getModel();
        int row = outline.convertRowIndexToModel(rowInUI);
        TreePath path = om.getLayout().getPathForRow(row);
        if (path != null) {
            result = Visualizer.findNode((Object)path.getLastPathComponent());
        }
        return result;
    }
}

