/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.action;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.persistence.action.GenerationOptions;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceMetadata;
import org.netbeans.modules.j2ee.persistence.dd.common.Persistence;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.spi.entitymanagergenerator.ApplicationManagedResourceTransactionInJ2SE;
import org.netbeans.modules.j2ee.persistence.spi.entitymanagergenerator.EntityManagerGenerationStrategy;
import org.netbeans.modules.j2ee.persistence.spi.entitymanagergenerator.EntityManagerGenerationStrategyResolver;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public final class EntityManagerGenerator {
    private final String fqn;
    private final JavaSource targetSource;
    private final FileObject targetFo;
    private final Project project;

    public EntityManagerGenerator(FileObject targetFo, String fqn) {
        this.fqn = fqn;
        this.targetFo = targetFo;
        this.targetSource = JavaSource.forFileObject((FileObject)targetFo);
        this.project = FileOwnerQuery.getOwner((FileObject)targetFo);
    }

    public FileObject generate(GenerationOptions options) throws IOException {
        Class<? extends EntityManagerGenerationStrategy> strategyClass = this.getStrategy();
        if (strategyClass == null) {
            NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)NbBundle.getMessage(EntityManagerGenerator.class, (String)"ERR_NotSupported"), 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
            return this.targetFo;
        }
        return this.generate(options, strategyClass);
    }

    public FileObject generate(final GenerationOptions options, final Class<? extends EntityManagerGenerationStrategy> strategyClass) throws IOException {
        Parameters.notNull((CharSequence)"options", (Object)options);
        Parameters.notNull((CharSequence)"strategyClass", strategyClass);
        Task<WorkingCopy> task = new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws Exception {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                CompilationUnitTree cut = workingCopy.getCompilationUnit();
                TreeMaker make = workingCopy.getTreeMaker();
                for (Tree tree : cut.getTypeDecls()) {
                    if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind())) continue;
                    ClassTree clazz = (ClassTree)tree;
                    EntityManagerGenerationStrategy strategy = EntityManagerGenerator.this.instantiateStrategy(strategyClass, workingCopy, make, clazz, options);
                    workingCopy.rewrite((Tree)clazz, (Tree)strategy.generate());
                }
            }
        };
        this.targetSource.runModificationTask((Task)task).commit();
        return this.targetFo;
    }

    private Class<? extends EntityManagerGenerationStrategy> getStrategy() {
        EntityManagerGenerationStrategyResolver resolver = (EntityManagerGenerationStrategyResolver)this.project.getLookup().lookup(EntityManagerGenerationStrategyResolver.class);
        if (resolver != null) {
            return resolver.resolveStrategy(this.targetFo);
        }
        return ApplicationManagedResourceTransactionInJ2SE.class;
    }

    private EntityManagerGenerationStrategy instantiateStrategy(Class<? extends EntityManagerGenerationStrategy> strategy, WorkingCopy workingCopy, TreeMaker make, ClassTree clazz, GenerationOptions options) {
        EntityManagerGenerationStrategy result = null;
        try {
            result = strategy.newInstance();
            result.setClassTree(clazz);
            result.setWorkingCopy(workingCopy);
            result.setGenerationOptions(options);
            result.setTreeMaker(make);
            result.setPersistenceUnit(this.getPersistenceUnit());
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException(ie);
        }
        return result;
    }

    private PersistenceUnit getPersistenceUnit() {
        PersistenceScope persistenceScope = PersistenceScope.getPersistenceScope((FileObject)this.targetFo);
        if (persistenceScope == null) {
            return null;
        }
        try {
            Persistence persistence = PersistenceMetadata.getDefault().getRoot(persistenceScope.getPersistenceXml());
            if (persistence != null) {
                PersistenceUnit ret;
                PersistenceUnit[] pus = persistence.getPersistenceUnit();
                PersistenceUnit persistenceUnit = ret = pus.length > 0 ? pus[0] : null;
                if (pus.length > 1) {
                    PersistenceUnit forAll = null;
                    PersistenceUnit forOne = null;
                    block2: for (int i = 0; i < pus.length && forOne == null; ++i) {
                        String[] classes;
                        PersistenceUnit tmp = pus[i];
                        if (forAll == null && !tmp.isExcludeUnlistedClasses()) {
                            forAll = tmp;
                        }
                        if (!tmp.isExcludeUnlistedClasses()) continue;
                        for (String clas : classes = tmp.getClass2()) {
                            if (!this.fqn.equals(clas)) continue;
                            forOne = tmp;
                            continue block2;
                        }
                    }
                    ret = forOne != null ? forOne : (forAll != null ? forAll : ret);
                }
                return ret;
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }
}

