/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.options;

import java.util.EventListener;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.modules.php.editor.options.CodeCompletionPanel;
import org.openide.util.WeakListeners;

public final class OptionsUtils {
    private static final AtomicBoolean INITED = new AtomicBoolean(false);
    private static final PreferenceChangeListener PREFERENCES_TRACKER = new PreferenceChangeListener(){

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            String settingName;
            String string = settingName = evt == null ? null : evt.getKey();
            if (settingName == null || "phpAutoCompletionFull".equals(settingName)) {
                autoCompletionFull = preferences.getBoolean("phpAutoCompletionFull", true);
            }
            if (settingName == null || "phpAutoCompletionVariables".equals(settingName)) {
                autoCompletionVariables = preferences.getBoolean("phpAutoCompletionVariables", true);
            }
            if (settingName == null || "phpAutoCompletionTypes".equals(settingName)) {
                autoCompletionTypes = preferences.getBoolean("phpAutoCompletionTypes", true);
            }
            if (settingName == null || "phpAutoCompletionNamespaces".equals(settingName)) {
                autoCompletionNamespaces = preferences.getBoolean("phpAutoCompletionNamespaces", true);
            }
            if (settingName == null || "phpCodeCompletionSmartQuotes".equals(settingName)) {
                autoCompletionSmartQuotes = preferences.getBoolean("phpCodeCompletionSmartQuotes", true);
            }
            if (settingName == null || "phpCodeCompletionStringAutoConcatination".equals(settingName)) {
                autoStringConcatination = preferences.getBoolean("phpCodeCompletionStringAutoConcatination", true);
            }
            if (settingName == null || "phpAutoCompletionUseLowercaseTrueFalseNull".equals(settingName)) {
                autoCompletionUseLowercaseTrueFalseNull = preferences.getBoolean("phpAutoCompletionUseLowercaseTrueFalseNull", true);
            }
            if (settingName == null || "phpAutoCompletionCommentAsterisk".equals(settingName)) {
                autoCompletionCommentAsterisk = preferences.getBoolean("phpAutoCompletionCommentAsterisk", true);
            }
            if (settingName == null || "phpCodeCompletionStaticMethods".equals(settingName)) {
                codeCompletionStaticMethods = preferences.getBoolean("phpCodeCompletionStaticMethods", true);
            }
            if (settingName == null || "phpCodeCompletionNonStaticMethods".equals(settingName)) {
                codeCompletionNonStaticMethods = preferences.getBoolean("phpCodeCompletionNonStaticMethods", false);
            }
            if (settingName == null || "phpCodeCompletionSmartParametersPreFilling".equals(settingName)) {
                codeCompletionSmartParametersPreFilling = preferences.getBoolean("phpCodeCompletionSmartParametersPreFilling", true);
            }
            if (settingName == null || "phpCodeCompletionVariablesScope".equals(settingName)) {
                codeCompletionVariablesScope = CodeCompletionPanel.VariablesScope.resolve(preferences.get("phpCodeCompletionVariablesScope", null));
            }
            if (settingName == null || "phpCodeCompletionType".equals(settingName)) {
                codeCompletionType = CodeCompletionPanel.CodeCompletionType.resolve(preferences.get("phpCodeCompletionType", null));
            }
        }
    };
    private static Preferences preferences;
    private static Boolean autoCompletionFull;
    private static Boolean autoCompletionVariables;
    private static Boolean autoCompletionTypes;
    private static Boolean autoCompletionNamespaces;
    private static Boolean autoCompletionSmartQuotes;
    private static Boolean autoStringConcatination;
    private static Boolean autoCompletionUseLowercaseTrueFalseNull;
    private static Boolean autoCompletionCommentAsterisk;
    private static Boolean codeCompletionStaticMethods;
    private static Boolean codeCompletionNonStaticMethods;
    private static Boolean codeCompletionSmartParametersPreFilling;
    private static CodeCompletionPanel.VariablesScope codeCompletionVariablesScope;
    private static CodeCompletionPanel.CodeCompletionType codeCompletionType;

    private OptionsUtils() {
    }

    public static boolean autoCompletionFull() {
        OptionsUtils.lazyInit();
        assert (autoCompletionFull != null);
        return autoCompletionFull;
    }

    public static boolean autoCompletionVariables() {
        OptionsUtils.lazyInit();
        assert (autoCompletionVariables != null);
        if (OptionsUtils.autoCompletionFull()) {
            return true;
        }
        return autoCompletionVariables;
    }

    public static boolean autoCompletionTypes() {
        OptionsUtils.lazyInit();
        assert (autoCompletionTypes != null);
        if (OptionsUtils.autoCompletionFull()) {
            return true;
        }
        return autoCompletionTypes;
    }

    public static boolean autoCompletionNamespaces() {
        OptionsUtils.lazyInit();
        assert (autoCompletionNamespaces != null);
        if (OptionsUtils.autoCompletionFull()) {
            return true;
        }
        return autoCompletionNamespaces;
    }

    public static boolean codeCompletionStaticMethods() {
        OptionsUtils.lazyInit();
        assert (codeCompletionStaticMethods != null);
        return codeCompletionStaticMethods;
    }

    public static boolean codeCompletionNonStaticMethods() {
        OptionsUtils.lazyInit();
        assert (codeCompletionNonStaticMethods != null);
        return codeCompletionNonStaticMethods;
    }

    public static boolean codeCompletionSmartParametersPreFilling() {
        OptionsUtils.lazyInit();
        assert (codeCompletionSmartParametersPreFilling != null);
        return codeCompletionSmartParametersPreFilling;
    }

    public static boolean autoCompletionSmartQuotes() {
        OptionsUtils.lazyInit();
        assert (autoCompletionSmartQuotes != null);
        return autoCompletionSmartQuotes;
    }

    public static boolean autoStringConcatination() {
        OptionsUtils.lazyInit();
        assert (autoStringConcatination != null);
        return autoStringConcatination;
    }

    public static boolean autoCompletionUseLowercaseTrueFalseNull() {
        OptionsUtils.lazyInit();
        assert (autoCompletionUseLowercaseTrueFalseNull != null);
        return autoCompletionUseLowercaseTrueFalseNull;
    }

    public static boolean autoCompletionCommentAsterisk() {
        OptionsUtils.lazyInit();
        assert (autoCompletionCommentAsterisk != null);
        return autoCompletionCommentAsterisk;
    }

    public static CodeCompletionPanel.VariablesScope codeCompletionVariablesScope() {
        OptionsUtils.lazyInit();
        assert (codeCompletionVariablesScope != null);
        return codeCompletionVariablesScope;
    }

    public static CodeCompletionPanel.CodeCompletionType codeCompletionType() {
        OptionsUtils.lazyInit();
        assert (codeCompletionType != null);
        return codeCompletionType;
    }

    private static void lazyInit() {
        if (INITED.compareAndSet(false, true)) {
            preferences = (Preferences)MimeLookup.getLookup((String)"text/x-php5").lookup(Preferences.class);
            preferences.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)PREFERENCES_TRACKER, (Object)preferences));
            PREFERENCES_TRACKER.preferenceChange(null);
        }
    }

    static {
        autoCompletionFull = null;
        autoCompletionVariables = null;
        autoCompletionTypes = null;
        autoCompletionNamespaces = null;
        autoCompletionSmartQuotes = null;
        autoStringConcatination = null;
        autoCompletionUseLowercaseTrueFalseNull = null;
        autoCompletionCommentAsterisk = null;
        codeCompletionStaticMethods = null;
        codeCompletionNonStaticMethods = null;
        codeCompletionSmartParametersPreFilling = null;
        codeCompletionVariablesScope = null;
        codeCompletionType = null;
    }
}

