/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.csl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.api.editor.fold.FoldTemplate;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.php.editor.csl.Bundle;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.GroupUseScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.UseScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTError;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayCreation;
import org.netbeans.modules.php.editor.parser.astnodes.CatchClause;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.DoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.EmptyStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FinallyClause;
import org.netbeans.modules.php.editor.parser.astnodes.ForEachStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ForStatement;
import org.netbeans.modules.php.editor.parser.astnodes.IfStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;
import org.netbeans.modules.php.editor.parser.astnodes.SwitchCase;
import org.netbeans.modules.php.editor.parser.astnodes.SwitchStatement;
import org.netbeans.modules.php.editor.parser.astnodes.TryStatement;
import org.netbeans.modules.php.editor.parser.astnodes.UseTraitStatement;
import org.netbeans.modules.php.editor.parser.astnodes.WhileStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;

public final class FoldingScanner {
    public static final FoldType TYPE_CODE_BLOCKS = FoldType.CODE_BLOCK;
    public static final FoldType TYPE_CLASS = FoldType.NESTED.derive("class", Bundle.FT_Classes(), FoldTemplate.DEFAULT_BLOCK);
    public static final FoldType TYPE_PHPDOC = FoldType.DOCUMENTATION.override(Bundle.FT_PHPDoc(), new FoldTemplate(3, 2, "/**...*/"));
    public static final FoldType TYPE_COMMENT = FoldType.COMMENT.override(FoldType.COMMENT.getLabel(), new FoldTemplate(2, 2, "/*...*/"));
    public static final FoldType TYPE_FUNCTION = FoldType.MEMBER.derive("function", Bundle.FT_Functions(), FoldTemplate.DEFAULT_BLOCK);
    public static final FoldType TYPE_ARRAY = FoldType.NESTED.derive("array", Bundle.FT_Arrays(), new FoldTemplate(0, 0, "[...]"));
    public static final FoldType TYPE_USE = FoldType.IMPORT.derive("use", Bundle.FT_Use(), new FoldTemplate(0, 0, "..."));
    public static final FoldType TYPE_PHPTAG = FoldType.CODE_BLOCK.derive("phptag", Bundle.FT_PHPTag(), new FoldTemplate(0, 0, "..."));
    private static final String LAST_CORRECT_FOLDING_PROPERTY = "LAST_CORRECT_FOLDING_PROPERY";

    public static FoldingScanner create() {
        return new FoldingScanner();
    }

    private FoldingScanner() {
    }

    public Map<String, List<OffsetRange>> folds(ParserResult info) {
        HashMap<String, List<OffsetRange>> folds = new HashMap<String, List<OffsetRange>>();
        Program program = Utils.getRoot(info);
        if (program != null) {
            assert (info instanceof PHPParseResult);
            PHPParseResult phpParseResult = (PHPParseResult)info;
            if (program.getStatements().size() == 1 && program.getStatements().get(0) instanceof ASTError) {
                Map lastCorrect;
                Document document = phpParseResult.getSnapshot().getSource().getDocument(false);
                Map map = lastCorrect = document != null ? (Map)document.getProperty(LAST_CORRECT_FOLDING_PROPERTY) : null;
                if (lastCorrect != null) {
                    Map<String, List<OffsetRange>> modifiedFolds = FoldingScanner.filterErrorFold(lastCorrect, phpParseResult.getErrorRange());
                    FoldingScanner.setFoldingProperty(document, modifiedFolds);
                    return modifiedFolds;
                }
                return Collections.emptyMap();
            }
            this.processComments(folds, program.getComments());
            Model model = phpParseResult.getModel(Model.Type.COMMON);
            FileScope fileScope = model.getFileScope();
            this.processScopes(folds, this.getEmbededScopes(fileScope, null));
            program.accept(new FoldingVisitor(folds));
            Source source = phpParseResult.getSnapshot().getSource();
            assert (source != null) : "source was null";
            Document doc = source.getDocument(false);
            this.processPHPTags(folds, doc);
            FoldingScanner.setFoldingProperty(doc, folds);
            return folds;
        }
        return Collections.emptyMap();
    }

    private static Map<String, List<OffsetRange>> filterErrorFold(Map<String, List<OffsetRange>> lastCorrect, OffsetRange errorRange) {
        HashMap<String, List<OffsetRange>> result = new HashMap<String, List<OffsetRange>>();
        for (Map.Entry<String, List<OffsetRange>> entry : lastCorrect.entrySet()) {
            ArrayList<OffsetRange> modifiedRanges = new ArrayList<OffsetRange>();
            result.put(entry.getKey(), modifiedRanges);
            for (OffsetRange foldRange : entry.getValue()) {
                if (foldRange.overlaps(errorRange)) continue;
                modifiedRanges.add(foldRange);
            }
        }
        return result;
    }

    private static void setFoldingProperty(Document document, Map<String, List<OffsetRange>> folds) {
        if (document != null) {
            document.putProperty(LAST_CORRECT_FOLDING_PROPERTY, folds);
        }
    }

    private void processComments(Map<String, List<OffsetRange>> folds, List<Comment> comments) {
        for (Comment comment : comments) {
            OffsetRange offsetRange;
            if (comment.getCommentType() == Comment.Type.TYPE_PHPDOC) {
                offsetRange = this.createOffsetRange(comment, -3);
                if (offsetRange == null || offsetRange.getLength() <= 1) continue;
                this.getRanges(folds, TYPE_PHPDOC).add(offsetRange);
                continue;
            }
            if (comment.getCommentType() != Comment.Type.TYPE_MULTILINE || (offsetRange = this.createOffsetRange(comment)) == null || offsetRange.getLength() <= 1) continue;
            this.getRanges(folds, TYPE_COMMENT).add(offsetRange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPHPTags(Map<String, List<OffsetRange>> folds, Document document) {
        if (document instanceof BaseDocument) {
            BaseDocument doc = (BaseDocument)document;
            doc.readLock();
            try {
                TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, 0);
                if (ts == null) {
                    return;
                }
                ts.move(0);
                int startOffset = -1;
                int endOffset = -1;
                int shortTagBalance = 0;
                while (ts.moveNext()) {
                    Token token = ts.token();
                    if (token == null) continue;
                    PHPTokenId id = (PHPTokenId)token.id();
                    switch (id) {
                        case PHP_OPENTAG: {
                            startOffset = ts.offset() + token.length();
                            break;
                        }
                        case PHP_CLOSETAG: {
                            if (shortTagBalance == 0) {
                                assert (startOffset != -1);
                                endOffset = ts.offset();
                                this.getRanges(folds, TYPE_PHPTAG).add(new OffsetRange(startOffset, endOffset));
                                break;
                            }
                            --shortTagBalance;
                            break;
                        }
                        case T_OPEN_TAG_WITH_ECHO: {
                            ++shortTagBalance;
                            break;
                        }
                    }
                }
            }
            finally {
                doc.readUnlock();
            }
        }
    }

    private void processScopes(Map<String, List<OffsetRange>> folds, List<Scope> scopes) {
        this.processUseScopes(folds, scopes);
        this.processTypeAndFunctionScopes(folds, scopes);
    }

    private void processTypeAndFunctionScopes(Map<String, List<OffsetRange>> folds, List<Scope> scopes) {
        for (Scope scope : scopes) {
            OffsetRange offsetRange = scope.getBlockRange();
            if (offsetRange == null || offsetRange.getLength() <= 1) continue;
            if (scope instanceof TypeScope) {
                this.getRanges(folds, TYPE_CLASS).add(offsetRange);
                continue;
            }
            if (!(scope instanceof FunctionScope) && !(scope instanceof MethodScope)) continue;
            this.getRanges(folds, TYPE_FUNCTION).add(offsetRange);
        }
    }

    private void processUseScopes(Map<String, List<OffsetRange>> folds, List<Scope> scopes) {
        ArrayList<Scope> allScopes = new ArrayList<Scope>(scopes);
        allScopes.sort((o1, o2) -> Integer.compare(o1.getOffset(), o2.getOffset()));
        int startOffset = -1;
        OffsetRange lastOffsetRange = OffsetRange.NONE;
        for (Scope scope : allScopes) {
            boolean isPartOfGroupUse = false;
            if (scope instanceof UseScope) {
                UseScope useScope = (UseScope)scope;
                isPartOfGroupUse = useScope.isPartOfGroupUse();
            }
            if (scope instanceof UseScope || scope instanceof GroupUseScope) {
                if (isPartOfGroupUse) continue;
                lastOffsetRange = scope.getNameRange();
                if (startOffset != -1) continue;
                startOffset = lastOffsetRange.getStart();
                continue;
            }
            this.addUseScope(startOffset, lastOffsetRange.getEnd() + 1, folds);
            startOffset = -1;
        }
        this.addUseScope(startOffset, lastOffsetRange.getEnd() + 1, folds);
    }

    private void addUseScope(int startOffset, int endOffset, Map<String, List<OffsetRange>> folds) {
        if (startOffset != -1) {
            this.getRanges(folds, TYPE_USE).add(new OffsetRange(startOffset, endOffset));
        }
    }

    private OffsetRange createOffsetRange(ASTNode node, int startShift) {
        return new OffsetRange(node.getStartOffset() + startShift, node.getEndOffset());
    }

    private OffsetRange createOffsetRange(ASTNode node) {
        return this.createOffsetRange(node, 0);
    }

    private List<OffsetRange> getRanges(Map<String, List<OffsetRange>> folds, FoldType kind) {
        List<OffsetRange> ranges = folds.get(kind.code());
        if (ranges == null) {
            ranges = new ArrayList<OffsetRange>();
            folds.put(kind.code(), ranges);
        }
        return ranges;
    }

    private List<Scope> getEmbededScopes(Scope scope, Set<Scope> collectedScopes) {
        if (collectedScopes == null) {
            collectedScopes = new HashSet<Scope>();
        }
        List<? extends ModelElement> elements = scope.getElements();
        for (ModelElement modelElement : elements) {
            if (!(modelElement instanceof Scope) || !collectedScopes.add((Scope)modelElement)) continue;
            this.getEmbededScopes((Scope)modelElement, collectedScopes);
        }
        return new ArrayList<Scope>(collectedScopes);
    }

    private class FoldingVisitor
    extends DefaultVisitor {
        private final Map<String, List<OffsetRange>> folds;

        public FoldingVisitor(Map<String, List<OffsetRange>> folds) {
            this.folds = folds;
        }

        @Override
        public void visit(IfStatement node) {
            super.visit(node);
            if (node.getTrueStatement() != null) {
                this.addFold(node.getTrueStatement());
            }
            if (node.getFalseStatement() != null && !(node.getFalseStatement() instanceof IfStatement)) {
                this.addFold(node.getFalseStatement());
            }
        }

        @Override
        public void visit(UseTraitStatement node) {
            super.visit(node);
            if (node.getBody() != null) {
                this.addFold(node.getBody());
            }
        }

        @Override
        public void visit(ForEachStatement node) {
            super.visit(node);
            if (node.getStatement() != null) {
                this.addFold(node.getStatement());
            }
        }

        @Override
        public void visit(ForStatement node) {
            super.visit(node);
            if (node.getBody() != null) {
                this.addFold(node.getBody());
            }
        }

        @Override
        public void visit(WhileStatement node) {
            super.visit(node);
            if (node.getBody() != null) {
                this.addFold(node.getBody());
            }
        }

        @Override
        public void visit(DoStatement node) {
            super.visit(node);
            if (node.getBody() != null) {
                this.addFold(node.getBody());
            }
        }

        @Override
        public void visit(SwitchStatement node) {
            super.visit(node);
            if (node.getBody() != null) {
                this.addFold(node.getBody());
            }
        }

        @Override
        public void visit(SwitchCase node) {
            super.visit(node);
            List<Statement> actions2 = node.getActions();
            if (!actions2.isEmpty()) {
                OffsetRange offsetRange = null;
                if (node.isDefault()) {
                    offsetRange = new OffsetRange(node.getStartOffset() + "default:".length(), actions2.get(actions2.size() - 1).getEndOffset());
                } else {
                    Expression value = node.getValue();
                    if (value != null) {
                        offsetRange = new OffsetRange(value.getEndOffset() + ":".length(), actions2.get(actions2.size() - 1).getEndOffset());
                    }
                }
                this.addFold(offsetRange);
            }
        }

        @Override
        public void visit(TryStatement node) {
            super.visit(node);
            if (node.getBody() != null) {
                this.addFold(node.getBody());
            }
        }

        @Override
        public void visit(CatchClause node) {
            super.visit(node);
            if (node.getBody() != null) {
                this.addFold(node.getBody());
            }
        }

        @Override
        public void visit(FinallyClause node) {
            super.visit(node);
            if (node.getBody() != null) {
                this.addFold(node.getBody());
            }
        }

        @Override
        public void visit(ArrayCreation node) {
            super.visit(node);
            ArrayCreation.Type type = node.getType();
            if (type == ArrayCreation.Type.NEW) {
                this.addFold(node, TYPE_ARRAY);
            } else {
                this.addFold(new OffsetRange(node.getStartOffset() + "array".length(), node.getEndOffset()), TYPE_ARRAY);
            }
        }

        private void addFold(ASTNode node) {
            if (!(node instanceof ASTError) && !(node instanceof EmptyStatement)) {
                this.addFold(FoldingScanner.this.createOffsetRange(node));
            }
        }

        private void addFold(ASTNode node, FoldType type) {
            if (!(node instanceof ASTError) && !(node instanceof EmptyStatement)) {
                this.addFold(FoldingScanner.this.createOffsetRange(node), type);
            }
        }

        private void addFold(OffsetRange offsetRange) {
            if (offsetRange != null && offsetRange.getLength() > 1) {
                FoldingScanner.this.getRanges(this.folds, TYPE_CODE_BLOCKS).add(offsetRange);
            }
        }

        private void addFold(OffsetRange offsetRange, FoldType type) {
            if (offsetRange != null && offsetRange.getLength() > 1) {
                FoldingScanner.this.getRanges(this.folds, type).add(offsetRange);
            }
        }
    }
}

