/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.sun.dd.api.ASDDVersion;
import org.netbeans.modules.j2ee.sun.dd.api.CommonDDBean;
import org.netbeans.modules.j2ee.sun.dd.api.VersionNotSupportedException;
import org.netbeans.modules.j2ee.sun.dd.api.common.MessageSecurityBinding;
import org.netbeans.modules.j2ee.sun.dd.api.common.PortInfo;
import org.netbeans.modules.j2ee.sun.dd.api.common.WsdlPort;
import org.netbeans.modules.j2ee.sun.ddloaders.SunDescriptorDataObject;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.BaseSectionNodeInnerPanel;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.DDTextFieldEditorModel;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.TextItemEditorModel;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.common.PortInfoNode;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice.EditBindingMultiview;
import org.netbeans.modules.xml.multiview.ItemEditorHelper;
import org.netbeans.modules.xml.multiview.Refreshable;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataSynchronizer;
import org.netbeans.modules.xml.multiview.ui.SectionNodeView;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class PortInfoPanel
extends BaseSectionNodeInnerPanel {
    private final ResourceBundle webserviceBundle = NbBundle.getBundle((String)"org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice.Bundle");
    private PortInfoNode portInfoNode;
    private boolean isWebApp;
    private boolean isEjbJar;
    private PortInfo portInfo;
    private boolean setup;
    private XmlMultiViewDataSynchronizer synchronizer;
    private JButton jBtnEditBindings;
    private JCheckBox jChkEnableMsgSecurity;
    private JLabel jLblEnableMsgSecurity;
    private JLabel jLblLocalpart;
    private JLabel jLblNamespaceURI;
    private JLabel jLblServiceEI;
    private JPanel jPnlPortInfoDesc;
    private JTextField jTxtLocalpart;
    private JTextField jTxtNamespaceURI;
    private JTextField jTxtServiceEI;

    public PortInfoPanel(SectionNodeView sectionNodeView, PortInfoNode portInfoNode, ASDDVersion version) {
        super(sectionNodeView, version);
        this.portInfoNode = portInfoNode;
        this.setup = true;
        this.portInfo = (PortInfo)portInfoNode.getBinding().getSunBean();
        this.initComponents();
        this.initUserComponents(sectionNodeView);
    }

    private void initUserComponents(SectionNodeView sectionNodeView) {
        SunDescriptorDataObject dataObject = (SunDescriptorDataObject)sectionNodeView.getDataObject();
        this.synchronizer = dataObject.getModelSynchronizer();
        this.isWebApp = J2eeModule.Type.WAR.equals(dataObject.getModuleType());
        this.isEjbJar = J2eeModule.Type.EJB.equals(dataObject.getModuleType());
        boolean hasMessageSecurityBinding = false;
        try {
            hasMessageSecurityBinding = this.portInfo.getMessageSecurityBinding() != null;
        }
        catch (VersionNotSupportedException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        this.jChkEnableMsgSecurity.setSelected(hasMessageSecurityBinding);
        this.enableMessageSecurityUI(hasMessageSecurityBinding);
        this.addRefreshable((Refreshable)new ItemEditorHelper((JTextComponent)this.jTxtServiceEI, (ItemEditorHelper.ItemEditorModel)new PortInfoTextFieldEditorModel(this.synchronizer, "ServiceEndpointInterface")));
        this.addRefreshable((Refreshable)new ItemEditorHelper((JTextComponent)this.jTxtLocalpart, (ItemEditorHelper.ItemEditorModel)new WsdlPortTextFieldEditorModel(this.synchronizer, "Localpart")));
        this.addRefreshable((Refreshable)new ItemEditorHelper((JTextComponent)this.jTxtNamespaceURI, (ItemEditorHelper.ItemEditorModel)new WsdlPortTextFieldEditorModel(this.synchronizer, "NamespaceURI")));
    }

    private void initComponents() {
        this.jPnlPortInfoDesc = new JPanel();
        this.jLblServiceEI = new JLabel();
        this.jTxtServiceEI = new JTextField();
        this.jLblNamespaceURI = new JLabel();
        this.jTxtNamespaceURI = new JTextField();
        this.jLblLocalpart = new JLabel();
        this.jTxtLocalpart = new JTextField();
        this.jLblEnableMsgSecurity = new JLabel();
        this.jChkEnableMsgSecurity = new JCheckBox();
        this.jBtnEditBindings = new JButton();
        this.setAlignmentX(0.0f);
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.jPnlPortInfoDesc.setOpaque(false);
        this.jPnlPortInfoDesc.setLayout(new GridBagLayout());
        this.jLblServiceEI.setLabelFor(this.jTxtServiceEI);
        this.jLblServiceEI.setText(this.webserviceBundle.getString("LBL_ServiceEndPoint_1"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.jPnlPortInfoDesc.add((Component)this.jLblServiceEI, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPnlPortInfoDesc.add((Component)this.jTxtServiceEI, gridBagConstraints);
        this.jTxtServiceEI.getAccessibleContext().setAccessibleName(this.webserviceBundle.getString("ACSN_ServiceEndPoint"));
        this.jTxtServiceEI.getAccessibleContext().setAccessibleDescription(this.webserviceBundle.getString("ACSD_ServiceEndPoint"));
        this.jLblNamespaceURI.setLabelFor(this.jTxtNamespaceURI);
        this.jLblNamespaceURI.setText(this.webserviceBundle.getString("LBL_NamespaceURI_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPnlPortInfoDesc.add((Component)this.jLblNamespaceURI, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPnlPortInfoDesc.add((Component)this.jTxtNamespaceURI, gridBagConstraints);
        this.jTxtNamespaceURI.getAccessibleContext().setAccessibleName(this.webserviceBundle.getString("ACSN_NamespaceURI"));
        this.jTxtNamespaceURI.getAccessibleContext().setAccessibleDescription(this.webserviceBundle.getString("ACSD_NamespaceURI"));
        this.jLblLocalpart.setLabelFor(this.jTxtLocalpart);
        this.jLblLocalpart.setText(this.webserviceBundle.getString("LBL_Localpart_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPnlPortInfoDesc.add((Component)this.jLblLocalpart, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPnlPortInfoDesc.add((Component)this.jTxtLocalpart, gridBagConstraints);
        this.jTxtLocalpart.getAccessibleContext().setAccessibleName(this.webserviceBundle.getString("ACSN_Localpart"));
        this.jTxtLocalpart.getAccessibleContext().setAccessibleDescription(this.webserviceBundle.getString("ACSD_Localpart"));
        this.jLblEnableMsgSecurity.setText(this.webserviceBundle.getString("LBL_EnableMsgSecurity_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPnlPortInfoDesc.add((Component)this.jLblEnableMsgSecurity, gridBagConstraints);
        this.jChkEnableMsgSecurity.setMargin(new Insets(0, 0, 0, 0));
        this.jChkEnableMsgSecurity.setOpaque(false);
        this.jChkEnableMsgSecurity.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PortInfoPanel.this.jChkEnableMsgSecurityItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 12);
        this.jPnlPortInfoDesc.add((Component)this.jChkEnableMsgSecurity, gridBagConstraints);
        this.jBtnEditBindings.setText(this.webserviceBundle.getString("LBL_EditMsgSecBindings"));
        this.jBtnEditBindings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortInfoPanel.this.jBtnEditBindingsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPnlPortInfoDesc.add((Component)this.jBtnEditBindings, gridBagConstraints);
        this.jBtnEditBindings.getAccessibleContext().setAccessibleName(this.webserviceBundle.getString("ACSN_EditMsgSecBindings"));
        this.jBtnEditBindings.getAccessibleContext().setAccessibleDescription(this.webserviceBundle.getString("ACSD_EditMsgSecBindings"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 5, 5);
        this.add(this.jPnlPortInfoDesc, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(this.webserviceBundle.getString("ACSN_SelectedPortInfo"));
        this.getAccessibleContext().setAccessibleDescription(this.webserviceBundle.getString("ACSD_SelectedPortInfo"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jBtnEditBindingsActionPerformed(ActionEvent evt) {
        if (!this.setup) {
            try {
                this.startUIChange();
                String asCloneVersion = this.isWebApp ? this.version.getWebAppVersionAsString() : (this.isEjbJar ? this.version.getEjbJarVersionAsString() : this.version.getAppClientVersionAsString());
                MessageSecurityBinding binding = this.portInfo.getMessageSecurityBinding();
                if (binding == null) {
                    binding = this.portInfo.newMessageSecurityBinding();
                    this.portInfo.setMessageSecurityBinding(binding);
                }
                EditBindingMultiview.editMessageSecurityBinding((JPanel)((Object)this), true, binding, this.version, asCloneVersion);
            }
            catch (VersionNotSupportedException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            finally {
                this.endUIChange();
                this.synchronizer.requestUpdateData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jChkEnableMsgSecurityItemStateChanged(ItemEvent evt) {
        if (!this.setup) {
            boolean hasMessageSecurity = Utils.interpretCheckboxState(evt);
            try {
                this.startUIChange();
                if (!hasMessageSecurity) {
                    this.portInfo.setMessageSecurityBinding(null);
                }
            }
            catch (VersionNotSupportedException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            finally {
                this.endUIChange();
                this.synchronizer.requestUpdateData();
            }
            this.enableMessageSecurityUI(hasMessageSecurity);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.setup = false;
    }

    private void enableMessageSecurityUI(boolean enable) {
        this.jBtnEditBindings.setEnabled(enable);
    }

    public String getHelpId() {
        return "AS_CFG_ServiceRefPortInfo";
    }

    private static boolean isEmpty(WsdlPort wp) {
        return Utils.strEmpty(wp.getLocalpart()) && Utils.strEmpty(wp.getNamespaceURI());
    }

    private class WsdlPortTextFieldEditorModel
    extends TextItemEditorModel {
        private String propertyName;

        public WsdlPortTextFieldEditorModel(XmlMultiViewDataSynchronizer synchronizer, String propertyName) {
            super(synchronizer, true, true);
            this.propertyName = propertyName;
        }

        @Override
        protected String getValue() {
            WsdlPort wp = PortInfoPanel.this.portInfo.getWsdlPort();
            return wp != null ? (String)wp.getValue(this.propertyName) : null;
        }

        @Override
        protected void setValue(String value) {
            WsdlPort wp = PortInfoPanel.this.portInfo.getWsdlPort();
            if (wp == null) {
                wp = PortInfoPanel.this.portInfo.newWsdlPort();
                PortInfoPanel.this.portInfo.setWsdlPort(wp);
            }
            wp.setValue(this.propertyName, (Object)value);
            if (PortInfoPanel.isEmpty(wp)) {
                PortInfoPanel.this.portInfo.setWsdlPort(null);
            }
            if (PortInfoPanel.this.portInfoNode.addVirtualBean()) {
                // empty if block
            }
        }
    }

    private class PortInfoTextFieldEditorModel
    extends DDTextFieldEditorModel {
        public PortInfoTextFieldEditorModel(XmlMultiViewDataSynchronizer synchronizer, String propertyName) {
            super(synchronizer, propertyName);
        }

        public PortInfoTextFieldEditorModel(XmlMultiViewDataSynchronizer synchronizer, String propertyName, String attributeName) {
            super(synchronizer, propertyName, attributeName);
        }

        @Override
        protected CommonDDBean getBean() {
            return PortInfoPanel.this.portInfo;
        }
    }
}

