/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer.internal;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.transfer.model.UploadResult;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PutObjectCallable
implements Callable<UploadResult> {
    private final PutObjectRequest putObjectRequest;
    private final AmazonS3 s3;

    public PutObjectCallable(AmazonS3 s3, PutObjectRequest putObjectRequest) {
        this.s3 = s3;
        this.putObjectRequest = putObjectRequest;
    }

    @Override
    public UploadResult call() throws Exception {
        PutObjectResult putObjectResult = this.s3.putObject(this.putObjectRequest);
        UploadResult uploadResult = new UploadResult();
        uploadResult.setBucketName(this.putObjectRequest.getBucketName());
        uploadResult.setKey(this.putObjectRequest.getKey());
        uploadResult.setETag(putObjectResult.getETag());
        uploadResult.setVersionId(putObjectResult.getVersionId());
        return uploadResult;
    }
}

