/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.ergonomics.fod;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.ui.api.PluginManager;
import org.netbeans.modules.ide.ergonomics.fod.BrokenProjectInfo;
import org.netbeans.modules.ide.ergonomics.fod.FeatureInfo;
import org.netbeans.modules.ide.ergonomics.fod.FeatureManager;
import org.netbeans.modules.ide.ergonomics.fod.ModulesInstaller;
import org.netbeans.modules.ide.ergonomics.fod.ProgressMonitor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class ConfigurationPanel
extends JPanel
implements Runnable {
    private static final long serialVersionUID = 27938464212508L;
    final DownloadProgressMonitor progressMonitor = new DownloadProgressMonitor();
    private FeatureInfo featureInfo;
    private Callable<JComponent> callable;
    private Collection<UpdateElement> featureInstall;
    private JButton activateButton;
    private JButton downloadButton;
    private JLabel downloadLabel;
    private JEditorPane errorLabel;
    private JLabel infoLabel;
    private JPanel progressPanel;

    public ConfigurationPanel(String displayName, Callable<JComponent> callable, FeatureInfo info) {
        this(callable);
        this.setInfo(info, displayName, Collections.emptyList(), Collections.emptyList(), Collections.emptyMap(), false);
    }

    public ConfigurationPanel(Callable<JComponent> callable) {
        assert (EventQueue.isDispatchThread());
        this.initComponents();
        this.featureInfo = null;
        this.callable = callable;
        this.setError(" ");
    }

    public void setInfo(FeatureInfo info, String displayName, Collection<UpdateElement> toInstall, Collection<FeatureInfo.ExtraModuleInfo> missingModules, Map<FeatureInfo.ExtraModuleInfo, FeatureInfo> extrasMap, boolean required) {
        boolean activateNow;
        this.featureInfo = info;
        this.featureInstall = toInstall;
        boolean bl = activateNow = toInstall.isEmpty() && missingModules.isEmpty();
        if (activateNow) {
            this.infoLabel.setVisible(false);
            this.downloadLabel.setVisible(false);
            this.activateButton.setVisible(false);
            this.downloadButton.setVisible(false);
            this.activateButtonActionPerformed(null);
        } else {
            FeatureManager.logUI("ERGO_QUESTION", this.featureInfo.clusterName, displayName);
            this.infoLabel.setVisible(true);
            this.downloadLabel.setVisible(true);
            this.activateButton.setVisible(true);
            this.downloadButton.setVisible(true);
            StringBuilder sbDownload = new StringBuilder();
            for (FeatureInfo fi : extrasMap.values()) {
                String s = required ? fi.getExtraModulesRequiredText() : fi.getExtraModulesRecommendedText();
                if (s == null) continue;
                if (sbDownload.length() > 0) {
                    sbDownload.append("\n");
                }
                sbDownload.append(s);
            }
            if (required) {
                this.activateButton.setEnabled(false);
            } else {
                this.activateButton.setEnabled(true);
            }
            String lblDownloadMsg = sbDownload.toString();
            String list = "";
            if (!missingModules.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (FeatureInfo.ExtraModuleInfo s : missingModules) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(s.displayName());
                }
                list = sb.toString();
                if (required) {
                    lblDownloadMsg = NbBundle.getMessage(ConfigurationPanel.class, (String)"MSG_MissingRequiredModules", (Object)displayName, (Object)list);
                    this.activateButton.setEnabled(false);
                } else {
                    lblDownloadMsg = NbBundle.getMessage(ConfigurationPanel.class, (String)"MSG_MissingRecommendedModules", (Object)displayName, (Object)list);
                }
                this.downloadButton.setEnabled(false);
            } else {
                this.downloadButton.setEnabled(true);
            }
            String lblActivateMsg = NbBundle.getMessage(ConfigurationPanel.class, (String)"LBL_EnableInfo", (Object)displayName);
            String btnActivateMsg = NbBundle.getMessage(ConfigurationPanel.class, (String)"LBL_Enable");
            String btnDownloadMsg = NbBundle.getMessage(ConfigurationPanel.class, (String)"LBL_Download");
            Mnemonics.setLocalizedText((JLabel)this.infoLabel, (String)lblActivateMsg);
            Mnemonics.setLocalizedText((AbstractButton)this.activateButton, (String)btnActivateMsg);
            Mnemonics.setLocalizedText((JLabel)this.downloadLabel, (String)lblDownloadMsg);
            Mnemonics.setLocalizedText((AbstractButton)this.downloadButton, (String)btnDownloadMsg);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        FeatureManager.logUI("ERGO_CLOSE", new Object[0]);
    }

    public void setUpdateErrors(Collection<IOException> errors) {
        if (errors.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        for (IOException ex : errors) {
            sb.append("<br/>");
            sb.append(ex.getLocalizedMessage());
        }
        sb.append("</html>");
        String updateError = NbBundle.getMessage(ConfigurationPanel.class, (String)"ERR_UpdateComponents", (Object)sb.toString());
        SwingUtilities.invokeLater(() -> {
            this.remove(this.errorLabel);
            this.progressPanel.removeAll();
            this.progressPanel.add(this.errorLabel);
            this.setError(updateError);
            this.progressPanel.revalidate();
            this.progressPanel.repaint();
        });
    }

    void setError(String msg) {
        assert (SwingUtilities.isEventDispatchThread());
        this.errorLabel.setText(msg);
    }

    private void initComponents() {
        this.errorLabel = BrokenProjectInfo.getErrorPane("dummy");
        this.infoLabel = new JLabel();
        this.activateButton = new JButton();
        this.progressPanel = new JPanel();
        this.downloadLabel = new JLabel();
        this.downloadButton = new JButton();
        Mnemonics.setLocalizedText((JLabel)this.infoLabel, (String)"dummy");
        Mnemonics.setLocalizedText((AbstractButton)this.activateButton, (String)"dummy");
        this.activateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationPanel.this.activateButtonActionPerformed(evt);
            }
        });
        this.progressPanel.setLayout(new BoxLayout(this.progressPanel, 3));
        Mnemonics.setLocalizedText((JLabel)this.downloadLabel, (String)NbBundle.getMessage(ConfigurationPanel.class, (String)"ConfigurationPanel.downloadLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.downloadButton, (String)NbBundle.getMessage(ConfigurationPanel.class, (String)"ConfigurationPanel.downloadButton.text"));
        this.downloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationPanel.this.downloadButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.progressPanel, -1, 374, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.errorLabel, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.downloadButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.activateButton)).addComponent(this.downloadLabel).addComponent(this.infoLabel)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.errorLabel, -1, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.infoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.downloadLabel).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.activateButton).addComponent(this.downloadButton)).addGap(19, 19, 19).addComponent(this.progressPanel, -1, 91, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void run() {
        ModulesInstaller.installModules(this.progressMonitor, this.featureInfo, this.featureInstall);
    }

    private void activateButtonActionPerformed(ActionEvent evt) {
        FeatureManager.logUI("ERGO_DOWNLOAD", new Object[0]);
        this.activateButton.setEnabled(false);
        this.downloadButton.setEnabled(false);
        RequestProcessor.Task task = FeatureManager.getInstance().create(this);
        task.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                if (!ConfigurationPanel.this.progressMonitor.error) {
                    SwingUtilities.invokeLater(new Runnable(){
                        private String msg;

                        @Override
                        public void run() {
                            ConfigurationPanel.this.removeAll();
                            ConfigurationPanel.this.setLayout(new BorderLayout());
                            try {
                                ConfigurationPanel.this.add((Component)ConfigurationPanel.this.callable.call(), "Center");
                            }
                            catch (Exception ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            ConfigurationPanel.this.invalidate();
                            ConfigurationPanel.this.revalidate();
                            ConfigurationPanel.this.repaint();
                            this.msg = ConfigurationPanel.this.featureInfo != null && ConfigurationPanel.this.featureInfo.isPresent() ? NbBundle.getMessage(ConfigurationPanel.class, (String)"MSG_EnableFailed") : NbBundle.getMessage(ConfigurationPanel.class, (String)"MSG_DownloadFailed");
                            ConfigurationPanel.this.setError(this.msg);
                            ConfigurationPanel.this.activateButton.setEnabled(true);
                            ConfigurationPanel.this.progressPanel.removeAll();
                            ConfigurationPanel.this.progressPanel.revalidate();
                            ConfigurationPanel.this.progressPanel.repaint();
                        }
                    });
                }
            }
        });
        task.schedule(0);
    }

    private void downloadButtonActionPerformed(ActionEvent evt) {
        OperationContainer op = OperationContainer.createForInstall();
        op.add(this.featureInstall);
        if (PluginManager.openInstallWizard((OperationContainer)op)) {
            this.activateButtonActionPerformed(null);
        }
    }

    private final class DownloadProgressMonitor
    implements ProgressMonitor {
        private boolean error = false;

        private DownloadProgressMonitor() {
        }

        @Override
        public void onDownload(ProgressHandle progressHandle) {
            this.updateProgress(progressHandle);
        }

        @Override
        public void onValidate(ProgressHandle progressHandle) {
            this.updateProgress(progressHandle);
        }

        @Override
        public void onInstall(ProgressHandle progressHandle) {
            this.updateProgress(progressHandle);
        }

        @Override
        public void onEnable(ProgressHandle progressHandle) {
            this.updateProgress(progressHandle);
        }

        private void updateProgress(ProgressHandle progressHandle) {
            final JLabel tmpMainLabel = ProgressHandleFactory.createMainLabelComponent((ProgressHandle)progressHandle);
            final JComponent tmpProgressPanel = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConfigurationPanel.this.progressPanel.removeAll();
                    ConfigurationPanel.this.progressPanel.add(tmpMainLabel);
                    ConfigurationPanel.this.progressPanel.add(Box.createRigidArea(new Dimension(0, 5)));
                    ConfigurationPanel.this.progressPanel.add(tmpProgressPanel);
                    ConfigurationPanel.this.progressPanel.revalidate();
                    ConfigurationPanel.this.progressPanel.repaint();
                }
            });
        }

        @Override
        public void onError(final String message) {
            this.error = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConfigurationPanel.this.setError("<html>" + message + "</html>");
                    ConfigurationPanel.this.progressPanel.removeAll();
                    ConfigurationPanel.this.progressPanel.add(ConfigurationPanel.this.errorLabel);
                }
            });
        }
    }
}

