/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee.ide;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.glassfish.javaee.ide.Hk2TargetModuleID;
import org.netbeans.modules.glassfish.javaee.ide.MonitorProgressObject;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.tooling.GlassFishIdeException;
import org.netbeans.modules.glassfish.tooling.TaskEvent;
import org.netbeans.modules.glassfish.tooling.TaskState;
import org.netbeans.modules.glassfish.tooling.admin.CommandGetProperty;
import org.netbeans.modules.glassfish.tooling.admin.ResultMap;
import org.netbeans.modules.glassfish.tooling.data.GlassFishServer;
import org.openide.util.RequestProcessor;

public class UpdateContextRoot
implements ProgressListener {
    private MonitorProgressObject returnProgress;
    private Hk2TargetModuleID moduleId;
    private ServerInstance si;
    private boolean needToDo;
    private static final RequestProcessor RP = new RequestProcessor("UpdateContextRoot", 5);

    public UpdateContextRoot(MonitorProgressObject returnProgress, Hk2TargetModuleID moduleId, ServerInstance si, boolean needToDo) {
        this.returnProgress = returnProgress;
        this.moduleId = moduleId;
        this.si = si;
        this.needToDo = needToDo;
    }

    public void handleProgressEvent(ProgressEvent event) {
        if (event.getDeploymentStatus().isCompleted()) {
            if (this.needToDo) {
                this.returnProgress.operationStateChanged(TaskState.RUNNING, TaskEvent.CMD_RUNNING, event.getDeploymentStatus().getMessage());
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            GlassFishServer server = ((GlassfishModule)UpdateContextRoot.this.si.getBasicNode().getLookup().lookup(GlassfishModule.class)).getInstance();
                            ResultMap result = CommandGetProperty.getProperties((GlassFishServer)server, (String)"applications.application.*.context-root");
                            if (result.getState() == TaskState.COMPLETED) {
                                Map retVal = result.getValue();
                                String newCR = (String)retVal.get("applications.application." + UpdateContextRoot.this.moduleId.getModuleID() + ".context-root");
                                if (null != newCR) {
                                    UpdateContextRoot.this.moduleId.setPath(newCR);
                                    UpdateContextRoot.this.returnProgress.operationStateChanged(TaskState.COMPLETED, TaskEvent.CMD_COMPLETED, "updated the moduleid");
                                } else {
                                    UpdateContextRoot.this.returnProgress.operationStateChanged(TaskState.COMPLETED, TaskEvent.CMD_COMPLETED, "no moduleid update necessary");
                                }
                            } else {
                                UpdateContextRoot.this.returnProgress.operationStateChanged(TaskState.COMPLETED, TaskEvent.CMD_COMPLETED, "no moduleid update necessary");
                            }
                        }
                        catch (GlassFishIdeException gfie) {
                            Logger.getLogger("glassfish-javaee").log(Level.INFO, "Could not retrieve property from server when updating module id.", gfie);
                        }
                    }
                });
            } else {
                this.returnProgress.operationStateChanged(TaskState.COMPLETED, TaskEvent.CMD_COMPLETED, event.getDeploymentStatus().getMessage());
            }
        } else if (event.getDeploymentStatus().isFailed()) {
            this.returnProgress.operationStateChanged(TaskState.FAILED, TaskEvent.CMD_FAILED, event.getDeploymentStatus().getMessage());
        } else {
            this.returnProgress.operationStateChanged(TaskState.RUNNING, TaskEvent.CMD_RUNNING, event.getDeploymentStatus().getMessage());
        }
    }
}

