# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class CookieCutter(PolyDataAlgorithm):
    """
    CookieCutter - cut PolyData defined on the 2d plane with one or
    more polygons
    
    Superclass: PolyDataAlgorithm
    
    This filter crops an input PolyData consisting of cells (i.e.,
    points, lines, polygons, and triangle strips) with loops specified by
    a second input containing polygons. Note that this filter can handle
    concave polygons and/or loops. It may produce multiple output
    polygons for each polygon/loop interaction. Similarly, it may produce
    multiple line segments and so on.
    
    @warning
    The z-values of the input PolyData and the points defining the
    loops are assumed to lie at z=constant. In other words, this filter
    assumes that the data lies in a plane orthogonal to the z axis.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkCookieCutter, obj, update, **traits)
    
    def _get_loops_connection(self):
        return wrap_vtk(self._vtk_obj.GetLoopsConnection())
    def _set_loops_connection(self, arg):
        old_val = self._get_loops_connection()
        self._wrap_call(self._vtk_obj.SetLoopsConnection,
                        deref_vtk(arg))
        self.trait_property_changed('loops_connection', old_val, arg)
    loops_connection = traits.Property(_get_loops_connection, _set_loops_connection, desc=\
        """
        
        """
    )

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input() -> DataObject
        C++: DataObject *GetInput()
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_loops(self):
        return wrap_vtk(self._vtk_obj.GetLoops())
    loops = traits.Property(_get_loops, desc=\
        """
        Specify the a second PolyData input which defines loops used
        to cut the input polygonal data. These loops must be manifold,
        i.e., do not self intersect. The loops are defined from the
        polygons defined in this second input.
        """
    )

    def set_loops_data(self, *args):
        """
        V.set_loops_data(DataObject)
        C++: void SetLoopsData(DataObject *loops)
        Specify the a second PolyData input which defines loops used
        to cut the input polygonal data. These loops must be manifold,
        i.e., do not self intersect. The loops are defined from the
        polygons defined in this second input.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetLoopsData, *my_args)
        return ret

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(CookieCutter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit CookieCutter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit CookieCutter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit CookieCutter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

