/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.ConfusionSet;
import org.languagetool.rules.ConfusionSetLoader;
import org.languagetool.rules.ConfusionString;

public class ConfusionSetLoaderTest {
    @Test
    public void testLoadWithStrictLimits() throws IOException {
        try (InputStream inputStream = JLanguageTool.getDataBroker().getFromResourceDirAsStream("/yy/confusion_sets.txt");){
            ConfusionSetLoader loader = new ConfusionSetLoader();
            Map map = loader.loadConfusionSet(inputStream);
            MatcherAssert.assertThat((Object)map.size(), (Matcher)CoreMatchers.is((Object)10));
            MatcherAssert.assertThat((Object)((List)map.get("there")).size(), (Matcher)CoreMatchers.is((Object)1));
            MatcherAssert.assertThat((Object)((ConfusionSet)((List)map.get("there")).get(0)).getFactor(), (Matcher)CoreMatchers.is((Object)10L));
            MatcherAssert.assertThat((Object)((List)map.get("their")).size(), (Matcher)CoreMatchers.is((Object)1));
            MatcherAssert.assertThat((Object)((ConfusionSet)((List)map.get("their")).get(0)).getFactor(), (Matcher)CoreMatchers.is((Object)10L));
            MatcherAssert.assertThat((Object)((List)map.get("foo")).size(), (Matcher)CoreMatchers.is((Object)2));
            MatcherAssert.assertThat((Object)((ConfusionSet)((List)map.get("foo")).get(0)).getFactor(), (Matcher)CoreMatchers.is((Object)5L));
            MatcherAssert.assertThat((Object)((ConfusionSet)((List)map.get("foo")).get(1)).getFactor(), (Matcher)CoreMatchers.is((Object)8L));
            MatcherAssert.assertThat((Object)((List)map.get("goo")).size(), (Matcher)CoreMatchers.is((Object)2));
            MatcherAssert.assertThat((Object)((ConfusionSet)((List)map.get("goo")).get(0)).getFactor(), (Matcher)CoreMatchers.is((Object)11L));
            MatcherAssert.assertThat((Object)((ConfusionSet)((List)map.get("goo")).get(1)).getFactor(), (Matcher)CoreMatchers.is((Object)12L));
            MatcherAssert.assertThat((Object)((List)map.get("lol")).size(), (Matcher)CoreMatchers.is((Object)1));
            MatcherAssert.assertThat((Object)((List)map.get("something")).size(), (Matcher)CoreMatchers.is((Object)1));
            MatcherAssert.assertThat((Object)((List)map.get("bar")).size(), (Matcher)CoreMatchers.is((Object)1));
            MatcherAssert.assertThat((Object)((ConfusionSet)((List)map.get("bar")).get(0)).getFactor(), (Matcher)CoreMatchers.is((Object)5L));
            Set there = ((ConfusionSet)((List)map.get("there")).get(0)).getSet();
            Assert.assertTrue((boolean)this.getAsString(there).contains("there - example 1"));
            Assert.assertTrue((boolean)this.getAsString(there).contains("their - example 2"));
            Set their = ((ConfusionSet)((List)map.get("their")).get(0)).getSet();
            Assert.assertTrue((boolean)this.getAsString(their).contains("there - example 1"));
            Assert.assertTrue((boolean)this.getAsString(their).contains("their - example 2"));
            Assert.assertFalse((boolean)this.getAsString(their).contains("comment"));
            Set foo = ((ConfusionSet)((List)map.get("foo")).get(0)).getSet();
            Assert.assertTrue((boolean)this.getAsString(foo).contains("foo"));
            Set bar = ((ConfusionSet)((List)map.get("foo")).get(0)).getSet();
            Assert.assertTrue((boolean)this.getAsString(bar).contains("bar"));
            Set baz = ((ConfusionSet)((List)map.get("foo")).get(1)).getSet();
            Assert.assertTrue((boolean)this.getAsString(baz).contains("baz"));
        }
    }

    private String getAsString(Set<ConfusionString> their) {
        StringBuilder sb = new StringBuilder();
        for (ConfusionString confusionString : their) {
            sb.append(confusionString.getString()).append(" - ");
            sb.append(confusionString.getDescription());
            sb.append(" ");
        }
        return sb.toString();
    }
}

