/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.ByteDoubleHashMap;
import com.carrotsearch.hppc.HashOrderMixing;

public class ByteDoubleScatterMap
extends ByteDoubleHashMap {
    public ByteDoubleScatterMap() {
        this(4);
    }

    public ByteDoubleScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ByteDoubleScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(byte key) {
        return BitMixer.mixPhi(key);
    }

    public static ByteDoubleScatterMap from(byte[] keys, double[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ByteDoubleScatterMap map = new ByteDoubleScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

