/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#include"typedef.h"
/**************************************************************************\
@---------------------------------------------------------------------------
@---------------------------------------------------------------------------
@ FILE: modp_mat.c
@---------------------------------------------------------------------------
@---------------------------------------------------------------------------
@
\**************************************************************************/

/**************************************************************************\
@---------------------------------------------------------------------------
@ void modp_mat(M, p)
@ matrix_TYP *M;
@ int p;
@
@ reduces the entries of M modulo p such -|p/2| < x < |p/2|
@ for every entry x of M.
@ if p = 2 or p = -2, the entries are 0 or 1.
@---------------------------------------------------------------------------
@
\**************************************************************************/

void modp_mat(M, prime)
matrix_TYP *M;
int prime;
{
  int i,j, phalbe, mphalbe;

  if(prime < 0)
    prime = -prime;
  phalbe = prime/2;
  mphalbe = -phalbe;
  if(prime == 2)
    mphalbe = 0;
  for(i=0;i<M->rows;i++)
    for(j=0;j<M->cols;j++)
    {
       M->array.SZ[i][j] %=prime;
       if(M->array.SZ[i][j] < mphalbe)
         M->array.SZ[i][j] +=prime;
       if(M->array.SZ[i][j] > phalbe)
         M->array.SZ[i][j] -=prime;
    }
}
