/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPExternalFileManager;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.editors.INonPersistentEditorInput;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.CommonUtils;

public class EditorUtils {
    public static final String PROP_SQL_DATA_SOURCE_ID = "sql-editor-data-source-id";
    public static final String PROP_SQL_PROJECT_ID = "sql-editor-project-id";
    public static final String PROP_SQL_DATA_SOURCE_CONTAINER = "sql-editor-data-source-container";
    public static final QualifiedName QN_PROJECT_ID = new QualifiedName("org.jkiss.dbeaver", "sql-editor-project-id");
    public static final QualifiedName QN_DATA_SOURCE_ID = new QualifiedName("org.jkiss.dbeaver", "sql-editor-data-source-id");
    private static final Log log = Log.getLog(EditorUtils.class);

    @Nullable
    public static IFile getFileFromInput(IEditorInput editorInput) {
        if (editorInput == null) {
            return null;
        }
        if (editorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)editorInput).getFile();
        }
        if (editorInput instanceof IPathEditorInput) {
            IPath path = ((IPathEditorInput)editorInput).getPath();
            return path == null ? null : ContentUtils.convertPathToWorkspaceFile((IPath)path);
        }
        if (editorInput instanceof IURIEditorInput) {
            return null;
        }
        IPathEditorInput pathInput = (IPathEditorInput)editorInput.getAdapter(IPathEditorInput.class);
        if (pathInput != null) {
            IPath path = pathInput.getPath();
            return path == null ? null : ContentUtils.convertPathToWorkspaceFile((IPath)path);
        }
        try {
            Method getFileMethod = editorInput.getClass().getMethod("getFile", new Class[0]);
            if (IFile.class.isAssignableFrom(getFileMethod.getReturnType())) {
                return (IFile)IFile.class.cast(getFileMethod.invoke((Object)editorInput, new Object[0]));
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static IStorage getStorageFromInput(Object element) {
        IFile file;
        IStorage storage;
        if (element instanceof IAdaptable && (storage = (IStorage)((IAdaptable)element).getAdapter(IStorage.class)) != null) {
            return storage;
        }
        if (element instanceof IEditorInput && (file = EditorUtils.getFileFromInput((IEditorInput)element)) != null) {
            return file;
        }
        return null;
    }

    public static File getLocalFileFromInput(Object element) {
        if (element instanceof IEditorInput) {
            File localFile;
            IFile file = EditorUtils.getFileFromInput((IEditorInput)element);
            if (file != null) {
                return file.getLocation().toFile();
            }
            if (element instanceof IURIEditorInput && (localFile = new File(((IURIEditorInput)element).getURI())).exists()) {
                return localFile;
            }
        }
        return null;
    }

    public static DBPDataSourceContainer getInputDataSource(IEditorInput editorInput) {
        if (editorInput instanceof IDatabaseEditorInput) {
            DBSObject object = ((IDatabaseEditorInput)editorInput).getDatabaseObject();
            if (object != null && object.getDataSource() != null) {
                return object.getDataSource().getContainer();
            }
            return null;
        }
        if (editorInput instanceof INonPersistentEditorInput) {
            return (DBPDataSourceContainer)((INonPersistentEditorInput)editorInput).getProperty(PROP_SQL_DATA_SOURCE_CONTAINER);
        }
        IFile file = EditorUtils.getFileFromInput(editorInput);
        if (file != null) {
            return EditorUtils.getFileDataSource(file);
        }
        File localFile = EditorUtils.getLocalFileFromInput(editorInput);
        if (localFile != null) {
            DBPExternalFileManager efManager = DBWorkbench.getPlatform().getExternalFileManager();
            String dataSourceId = (String)efManager.getFileProperty(localFile, PROP_SQL_DATA_SOURCE_ID);
            String projectName = (String)efManager.getFileProperty(localFile, PROP_SQL_PROJECT_ID);
            if (CommonUtils.isEmpty((String)dataSourceId) || CommonUtils.isEmpty((String)projectName)) {
                return null;
            }
            IProject project = DBWorkbench.getPlatform().getWorkspace().getEclipseWorkspace().getRoot().getProject(projectName);
            if (project == null || !project.exists()) {
                log.error((Object)("Can't locate project '" + projectName + "' in workspace"));
                return null;
            }
            DBPDataSourceRegistry dataSourceRegistry = DBWorkbench.getPlatform().getProjectManager().getDataSourceRegistry(project);
            return dataSourceRegistry == null ? null : dataSourceRegistry.getDataSource(dataSourceId);
        }
        return null;
    }

    @Nullable
    public static DBPDataSourceContainer getFileDataSource(IFile file) {
        block5: {
            try {
                if (file.exists()) break block5;
                return null;
            }
            catch (CoreException e) {
                log.error((Object)"Internal error while reading file property", (Throwable)e);
                return null;
            }
        }
        String projectId = file.getPersistentProperty(QN_PROJECT_ID);
        String dataSourceId = file.getPersistentProperty(QN_DATA_SOURCE_ID);
        if (dataSourceId != null) {
            DBPDataSourceRegistry dataSourceRegistry;
            IProject fileProject;
            IProject project = file.getProject();
            if (projectId != null && (fileProject = DBWorkbench.getPlatform().getWorkspace().getEclipseWorkspace().getRoot().getProject(projectId)) != null && fileProject.exists()) {
                project = fileProject;
            }
            return (dataSourceRegistry = DBWorkbench.getPlatform().getProjectManager().getDataSourceRegistry(project)) == null ? null : dataSourceRegistry.getDataSource(dataSourceId);
        }
        return null;
    }

    public static void setInputDataSource(@NotNull IEditorInput editorInput, @Nullable DBPDataSourceContainer dataSourceContainer) {
        if (editorInput instanceof INonPersistentEditorInput) {
            ((INonPersistentEditorInput)editorInput).setProperty(PROP_SQL_DATA_SOURCE_CONTAINER, dataSourceContainer);
            return;
        }
        IFile file = EditorUtils.getFileFromInput(editorInput);
        if (file != null) {
            EditorUtils.setFileDataSource(file, dataSourceContainer);
        } else {
            File localFile = EditorUtils.getLocalFileFromInput(editorInput);
            if (localFile != null) {
                EditorUtils.setFileDataSource(localFile, dataSourceContainer);
            } else {
                log.error((Object)("Can't set datasource for input " + editorInput));
            }
        }
    }

    private static void setFileDataSource(File localFile, @Nullable DBPDataSourceContainer dataSourceContainer) {
        DBPExternalFileManager efManager = DBWorkbench.getPlatform().getExternalFileManager();
        efManager.setFileProperty(localFile, PROP_SQL_PROJECT_ID, dataSourceContainer == null ? null : dataSourceContainer.getRegistry().getProject().getName());
        efManager.setFileProperty(localFile, PROP_SQL_DATA_SOURCE_ID, (Object)(dataSourceContainer == null ? null : dataSourceContainer.getId()));
    }

    public static void setFileDataSource(@NotNull IFile file, @Nullable DBPDataSourceContainer dataSourceContainer) {
        try {
            file.setPersistentProperty(QN_DATA_SOURCE_ID, dataSourceContainer == null ? null : dataSourceContainer.getId());
            file.setPersistentProperty(QN_PROJECT_ID, dataSourceContainer == null ? null : dataSourceContainer.getRegistry().getProject().getName());
        }
        catch (CoreException e) {
            log.error((Object)"Internal error while writing file property", (Throwable)e);
        }
    }

    public static void openExternalFileEditor(File file, IWorkbenchWindow window) {
        try {
            IEditorDescriptor desc = window.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
            if (desc == null) {
                desc = window.getWorkbench().getEditorRegistry().getDefaultEditor(String.valueOf(file.getName()) + ".txt");
            }
            IFileStore fileStore = EFS.getStore((URI)file.toURI());
            FileStoreEditorInput input = new FileStoreEditorInput(fileStore);
            IDE.openEditor((IWorkbenchPage)window.getActivePage(), (IEditorInput)input, (String)desc.getId());
        }
        catch (CoreException e) {
            log.error((Object)("Can't open editor from file '" + file.getAbsolutePath()), (Throwable)e);
        }
    }

    public static boolean isInAutoSaveJob() {
        Job currentJob = Job.getJobManager().currentJob();
        if (currentJob == null) {
            return false;
        }
        return "Auto save all editors".equals(currentJob.getName());
    }

    public static void trackControlContext(IWorkbenchSite site, Control control, final String contextId) {
        final IContextService contextService = (IContextService)site.getService(IContextService.class);
        if (contextService != null) {
            control.addFocusListener(new FocusListener(){
                IContextActivation activation;

                public void focusGained(FocusEvent e) {
                    if (this.activation != null) {
                        contextService.deactivateContext(this.activation);
                        this.activation = null;
                    }
                    this.activation = contextService.activateContext(contextId);
                }

                public void focusLost(FocusEvent e) {
                    if (this.activation != null) {
                        contextService.deactivateContext(this.activation);
                        this.activation = null;
                    }
                }
            });
        }
        control.addDisposeListener(e -> UIUtils.removeFocusTracker((IServiceLocator)site, (Control)control));
    }
}

