/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.edit.PostgreTableManagerBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreClass;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreIndex;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraint;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableForeign;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableForeignKey;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableRegular;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLStructEditor;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.utils.CommonUtils;

public class PostgreTableManager
extends PostgreTableManagerBase
implements DBEObjectRenamer<PostgreTableBase> {
    private static final Class<?>[] CHILD_TYPES = new Class[]{PostgreTableColumn.class, PostgreTableConstraint.class, PostgreTableForeignKey.class, PostgreIndex.class};

    @Nullable
    public DBSObjectCache<PostgreSchema, PostgreTableBase> getObjectsCache(PostgreTableBase object) {
        return ((PostgreSchema)object.getContainer()).tableCache;
    }

    protected String getCreateTableType(PostgreTableBase table) {
        if (table instanceof PostgreTableForeign) {
            return "FOREIGN TABLE";
        }
        return "TABLE";
    }

    protected PostgreTableBase createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, PostgreSchema parent, Object copyFrom) {
        PostgreTableBase table = parent.getDataSource().getServerType().createNewRelation(parent, PostgreClass.RelKind.r);
        try {
            this.setTableName(monitor, (DBSObjectContainer)parent, (DBSTable)table);
        }
        catch (DBException e) {
            log.error((Object)e);
        }
        return table;
    }

    protected void addStructObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLStructEditor.StructCreateCommand command, Map<String, Object> options) throws DBException {
        String tableDDL;
        PostgreTableBase tableBase = (PostgreTableBase)command.getObject();
        if (tableBase.isPersisted() && (tableDDL = ((PostgreDataSource)tableBase.getDataSource()).getServerType().readTableDDL(monitor, tableBase)) != null) {
            actions.add(0, (DBEPersistAction)new SQLDatabasePersistAction(ModelMessages.model_jdbc_create_new_table, tableDDL));
            return;
        }
        super.addStructObjectCreateActions(monitor, actions, command, options);
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        if ((command.getProperties().size() > 1 || command.getProperty((Object)"description") == null) && command.getObject() instanceof PostgreTableRegular) {
            try {
                this.generateAlterActions(monitor, actionList, command);
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
    }

    private void generateAlterActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command) throws DBException {
        PostgreTableRegular table = (PostgreTableRegular)command.getObject();
        String alterPrefix = "ALTER TABLE " + ((PostgreTableBase)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " ";
        if (command.hasProperty((Object)"hasOids")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction(String.valueOf(alterPrefix) + (table.isHasOids() ? "SET WITH OIDS" : "SET WITHOUT OIDS")));
        }
        if (command.hasProperty((Object)"tablespace")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction(String.valueOf(alterPrefix) + "SET TABLESPACE " + table.getTablespace(monitor).getName()));
        }
    }

    protected void appendTableModifiers(DBRProgressMonitor monitor, PostgreTableBase tableBase, SQLObjectEditor.NestedObjectCommand tableProps, StringBuilder ddl, boolean alter) {
        ddl.append(((PostgreDataSource)tableBase.getDataSource()).getServerType().getTableModifiers(monitor, tableBase, alter));
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename table", "ALTER TABLE " + DBUtils.getQuotedIdentifier((DBSObject)((PostgreTableBase)command.getObject()).getSchema()) + "." + DBUtils.getQuotedIdentifier((DBPDataSource)((PostgreTableBase)command.getObject()).getDataSource(), (String)command.getOldName()) + " RENAME TO " + DBUtils.getQuotedIdentifier((DBPDataSource)((PostgreTableBase)command.getObject()).getDataSource(), (String)command.getNewName())));
    }

    @NotNull
    public Class<?>[] getChildTypes() {
        return CHILD_TYPES;
    }

    public void renameObject(DBECommandContext commandContext, PostgreTableBase object, String newName) throws DBException {
        this.processObjectRename(commandContext, object, newName);
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction(ModelMessages.model_jdbc_drop_table, "DROP " + (command.getObject() instanceof PostgreTableForeign ? "FOREIGN TABLE" : "TABLE") + " " + ((PostgreTableBase)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL) + (CommonUtils.getOption(options, (String)"deleteCascade") ? " CASCADE" : "")));
    }
}

