/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.debug.core.breakpoints;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.jkiss.dbeaver.debug.DBGBreakpointDescriptor;
import org.jkiss.dbeaver.debug.core.breakpoints.DatabaseBreakpoint;
import org.jkiss.dbeaver.debug.core.breakpoints.IDatabaseLineBreakpoint;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class DatabaseLineBreakpoint
extends DatabaseBreakpoint
implements IDatabaseLineBreakpoint {
    public DatabaseLineBreakpoint() {
    }

    public DatabaseLineBreakpoint(DBSObject databaseObject, DBNNode node, IResource resource, DBGBreakpointDescriptor breakpointDescriptor, int lineNumber, int charStart, int charEnd, boolean add) throws DebugException {
        this(databaseObject, node, resource, breakpointDescriptor, lineNumber, charStart, charEnd, add, new HashMap<String, Object>(), "org.jkiss.dbeaver.debug.core.databaseLineBreakpointMarker");
    }

    protected DatabaseLineBreakpoint(DBSObject databaseObject, DBNNode node, IResource resource, DBGBreakpointDescriptor breakpointDescriptor, int lineNumber, int charStart, int charEnd, boolean add, Map<String, Object> attributes, String markerType) throws DebugException {
        IWorkspaceRunnable wr = monitor -> {
            this.setMarker(resource.createMarker(markerType));
            this.addDatabaseBreakpointAttributes(attributes, databaseObject, node, breakpointDescriptor);
            this.addLineBreakpointAttributes(attributes, this.getModelIdentifier(), true, lineNumber, charStart, charEnd);
            this.ensureMarker().setAttributes(attributes);
            this.register(add);
        };
        this.run(this.getMarkerRule(resource), wr);
    }

    public int getLineNumber() throws CoreException {
        IMarker m = this.getMarker();
        if (m != null) {
            return m.getAttribute("lineNumber", -1);
        }
        return -1;
    }

    public int getCharStart() throws CoreException {
        IMarker m = this.getMarker();
        if (m != null) {
            return m.getAttribute("charStart", -1);
        }
        return -1;
    }

    public int getCharEnd() throws CoreException {
        IMarker m = this.getMarker();
        if (m != null) {
            return m.getAttribute("charEnd", -1);
        }
        return -1;
    }

    public void addLineBreakpointAttributes(Map<String, Object> attributes, String modelIdentifier, boolean enabled, int lineNumber, int charStart, int charEnd) {
        attributes.put("org.eclipse.debug.core.id", modelIdentifier);
        attributes.put("org.eclipse.debug.core.enabled", enabled);
        attributes.put("lineNumber", lineNumber);
        attributes.put("charStart", charStart);
        attributes.put("charEnd", charEnd);
    }
}

