/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.entity;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.EditorPart;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class ErrorEditorPartEx
extends EditorPart {
    private IStatus error;
    private Composite parentControl;
    private static final String LOG_VIEW_ID = "org.eclipse.pde.runtime.LogView";
    boolean showingDetails = false;
    private Button detailsButton;
    private Composite detailsArea;
    private Control details = null;

    public ErrorEditorPartEx(IStatus error) {
        this.error = error;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void createPartControl(Composite parent) {
        this.parentControl = parent;
        if (this.error != null) {
            this.createErrorPane(parent);
        }
    }

    public void init(IEditorSite site, IEditorInput input) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(input.getName());
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
        this.parentControl.setFocus();
    }

    public void setPartName(String newName) {
        super.setPartName(newName);
    }

    public void dispose() {
        super.dispose();
        this.parentControl = null;
    }

    private void createErrorPane(Composite parent) {
        Image image;
        int margins;
        Color bgColor = parent.getDisplay().getSystemColor(25);
        Color fgColor = parent.getDisplay().getSystemColor(24);
        parent.setBackground(bgColor);
        parent.setForeground(fgColor);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        int spacing = 8;
        layout.marginBottom = margins = 8;
        layout.marginTop = margins;
        layout.marginLeft = margins;
        layout.marginRight = margins;
        layout.horizontalSpacing = spacing;
        layout.verticalSpacing = spacing;
        parent.setLayout((Layout)layout);
        Display d = Display.getCurrent();
        Label imageLabel = new Label(parent, 0);
        imageLabel.setBackground(bgColor);
        switch (this.error.getSeverity()) {
            case 4: {
                image = d.getSystemImage(1);
                break;
            }
            case 2: {
                image = d.getSystemImage(8);
                break;
            }
            default: {
                image = d.getSystemImage(2);
            }
        }
        image.setBackground(bgColor);
        imageLabel.setImage(image);
        imageLabel.setLayoutData((Object)new GridData(66));
        Text text = new Text(parent, 74);
        text.setBackground(bgColor);
        text.setForeground(fgColor);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        text.setText(this.error.getMessage());
        Composite buttonParent = new Composite(parent, 0);
        buttonParent.setBackground(parent.getBackground());
        GridLayout buttonsLayout = new GridLayout();
        buttonsLayout.numColumns = 2;
        buttonsLayout.marginHeight = 0;
        buttonsLayout.marginWidth = 0;
        buttonsLayout.horizontalSpacing = 0;
        buttonParent.setLayout((Layout)buttonsLayout);
        this.detailsButton = new Button(buttonParent, 8);
        this.detailsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ErrorEditorPartEx.this.showingDetails = !ErrorEditorPartEx.this.showingDetails;
                ErrorEditorPartEx.this.updateDetailsText();
            }
        });
        this.detailsButton.setLayoutData((Object)new GridData(1, 4, false, false));
        this.updateDetailsText();
        this.detailsArea = new Composite(parent, 0);
        this.detailsArea.setBackground(bgColor);
        this.detailsArea.setForeground(fgColor);
        GridData data = new GridData(1808);
        data.horizontalSpan = 3;
        data.verticalSpan = 1;
        this.detailsArea.setLayoutData((Object)data);
        this.detailsArea.setLayout((Layout)new FillLayout());
        parent.layout(true);
    }

    private void updateDetailsText() {
        if (this.details != null) {
            this.details.dispose();
            this.details = null;
        }
        if (this.showingDetails) {
            this.detailsButton.setText(IDialogConstants.HIDE_DETAILS_LABEL);
            Text detailsText = new Text(this.detailsArea, 33557258);
            detailsText.setText(this.getDetails());
            detailsText.setBackground(detailsText.getDisplay().getSystemColor(25));
            this.details = detailsText;
            this.detailsArea.layout(true);
        } else {
            this.detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
        }
    }

    private String getDetails() {
        if (this.error.getException() != null) {
            return this.getStackTrace(this.error.getException());
        }
        return GeneralUtils.getStatusText((IStatus)this.error);
    }

    private String getStackTrace(Throwable throwable) {
        StringWriter swriter = new StringWriter();
        PrintWriter pwriter = new PrintWriter(swriter);
        throwable.printStackTrace(pwriter);
        pwriter.flush();
        pwriter.close();
        return swriter.toString();
    }
}

