(function() {
  var cloneObject, ipcHelpers,
    slice = [].slice;

  ipcHelpers = require('./ipc-helpers');

  cloneObject = function(object) {
    var clone, key, value;
    clone = {};
    for (key in object) {
      value = object[key];
      clone[key] = value;
    }
    return clone;
  };

  module.exports = function(arg) {
    var ApplicationDelegate, AtomEnvironment, Clipboard, CompileCache, FindParentDir, TextEditor, blobStore, buildAtomEnvironment, buildDefaultApplicationDelegate, clipboard, env, error, exitWithStatusCode, exportsPath, getWindowLoadSettings, handleKeydown, headless, ipcRenderer, legacyTestRunner, legacyTestRunnerPath, logFile, packageMetadata, packageRoot, path, promise, ref, ref1, remote, startCrashReporter, testPaths, testRunner, testRunnerPath, updateProcessEnv, util;
    blobStore = arg.blobStore;
    startCrashReporter = require('./crash-reporter-start');
    remote = require('electron').remote;
    startCrashReporter();
    exitWithStatusCode = function(status) {
      remote.app.emit('will-quit');
      return remote.process.exit(status);
    };
    try {
      path = require('path');
      ipcRenderer = require('electron').ipcRenderer;
      getWindowLoadSettings = require('./get-window-load-settings');
      CompileCache = require('./compile-cache');
      AtomEnvironment = require('../src/atom-environment');
      ApplicationDelegate = require('../src/application-delegate');
      Clipboard = require('../src/clipboard');
      TextEditor = require('../src/text-editor');
      updateProcessEnv = require('./update-process-env').updateProcessEnv;
      require('./electron-shims');
      ipcRenderer.on('environment', function(event, env) {
        return updateProcessEnv(env);
      });
      ref = getWindowLoadSettings(), testRunnerPath = ref.testRunnerPath, legacyTestRunnerPath = ref.legacyTestRunnerPath, headless = ref.headless, logFile = ref.logFile, testPaths = ref.testPaths, env = ref.env;
      if (headless) {
        util = require('util');
        Object.defineProperties(process, {
          stdout: {
            value: remote.process.stdout
          },
          stderr: {
            value: remote.process.stderr
          }
        });
        console.log = function() {
          var args;
          args = 1 <= arguments.length ? slice.call(arguments, 0) : [];
          return process.stdout.write((util.format.apply(util, args)) + "\n");
        };
        console.error = function() {
          var args;
          args = 1 <= arguments.length ? slice.call(arguments, 0) : [];
          return process.stderr.write((util.format.apply(util, args)) + "\n");
        };
      } else {
        remote.getCurrentWindow().show();
      }
      handleKeydown = function(event) {
        if ((event.metaKey || event.ctrlKey) && event.keyCode === 82) {
          ipcHelpers.call('window-method', 'reload');
        }
        if (event.keyCode === 73 && ((process.platform === 'darwin' && event.metaKey && event.altKey) || (process.platform !== 'darwin' && event.ctrlKey && event.shiftKey))) {
          ipcHelpers.call('window-method', 'toggleDevTools');
        }
        if ((event.metaKey || event.ctrlKey) && event.keyCode === 87) {
          ipcHelpers.call('window-method', 'close');
        }
        if ((event.metaKey || event.ctrlKey) && event.keyCode === 67) {
          return ipcHelpers.call('window-method', 'copy');
        }
      };
      window.addEventListener('keydown', handleKeydown, true);
      exportsPath = path.join(getWindowLoadSettings().resourcePath, 'exports');
      require('module').globalPaths.push(exportsPath);
      process.env.NODE_PATH = exportsPath;
      updateProcessEnv(env);
      FindParentDir = require('find-parent-dir');
      if (packageRoot = FindParentDir.sync(testPaths[0], 'package.json')) {
        packageMetadata = require(path.join(packageRoot, 'package.json'));
        if (packageMetadata.atomTranspilers) {
          CompileCache.addTranspilerConfigForPath(packageRoot, packageMetadata.name, packageMetadata, packageMetadata.atomTranspilers);
        }
      }
      document.title = "Spec Suite";
      clipboard = new Clipboard;
      TextEditor.setClipboard(clipboard);
      TextEditor.viewForItem = function(item) {
        return atom.views.getView(item);
      };
      testRunner = require(testRunnerPath);
      legacyTestRunner = require(legacyTestRunnerPath);
      buildDefaultApplicationDelegate = function() {
        return new ApplicationDelegate();
      };
      buildAtomEnvironment = function(params) {
        var atomEnvironment;
        params = cloneObject(params);
        if (!params.hasOwnProperty("clipboard")) {
          params.clipboard = clipboard;
        }
        if (!params.hasOwnProperty("blobStore")) {
          params.blobStore = blobStore;
        }
        if (!params.hasOwnProperty("onlyLoadBaseStyleSheets")) {
          params.onlyLoadBaseStyleSheets = true;
        }
        atomEnvironment = new AtomEnvironment(params);
        atomEnvironment.initialize(params);
        TextEditor.setScheduler(atomEnvironment.views);
        return atomEnvironment;
      };
      promise = testRunner({
        logFile: logFile,
        headless: headless,
        testPaths: testPaths,
        buildAtomEnvironment: buildAtomEnvironment,
        buildDefaultApplicationDelegate: buildDefaultApplicationDelegate,
        legacyTestRunner: legacyTestRunner
      });
      return promise.then(function(statusCode) {
        if (getWindowLoadSettings().headless) {
          return exitWithStatusCode(statusCode);
        }
      });
    } catch (error1) {
      error = error1;
      if (getWindowLoadSettings().headless) {
        console.error((ref1 = error.stack) != null ? ref1 : error);
        return exitWithStatusCode(1);
      } else {
        throw error;
      }
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
