(function() {
  var DefaultFileIcons, fs, path;

  fs = require('fs-plus');

  path = require('path');

  DefaultFileIcons = (function() {
    function DefaultFileIcons() {}

    DefaultFileIcons.prototype.iconClassForPath = function(filePath) {
      var extension;
      extension = path.extname(filePath);
      if (fs.isSymbolicLinkSync(filePath)) {
        return 'icon-file-symlink-file';
      } else if (fs.isReadmePath(filePath)) {
        return 'icon-book';
      } else if (fs.isCompressedExtension(extension)) {
        return 'icon-file-zip';
      } else if (fs.isImageExtension(extension)) {
        return 'icon-file-media';
      } else if (fs.isPdfExtension(extension)) {
        return 'icon-file-pdf';
      } else if (fs.isBinaryExtension(extension)) {
        return 'icon-file-binary';
      } else {
        return 'icon-file-text';
      }
    };

    return DefaultFileIcons;

  })();

  module.exports = new DefaultFileIcons;

}).call(this);

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiL2J1aWxkL2F0b20vc3JjL2F0b20tMS4zOC4xL291dC9hcHAvbm9kZV9tb2R1bGVzL3RyZWUtdmlldy9saWIvZGVmYXVsdC1maWxlLWljb25zLmNvZmZlZSJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtBQUFBLE1BQUE7O0VBQUEsRUFBQSxHQUFLLE9BQUEsQ0FBUSxTQUFSOztFQUNMLElBQUEsR0FBTyxPQUFBLENBQVEsTUFBUjs7RUFFRDs7OytCQUNKLGdCQUFBLEdBQWtCLFNBQUMsUUFBRDtBQUNoQixVQUFBO01BQUEsU0FBQSxHQUFZLElBQUksQ0FBQyxPQUFMLENBQWEsUUFBYjtNQUVaLElBQUcsRUFBRSxDQUFDLGtCQUFILENBQXNCLFFBQXRCLENBQUg7ZUFDRSx5QkFERjtPQUFBLE1BRUssSUFBRyxFQUFFLENBQUMsWUFBSCxDQUFnQixRQUFoQixDQUFIO2VBQ0gsWUFERztPQUFBLE1BRUEsSUFBRyxFQUFFLENBQUMscUJBQUgsQ0FBeUIsU0FBekIsQ0FBSDtlQUNILGdCQURHO09BQUEsTUFFQSxJQUFHLEVBQUUsQ0FBQyxnQkFBSCxDQUFvQixTQUFwQixDQUFIO2VBQ0gsa0JBREc7T0FBQSxNQUVBLElBQUcsRUFBRSxDQUFDLGNBQUgsQ0FBa0IsU0FBbEIsQ0FBSDtlQUNILGdCQURHO09BQUEsTUFFQSxJQUFHLEVBQUUsQ0FBQyxpQkFBSCxDQUFxQixTQUFyQixDQUFIO2VBQ0gsbUJBREc7T0FBQSxNQUFBO2VBR0gsaUJBSEc7O0lBYlc7Ozs7OztFQWtCcEIsTUFBTSxDQUFDLE9BQVAsR0FBaUIsSUFBSTtBQXRCckIiLCJzb3VyY2VzQ29udGVudCI6WyJmcyA9IHJlcXVpcmUgJ2ZzLXBsdXMnXG5wYXRoID0gcmVxdWlyZSAncGF0aCdcblxuY2xhc3MgRGVmYXVsdEZpbGVJY29uc1xuICBpY29uQ2xhc3NGb3JQYXRoOiAoZmlsZVBhdGgpIC0+XG4gICAgZXh0ZW5zaW9uID0gcGF0aC5leHRuYW1lKGZpbGVQYXRoKVxuXG4gICAgaWYgZnMuaXNTeW1ib2xpY0xpbmtTeW5jKGZpbGVQYXRoKVxuICAgICAgJ2ljb24tZmlsZS1zeW1saW5rLWZpbGUnXG4gICAgZWxzZSBpZiBmcy5pc1JlYWRtZVBhdGgoZmlsZVBhdGgpXG4gICAgICAnaWNvbi1ib29rJ1xuICAgIGVsc2UgaWYgZnMuaXNDb21wcmVzc2VkRXh0ZW5zaW9uKGV4dGVuc2lvbilcbiAgICAgICdpY29uLWZpbGUtemlwJ1xuICAgIGVsc2UgaWYgZnMuaXNJbWFnZUV4dGVuc2lvbihleHRlbnNpb24pXG4gICAgICAnaWNvbi1maWxlLW1lZGlhJ1xuICAgIGVsc2UgaWYgZnMuaXNQZGZFeHRlbnNpb24oZXh0ZW5zaW9uKVxuICAgICAgJ2ljb24tZmlsZS1wZGYnXG4gICAgZWxzZSBpZiBmcy5pc0JpbmFyeUV4dGVuc2lvbihleHRlbnNpb24pXG4gICAgICAnaWNvbi1maWxlLWJpbmFyeSdcbiAgICBlbHNlXG4gICAgICAnaWNvbi1maWxlLXRleHQnXG5cbm1vZHVsZS5leHBvcnRzID0gbmV3IERlZmF1bHRGaWxlSWNvbnNcbiJdfQ==
