Object.defineProperty(exports, '__esModule', {
  value: true
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/** @babel */
/* global emit*/

var _async = require('async');

var _async2 = _interopRequireDefault(_async);

var _ctags = require('ctags');

var _ctags2 = _interopRequireDefault(_ctags);

var _getTagsFile = require('./get-tags-file');

var _getTagsFile2 = _interopRequireDefault(_getTagsFile);

exports['default'] = function (directoryPaths) {
  return _async2['default'].each(directoryPaths, function (directoryPath, done) {
    var tagsFilePath = (0, _getTagsFile2['default'])(directoryPath);
    if (!tagsFilePath) {
      return done();
    }

    var stream = _ctags2['default'].createReadStream(tagsFilePath);
    stream.on('data', function (tags) {
      for (var tag of Array.from(tags)) {
        tag.directory = directoryPath;
      }
      return emit('tags', tags);
    });
    stream.on('end', done);
    return stream.on('error', done);
  }, this.async());
};

module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9idWlsZC9hdG9tL3NyYy9hdG9tLTEuMzguMS9vdXQvYXBwL25vZGVfbW9kdWxlcy9zeW1ib2xzLXZpZXcvbGliL2xvYWQtdGFncy1oYW5kbGVyLmpzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7OztxQkFHa0IsT0FBTzs7OztxQkFDUCxPQUFPOzs7OzJCQUNELGlCQUFpQjs7OztxQkFFMUIsVUFBUyxjQUFjLEVBQUU7QUFDdEMsU0FBTyxtQkFBTSxJQUFJLENBQ2YsY0FBYyxFQUNkLFVBQUMsYUFBYSxFQUFFLElBQUksRUFBSztBQUN2QixRQUFJLFlBQVksR0FBRyw4QkFBWSxhQUFhLENBQUMsQ0FBQztBQUM5QyxRQUFJLENBQUMsWUFBWSxFQUFFO0FBQUUsYUFBTyxJQUFJLEVBQUUsQ0FBQztLQUFFOztBQUVyQyxRQUFJLE1BQU0sR0FBRyxtQkFBTSxnQkFBZ0IsQ0FBQyxZQUFZLENBQUMsQ0FBQztBQUNsRCxVQUFNLENBQUMsRUFBRSxDQUFDLE1BQU0sRUFBRSxVQUFTLElBQUksRUFBRTtBQUMvQixXQUFLLElBQU0sR0FBRyxJQUFJLEtBQUssQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLEVBQUU7QUFBRSxXQUFHLENBQUMsU0FBUyxHQUFHLGFBQWEsQ0FBQztPQUFFO0FBQ3RFLGFBQU8sSUFBSSxDQUFDLE1BQU0sRUFBRSxJQUFJLENBQUMsQ0FBQztLQUMzQixDQUFDLENBQUM7QUFDSCxVQUFNLENBQUMsRUFBRSxDQUFDLEtBQUssRUFBRSxJQUFJLENBQUMsQ0FBQztBQUN2QixXQUFPLE1BQU0sQ0FBQyxFQUFFLENBQUMsT0FBTyxFQUFFLElBQUksQ0FBQyxDQUFDO0dBQ2pDLEVBQ0MsSUFBSSxDQUFDLEtBQUssRUFBRSxDQUNmLENBQUM7Q0FDSCIsImZpbGUiOiIvYnVpbGQvYXRvbS9zcmMvYXRvbS0xLjM4LjEvb3V0L2FwcC9ub2RlX21vZHVsZXMvc3ltYm9scy12aWV3L2xpYi9sb2FkLXRhZ3MtaGFuZGxlci5qcyIsInNvdXJjZXNDb250ZW50IjpbIi8qKiBAYmFiZWwgKi9cbi8qIGdsb2JhbCBlbWl0Ki9cblxuaW1wb3J0IGFzeW5jIGZyb20gJ2FzeW5jJztcbmltcG9ydCBjdGFncyBmcm9tICdjdGFncyc7XG5pbXBvcnQgZ2V0VGFnc0ZpbGUgZnJvbSAnLi9nZXQtdGFncy1maWxlJztcblxuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24oZGlyZWN0b3J5UGF0aHMpIHtcbiAgcmV0dXJuIGFzeW5jLmVhY2goXG4gICAgZGlyZWN0b3J5UGF0aHMsXG4gICAgKGRpcmVjdG9yeVBhdGgsIGRvbmUpID0+IHtcbiAgICAgIGxldCB0YWdzRmlsZVBhdGggPSBnZXRUYWdzRmlsZShkaXJlY3RvcnlQYXRoKTtcbiAgICAgIGlmICghdGFnc0ZpbGVQYXRoKSB7IHJldHVybiBkb25lKCk7IH1cblxuICAgICAgbGV0IHN0cmVhbSA9IGN0YWdzLmNyZWF0ZVJlYWRTdHJlYW0odGFnc0ZpbGVQYXRoKTtcbiAgICAgIHN0cmVhbS5vbignZGF0YScsIGZ1bmN0aW9uKHRhZ3MpIHtcbiAgICAgICAgZm9yIChjb25zdCB0YWcgb2YgQXJyYXkuZnJvbSh0YWdzKSkgeyB0YWcuZGlyZWN0b3J5ID0gZGlyZWN0b3J5UGF0aDsgfVxuICAgICAgICByZXR1cm4gZW1pdCgndGFncycsIHRhZ3MpO1xuICAgICAgfSk7XG4gICAgICBzdHJlYW0ub24oJ2VuZCcsIGRvbmUpO1xuICAgICAgcmV0dXJuIHN0cmVhbS5vbignZXJyb3InLCBkb25lKTtcbiAgICB9XG4gICAgLCB0aGlzLmFzeW5jKClcbiAgKTtcbn1cbiJdfQ==