(function() {
  var CompositeDisposable, CursorPositionView, Emitter, FileInfoView, GitView, Grim, LaunchModeView, SelectionCountView, StatusBarView, ref,
    slice = [].slice;

  ref = require('atom'), CompositeDisposable = ref.CompositeDisposable, Emitter = ref.Emitter;

  Grim = require('grim');

  StatusBarView = require('./status-bar-view');

  FileInfoView = require('./file-info-view');

  CursorPositionView = require('./cursor-position-view');

  SelectionCountView = require('./selection-count-view');

  GitView = require('./git-view');

  LaunchModeView = require('./launch-mode-view');

  module.exports = {
    activate: function() {
      var devMode, launchModeView, ref1, safeMode;
      this.emitters = new Emitter();
      this.subscriptions = new CompositeDisposable();
      this.statusBar = new StatusBarView();
      this.attachStatusBar();
      this.subscriptions.add(atom.config.onDidChange('status-bar.fullWidth', (function(_this) {
        return function() {
          return _this.attachStatusBar();
        };
      })(this)));
      this.updateStatusBarVisibility();
      this.statusBarVisibilitySubscription = atom.config.observe('status-bar.isVisible', (function(_this) {
        return function() {
          return _this.updateStatusBarVisibility();
        };
      })(this));
      atom.commands.add('atom-workspace', 'status-bar:toggle', (function(_this) {
        return function() {
          if (_this.statusBarPanel.isVisible()) {
            return atom.config.set('status-bar.isVisible', false);
          } else {
            return atom.config.set('status-bar.isVisible', true);
          }
        };
      })(this));
      ref1 = atom.getLoadSettings(), safeMode = ref1.safeMode, devMode = ref1.devMode;
      if (safeMode || devMode) {
        launchModeView = new LaunchModeView({
          safeMode: safeMode,
          devMode: devMode
        });
        this.statusBar.addLeftTile({
          item: launchModeView.element,
          priority: -1
        });
      }
      this.fileInfo = new FileInfoView();
      this.statusBar.addLeftTile({
        item: this.fileInfo.element,
        priority: 0
      });
      this.cursorPosition = new CursorPositionView();
      this.statusBar.addLeftTile({
        item: this.cursorPosition.element,
        priority: 1
      });
      this.selectionCount = new SelectionCountView();
      this.statusBar.addLeftTile({
        item: this.selectionCount.element,
        priority: 2
      });
      this.gitInfo = new GitView();
      return this.gitInfoTile = this.statusBar.addRightTile({
        item: this.gitInfo.element,
        priority: 0
      });
    },
    deactivate: function() {
      var ref1, ref2, ref3, ref4, ref5, ref6, ref7, ref8, ref9;
      if ((ref1 = this.statusBarVisibilitySubscription) != null) {
        ref1.dispose();
      }
      this.statusBarVisibilitySubscription = null;
      if ((ref2 = this.gitInfo) != null) {
        ref2.destroy();
      }
      this.gitInfo = null;
      if ((ref3 = this.fileInfo) != null) {
        ref3.destroy();
      }
      this.fileInfo = null;
      if ((ref4 = this.cursorPosition) != null) {
        ref4.destroy();
      }
      this.cursorPosition = null;
      if ((ref5 = this.selectionCount) != null) {
        ref5.destroy();
      }
      this.selectionCount = null;
      if ((ref6 = this.statusBarPanel) != null) {
        ref6.destroy();
      }
      this.statusBarPanel = null;
      if ((ref7 = this.statusBar) != null) {
        ref7.destroy();
      }
      this.statusBar = null;
      if ((ref8 = this.subscriptions) != null) {
        ref8.dispose();
      }
      this.subscriptions = null;
      if ((ref9 = this.emitters) != null) {
        ref9.dispose();
      }
      this.emitters = null;
      if (atom.__workspaceView != null) {
        return delete atom.__workspaceView.statusBar;
      }
    },
    updateStatusBarVisibility: function() {
      if (atom.config.get('status-bar.isVisible')) {
        return this.statusBarPanel.show();
      } else {
        return this.statusBarPanel.hide();
      }
    },
    provideStatusBar: function() {
      return {
        addLeftTile: this.statusBar.addLeftTile.bind(this.statusBar),
        addRightTile: this.statusBar.addRightTile.bind(this.statusBar),
        getLeftTiles: this.statusBar.getLeftTiles.bind(this.statusBar),
        getRightTiles: this.statusBar.getRightTiles.bind(this.statusBar),
        disableGitInfoTile: this.gitInfoTile.destroy.bind(this.gitInfoTile)
      };
    },
    attachStatusBar: function() {
      var panelArgs;
      if (this.statusBarPanel != null) {
        this.statusBarPanel.destroy();
      }
      panelArgs = {
        item: this.statusBar,
        priority: 0
      };
      if (atom.config.get('status-bar.fullWidth')) {
        return this.statusBarPanel = atom.workspace.addFooterPanel(panelArgs);
      } else {
        return this.statusBarPanel = atom.workspace.addBottomPanel(panelArgs);
      }
    },
    legacyProvideStatusBar: function() {
      var statusbar;
      statusbar = this.provideStatusBar();
      return {
        addLeftTile: function() {
          var args;
          args = 1 <= arguments.length ? slice.call(arguments, 0) : [];
          Grim.deprecate("Use version ^1.0.0 of the status-bar Service API.");
          return statusbar.addLeftTile.apply(statusbar, args);
        },
        addRightTile: function() {
          var args;
          args = 1 <= arguments.length ? slice.call(arguments, 0) : [];
          Grim.deprecate("Use version ^1.0.0 of the status-bar Service API.");
          return statusbar.addRightTile.apply(statusbar, args);
        },
        getLeftTiles: function() {
          Grim.deprecate("Use version ^1.0.0 of the status-bar Service API.");
          return statusbar.getLeftTiles();
        },
        getRightTiles: function() {
          Grim.deprecate("Use version ^1.0.0 of the status-bar Service API.");
          return statusbar.getRightTiles();
        }
      };
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
