Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _atom = require('atom');

var _generalPanel = require('./general-panel');

var _generalPanel2 = _interopRequireDefault(_generalPanel);

var _editorPanel = require('./editor-panel');

var _editorPanel2 = _interopRequireDefault(_editorPanel);

var _packageDetailView = require('./package-detail-view');

var _packageDetailView2 = _interopRequireDefault(_packageDetailView);

var _keybindingsPanel = require('./keybindings-panel');

var _keybindingsPanel2 = _interopRequireDefault(_keybindingsPanel);

var _installPanel = require('./install-panel');

var _installPanel2 = _interopRequireDefault(_installPanel);

var _themesPanel = require('./themes-panel');

var _themesPanel2 = _interopRequireDefault(_themesPanel);

var _installedPackagesPanel = require('./installed-packages-panel');

var _installedPackagesPanel2 = _interopRequireDefault(_installedPackagesPanel);

var _updatesPanel = require('./updates-panel');

var _updatesPanel2 = _interopRequireDefault(_updatesPanel);

var _uriHandlerPanel = require('./uri-handler-panel');

var _uriHandlerPanel2 = _interopRequireDefault(_uriHandlerPanel);

var SettingsView = (function () {
  function SettingsView() {
    var _this = this;

    var _ref = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

    var uri = _ref.uri;
    var packageManager = _ref.packageManager;
    var snippetsProvider = _ref.snippetsProvider;
    var activePanel = _ref.activePanel;

    _classCallCheck(this, SettingsView);

    this.uri = uri;
    this.packageManager = packageManager;
    this.snippetsProvider = snippetsProvider;
    this.deferredPanel = activePanel;
    this.destroyed = false;
    this.panelsByName = {};
    this.panelCreateCallbacks = {};

    _etch2['default'].initialize(this);
    this.disposables = new _atom.CompositeDisposable();
    this.disposables.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));

    this.disposables.add(atom.packages.onDidActivateInitialPackages(function () {
      _this.disposables.add(atom.packages.onDidActivatePackage(function (pack) {
        return _this.removePanelCache(pack.name);
      }), atom.packages.onDidDeactivatePackage(function (pack) {
        return _this.removePanelCache(pack.name);
      }));
    }));

    process.nextTick(function () {
      return _this.initializePanels();
    });
  }

  _createClass(SettingsView, [{
    key: 'removePanelCache',
    value: function removePanelCache(name) {
      delete this.panelsByName[name];
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'destroy',
    value: function destroy() {
      this.destroyed = true;
      this.disposables.dispose();
      for (var _name in this.panelsByName) {
        var panel = this.panelsByName[_name];
        panel.destroy();
      }

      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'settings-view pane-item', tabIndex: '-1' },
        _etch2['default'].dom(
          'div',
          { className: 'config-menu', ref: 'sidebar' },
          _etch2['default'].dom(
            'ul',
            { className: 'panels-menu nav nav-pills nav-stacked', ref: 'panelMenu' },
            _etch2['default'].dom('div', { className: 'panel-menu-separator', ref: 'menuSeparator' })
          ),
          _etch2['default'].dom(
            'div',
            { className: 'button-area' },
            _etch2['default'].dom(
              'button',
              { className: 'btn btn-default icon icon-link-external', ref: 'openDotAtom' },
              'Open Config Folder'
            )
          )
        ),
        _etch2['default'].dom('div', { className: 'panels', tabIndex: '-1', ref: 'panels' })
      );
    }

    // This prevents the view being actually disposed when closed
    // If you remove it you will need to ensure the cached settingsView
    // in main.coffee is correctly released on close as well...
  }, {
    key: 'onDidChangeTitle',
    value: function onDidChangeTitle() {
      return new _atom.Disposable();
    }
  }, {
    key: 'initializePanels',
    value: function initializePanels() {
      var _this2 = this;

      if (this.refs.panels.children.length > 1) {
        return;
      }

      var clickHandler = function clickHandler(event) {
        var target = event.target.closest('.panels-menu li a, .panels-packages li a');
        if (target) {
          _this2.showPanel(target.closest('li').name);
        }
      };
      this.element.addEventListener('click', clickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        return _this2.element.removeEventListener('click', clickHandler);
      }));

      var focusHandler = function focusHandler() {
        _this2.focusActivePanel();
      };
      this.element.addEventListener('focus', focusHandler);
      this.disposables.add(new _atom.Disposable(function () {
        return _this2.element.removeEventListener('focus', focusHandler);
      }));

      var openDotAtomClickHandler = function openDotAtomClickHandler() {
        atom.open({ pathsToOpen: [atom.getConfigDirPath()] });
      };
      this.refs.openDotAtom.addEventListener('click', openDotAtomClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        return _this2.refs.openDotAtom.removeEventListener('click', openDotAtomClickHandler);
      }));

      this.addCorePanel('Core', 'settings', function () {
        return new _generalPanel2['default']();
      });
      this.addCorePanel('Editor', 'code', function () {
        return new _editorPanel2['default']();
      });
      if (atom.config.getSchema('core.uriHandlerRegistration').type !== 'any') {
        // "feature flag" based on core support for URI handling
        this.addCorePanel('URI Handling', 'link', function () {
          return new _uriHandlerPanel2['default']();
        });
      }
      if (process.platform === 'win32' && require('atom').WinShell != null) {
        (function () {
          var SystemPanel = require('./system-windows-panel');
          _this2.addCorePanel('System', 'device-desktop', function () {
            return new SystemPanel();
          });
        })();
      }
      this.addCorePanel('Keybindings', 'keyboard', function () {
        return new _keybindingsPanel2['default']();
      });
      this.addCorePanel('Packages', 'package', function () {
        return new _installedPackagesPanel2['default'](_this2, _this2.packageManager);
      });
      this.addCorePanel('Themes', 'paintcan', function () {
        return new _themesPanel2['default'](_this2, _this2.packageManager);
      });
      this.addCorePanel('Updates', 'cloud-download', function () {
        return new _updatesPanel2['default'](_this2, _this2.packageManager);
      });
      this.addCorePanel('Install', 'plus', function () {
        return new _installPanel2['default'](_this2, _this2.packageManager);
      });

      this.showDeferredPanel();

      if (!this.activePanel) {
        this.showPanel('Core');
      }

      if (document.body.contains(this.element)) {
        this.refs.sidebar.style.width = this.refs.sidebar.offsetWidth;
      }
    }
  }, {
    key: 'serialize',
    value: function serialize() {
      return {
        deserializer: 'SettingsView',
        version: 2,
        activePanel: this.activePanel != null ? this.activePanel : this.deferredPanel,
        uri: this.uri
      };
    }
  }, {
    key: 'getPackages',
    value: function getPackages() {
      var _this3 = this;

      var bundledPackageMetadataCache = undefined;
      if (this.packages != null) {
        return this.packages;
      }

      this.packages = atom.packages.getLoadedPackages();

      try {
        var packageMetadata = require(_path2['default'].join(atom.getLoadSettings().resourcePath, 'package.json'));
        bundledPackageMetadataCache = packageMetadata ? packageMetadata._atomPackages : null;
      } catch (error) {}

      // Include disabled packages so they can be re-enabled from the UI
      var disabledPackages = atom.config.get('core.disabledPackages') || [];
      for (var packageName of disabledPackages) {
        var metadata;
        var packagePath = atom.packages.resolvePackagePath(packageName);
        if (!packagePath) {
          continue;
        }

        try {
          metadata = require(_path2['default'].join(packagePath, 'package.json'));
        } catch (error) {
          if (bundledPackageMetadataCache && bundledPackageMetadataCache[packageName]) {
            metadata = bundledPackageMetadataCache[packageName].metadata;
          }
        }
        if (metadata == null) {
          continue;
        }

        var _name2 = metadata.name != null ? metadata.name : packageName;
        if (!_underscorePlus2['default'].findWhere(this.packages, { name: _name2 })) {
          this.packages.push({ name: _name2, metadata: metadata, path: packagePath });
        }
      }

      this.packages.sort(function (pack1, pack2) {
        var title1 = _this3.packageManager.getPackageTitle(pack1);
        var title2 = _this3.packageManager.getPackageTitle(pack2);
        return title1.localeCompare(title2);
      });

      return this.packages;
    }
  }, {
    key: 'addCorePanel',
    value: function addCorePanel(name, iconName, panelCreateCallback) {
      var panelMenuItem = document.createElement('li');
      panelMenuItem.name = name;
      panelMenuItem.setAttribute('name', name);

      var a = document.createElement('a');
      a.classList.add('icon', 'icon-' + iconName);
      a.textContent = name;
      panelMenuItem.appendChild(a);

      this.refs.menuSeparator.parentElement.insertBefore(panelMenuItem, this.refs.menuSeparator);
      this.addPanel(name, panelCreateCallback);
    }
  }, {
    key: 'addPanel',
    value: function addPanel(name, panelCreateCallback) {
      this.panelCreateCallbacks[name] = panelCreateCallback;
      if (this.deferredPanel && this.deferredPanel.name === name) {
        this.showDeferredPanel();
      }
    }
  }, {
    key: 'getOrCreatePanel',
    value: function getOrCreatePanel(name, options) {
      var panel = this.panelsByName[name];
      if (panel) return panel;

      if (name in this.panelCreateCallbacks) {
        panel = this.panelCreateCallbacks[name]();
        delete this.panelCreateCallbacks[name];
      } else if (options && options.pack) {
        if (!options.pack.metadata) {
          options.pack.metadata = _underscorePlus2['default'].clone(options.pack);
        }
        panel = new _packageDetailView2['default'](options.pack, this, this.packageManager, this.snippetsProvider);
      }
      if (panel) {
        this.panelsByName[name] = panel;
      }

      return panel;
    }
  }, {
    key: 'makePanelMenuActive',
    value: function makePanelMenuActive(name) {
      var previouslyActivePanel = this.refs.sidebar.querySelector('.active');
      if (previouslyActivePanel) {
        previouslyActivePanel.classList.remove('active');
      }

      var newActivePanel = this.refs.sidebar.querySelector('[name=\'' + name + '\']');
      if (newActivePanel) {
        newActivePanel.classList.add('active');
      }
    }
  }, {
    key: 'focusActivePanel',
    value: function focusActivePanel() {
      // Pass focus to panel that is currently visible
      for (var i = 0; i < this.refs.panels.children.length; i++) {
        var child = this.refs.panels.children[i];
        if (child.offsetWidth > 0) {
          child.focus();
        }
      }
    }
  }, {
    key: 'showDeferredPanel',
    value: function showDeferredPanel() {
      if (this.deferredPanel) {
        var _deferredPanel = this.deferredPanel;
        var _name3 = _deferredPanel.name;
        var options = _deferredPanel.options;

        this.showPanel(_name3, options);
      }
    }

    // Public: show a panel.
    //
    // * `name` {String} the name of the panel to show
    // * `options` {Object} an options hash. Will be passed to `beforeShow()` on
    //   the panel. Options may include (but are not limited to):
    //   * `uri` the URI the panel was launched from
  }, {
    key: 'showPanel',
    value: function showPanel(name, options) {
      var panel = this.getOrCreatePanel(name, options);
      if (panel) {
        this.appendPanel(panel, options);
        this.makePanelMenuActive(name);
        this.setActivePanel(name, options);
        this.deferredPanel = null;
      } else {
        this.deferredPanel = { name: name, options: options };
      }
    }
  }, {
    key: 'showPanelForURI',
    value: function showPanelForURI(uri) {
      var regex = /config\/([a-z]+)\/?([a-zA-Z0-9_-]+)?/i;
      var match = regex.exec(uri);

      if (match) {
        var path1 = match[1];
        var path2 = match[2];

        if (path1 === 'packages' && path2 != null) {
          this.showPanel(path2, {
            uri: uri,
            pack: { name: path2 },
            back: atom.packages.getLoadedPackage(path2) ? 'Packages' : null
          });
        } else {
          var panelName = path1[0].toUpperCase() + path1.slice(1);
          this.showPanel(panelName, { uri: uri });
        }
      }
    }
  }, {
    key: 'appendPanel',
    value: function appendPanel(panel, options) {
      for (var i = 0; i < this.refs.panels.children.length; i++) {
        this.refs.panels.children[i].style.display = 'none';
      }

      if (!this.refs.panels.contains(panel.element)) {
        this.refs.panels.appendChild(panel.element);
      }

      if (panel.beforeShow) {
        panel.beforeShow(options);
      }
      panel.show();
      panel.focus();
    }
  }, {
    key: 'setActivePanel',
    value: function setActivePanel(name) {
      var options = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

      this.activePanel = { name: name, options: options };
    }
  }, {
    key: 'removePanel',
    value: function removePanel(name) {
      var panel = this.panelsByName[name];
      if (panel) {
        panel.destroy();
        delete this.panelsByName[name];
      }
    }
  }, {
    key: 'getTitle',
    value: function getTitle() {
      return 'Settings';
    }
  }, {
    key: 'getIconName',
    value: function getIconName() {
      return 'tools';
    }
  }, {
    key: 'getURI',
    value: function getURI() {
      return this.uri;
    }
  }, {
    key: 'isEqual',
    value: function isEqual(other) {
      return other instanceof SettingsView;
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return SettingsView;
})();

exports['default'] = SettingsView;
module.exports = exports['default'];
/* The tabindex attr below ensures that clicks in a panel item won't
cause this view to gain focus. This is important because when this view
gains focus (e.g. immediately after atom displays it), it focuses the
currently active panel item. If that focusing causes the active panel to
scroll (e.g. because the active panel itself passes focus on to a search
box at the top of a scrolled panel), then the browser will not fire the
click event on the element within the panel on which the user originally
clicked (e.g. a package card). This would prevent us from showing a
package detail view when clicking on a package card. Phew! */
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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